/* ".LST" file output for gpasm
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "gpasm.h"

void lst_throw()
{
  state.lst.page++;
  fprintf(state.lst.f,
	  "%s%-32s%-12s%-29sPAGE %2d\n%s\n",
	  (state.lst.page == 1) ? "" : "\f",
	  GPASM_VERSION_STRING,
	  state.srcfilename,
	  state.lst.startdate,
	  state.lst.page,
	  state.lst.title_name);
  state.lst.lineofpage = 2;
}

void lst_line(char *line)
{
  if (state.lst.f) {
    if ((state.lst.lineofpage++ % state.lst.linesperpage) == 0) {
      lst_throw();
    }
    fprintf(state.lst.f, "%s\n", line);
  }
}

void lst_init()
{
  char *pc;

  state.lst.linesperpage = 60;
  state.lst.symboltable = 1;

  switch (state.lstfile) {
  case suppress:
    state.lst.f = NULL;
    state.lst.enabled = 0;
    break;
  case normal:
    strcpy(state.lstfilename, state.srcfilename);
    pc = strrchr(state.lstfilename, '.');
    if (pc == NULL)
      pc = state.lstfilename + strlen(state.lstfilename);
    strcpy(pc, ".lst");
  case named:
    /* Don't need to do anything - name is already set up */
    state.lst.f = fopen(state.lstfilename, "w");
    if (state.lst.f == NULL) {
      perror(state.lstfilename);
      exit(1);
    }
    state.lst.enabled = 1;
  }

  /* Determine state.startdate */
  {
    time_t now;
    struct tm *now_tm;

    time(&now);
    now_tm = localtime(&now);
    sprintf(state.lst.startdate,
	    "%d-%d-%d  %02d:%02d:%02d",
	    now_tm->tm_mon,
	    now_tm->tm_mday,
	    1900 + now_tm->tm_year,
	    now_tm->tm_hour,
	    now_tm->tm_min,
	    now_tm->tm_sec);
  }

  state.lst.tabstop = 8;	/* Default tabstop every 8 */

  lst_line("");
  lst_line("");
  lst_line("LOC  OBJECT CODE     LINE SOURCE TEXT");
  lst_line("  VALUE");
}

void lst_close()
{
  fprintf(state.lst.f,
	  "\n\n");
  fprintf(state.lst.f,
	  "Errors   : %7d\n",
	  state.num.errors);
  fprintf(state.lst.f,
	  "Warnings : %7d\n",
	  state.num.warnings);
  fprintf(state.lst.f,
	  "Messages : %7d\n",
	  state.num.messages);
  fprintf(state.lst.f,
	  "\f\n");

  fclose(state.lst.f);
}
