#include "npauthentication.h"

class NP_Subscription
{
   char error_message[ 1024 ], *newsrc_path, *temp_path;
   const char *home;

   int total;

   NP_File newsrc_file;
   NP_Stringarray server_names;
   NP_Authentication authentication;

   struct group_list_t
   {
      const char *server;
      NP_Stringarray *group_names;
      NP_Stringarray *article_nos;
   }
   *group_list;

   group_list_t *get_group_entry( const char * );
   
 public:

   NP_Subscription();
   ~NP_Subscription();

   add_server( const char * );
   add_server( const char *, int );
   
   remove_server( const char * );
   remove_server( int );

   replace_user( int, const char * );
   replace_pass( int, const char * );
   
   const char *operator[]( int );
   int operator[]( const char * );
   
   add_group( int, const char *, const char * );
   add_group( const char *, const char * );

   remove_group( int, int );
   remove_group( int, const char * );
   remove_group( const char *, const char * );
   remove_group( const char *, int );
   clear_server( int );
   sort_groups( int );
   
   save();
   load();

   int get_total();
   int get_total_groups( int );

   const char *get_group( int, int );
   const char *get_article_no( int, int );
   
   const char *get_user( int );
   const char *get_pass( int );
   
   int clear();
   
   char *get_error() { return error_message; };
   void print_error() { fprintf( stderr, "%s\n", error_message ); };
};


