/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include <string.h>

#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>

#include "debug.h"
#include "queue-item.h"

/*********************
**********************  Defines / Enumerated types
*********************/

/*********************
**********************  Macros
*********************/

/*********************
**********************  Structures / Typedefs
*********************/

/*********************
**********************  Private Function Prototypes
*********************/

/*********************
**********************  Variables
*********************/

/***********
************  Extern
***********/

/***********
************  Public
***********/

/***********
************  Private
***********/

/*********************
**********************  BEGINNING OF SOURCE
*********************/

/************
*************  PUBLIC ROUTINES
************/

/*****
******
*****/

void
queue_item_constructor (
	QueueItem *item,
	PanObjectDestructor destructor,
	StatusItemDescribeFunc describe,
	QueueItemRunFunc run,
	server_data *sdata,
	gboolean high_priority,
	gboolean needs_socket)
{
	status_item_constructor (STATUS_ITEM(item), destructor, describe);

	item->abort = FALSE;
	item->sdata = sdata;
	item->high_priority = high_priority;
	item->thread_id = 0;
	item->needs_socket = needs_socket;
	item->sock = NULL;
	item->is_paused = FALSE;
	item->is_leech = FALSE;
	item->run = run;

        debug (DEBUG_PAN_OBJECT, "queue_item constructor: %p", item);
}

void
queue_item_destructor (PanObject* item)
{
        debug (DEBUG_PAN_OBJECT, "queue_item destructor: %p", item);
	status_item_destructor (PAN_OBJECT(item));
}

/*****
******
*****/

gint
queue_item_run (QueueItem *item)
{
	gint retval = 0;

	if (!item)
		retval = -1;
	else
	{
        	retval = (*item->run)(item);
		status_item_emit_done (STATUS_ITEM(item), retval);
	}

	return retval;
}

/*****
******
*****/

gboolean
queue_item_is_high_priority (const QueueItem *item)
{
	g_return_val_if_fail (item!=NULL, FALSE);

	return item->high_priority;
}

/*****
******
*****/

gboolean
queue_item_needs_socket (const QueueItem *item)
{
	g_return_val_if_fail (item!=NULL, FALSE);

	return item->needs_socket;
}

PanSocket*
queue_item_get_socket (QueueItem *item)
{
	g_return_val_if_fail (item!=NULL, NULL);

	return item->sock;
}

void
queue_item_set_socket (QueueItem *item, PanSocket *sock)
{
	g_return_if_fail (item!=NULL);
	g_return_if_fail (sock!=NULL);

	item->sock = sock;
}

void
queue_item_set_paused (QueueItem *item, gboolean paused)
{
	g_return_if_fail (item!=NULL);

	item->is_paused = paused;
}

gboolean
queue_item_is_paused (const QueueItem* item)
{
	g_return_val_if_fail (item!=NULL, TRUE);

	return item->is_paused;
}

extern const gchar* sockread_err_msg;
extern const gchar* sockwrite_err_msg;

void
queue_item_emit_sockread_err (QueueItem *item)
{
	status_item_emit_error (STATUS_ITEM(item), sockread_err_msg);
}

void
queue_item_emit_sockwrite_err (QueueItem *item)
{
	status_item_emit_error (STATUS_ITEM(item), sockwrite_err_msg);
}

void
queue_item_abort (QueueItem *item)
{
	item->abort = TRUE;
}
