/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@goatnet.ml.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@goatnet.ml.org>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void get_history __P((void));
void parse_histent __P((char *, struct histent *, int));

__END_DECLS

void
get_history(void)
{
  FILE *fp;
  char *buf;
  char buffer[BUFSIZE];
  int len, i=0;

  he = malloc(256 * sizeof(struct histent));

  /*
   * Buffer overflow checking for $HOME unnessary.
   */

  len = strlen(getenv("HOME"));
  buf = malloc(len+strlen(HISTFILE)+1);
  sprintf(buf,"%s%s",getenv("HOME"),HISTFILE);

  /*
   * If there are no history file set HIST_FLAG to 1 and return.
   */

  if (!(fp = fopen(buf,"r")))
    {
      /*      history_list = g_list_insert_sorted(history_list, "",
	      (GCompareFunc)strcmp); */
      HIST_FLAG=1;
      return;
    }

  /*
   * Read the history entrys from the file descriptor and add to GList.
   */

  i=0;
  while (fgets(buffer,BUFSIZE-1,fp))
    {
      parse_histent(buffer, he, i);

#ifdef DEBUG
      fprintf(stderr, "*** get_history() *** he[%d].object: \"%s\" he[%d].server: \"%s\"\n",
	      i, he[i].object, i, he[i].server);
#endif /* DEBUG */

      history_list = g_list_insert_sorted(history_list, he[i].object,
					  (GCompareFunc)strcmp);
      i++;
    }

  fclose(fp);
  free(buf);
}

void
parse_histent(buf, he, count)
     char *buf;
     struct histent *he;
     int count;
{
  char tmp[BUFSIZE];
  int i = 0, c = 0;

  while (buf[i] != '\0' && buf[i] != '#')
    {
      i++;
    }

  he[count].object = malloc(i+1);
  snprintf(he[count].object, i, "%s", buf);

  i=i+2;

  while (buf[i] != '\n')
    {
      tmp[c] = buf[i];
      c++; i++;
    }
  tmp[c]='\0';

  /*
  for (i=0 ; buf[i] != '#' ; i++)
    {
      buf++;
    }
  buf++; buf++; buf++; buf++;

  he[count].server = malloc(strlen(buf)+1);
  snprintf(he[count].server, strlen(buf), "%s", buf);
  */

  he[count].server = malloc(strlen(tmp)+1);
  snprintf(he[count].server, strlen(buf), "%s", tmp);
}
