#!/bin/sh

if [ "$1" = "-c" ]
then
  LN='cp -pu'
  shift
else
  LN='ln -fs'
fi

echo -n new top directory[obj.`uname`]?' '
read inbuf
if [ "x$inbuf" = "x" ]
then
  LINKPATH=obj.`uname`
else
  LINKPATH=$inbuf
fi

echo -n making directories in $LINKPATH':'
find $* -type d -exec mkdir -p $LINKPATH/{} \; -exec echo ' '{} \;
echo done

echo linking source files to $LINKPATH':'
find $* -type f -exec $LN `pwd`/{} $LINKPATH/{} \; -exec echo ' '{} \;
echo done

$LN `pwd`/configure $LINKPATH/configure
$LN `pwd`/etc $LINKPATH/etc

cat `pwd`/makefile | sed -e '/^\#TOP_BEGIN/,/^\#TOP_END/d' > $LINKPATH/makefile
