/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#include <sys/types.h>
#endif
#include <sys/time.h>
#include "main.h"

extern char PFTP_SORT_BY;


long time_cmp(char *s, char *t)
{
   char str1[LONAME];
   char str2[LONAME];

   strcpy(str1, s+DATECOLUMN);
   *(str1+USERCOLUMN-1) = '\0';
   strcpy(str2, t+DATECOLUMN);
   *(str2+USERCOLUMN-1) = '\0';

   return atol(str1) - atol(str2);
}


void bubble_menu(char **pmain, int size)
{
   long i, j;
   char *tmp=NULL;

   for (i=1; i < size; i++) {
      for (j=size-1; j >= i; j--) {
         if (time_cmp(*(pmain+j-1), *(pmain+j)) > 0) {
            tmp = *(pmain+j-1);
            *(pmain+j-1) = *(pmain+j);
            *(pmain+j) = tmp;
         }
      }
   }
}


void bubble_sort(char **vec, char *pdir, long size)
{
   long i, j;
   char *tmp=NULL;
   char *str=NULL;
   struct stat buf;

   if (PFTP_SORT_BY == 'a') { /* sort alphabetically */
      for (i=1; i < size; i++) {
         for (j=size-1; j >= i; j--) {
            if (strcmp(*(vec+j-1), *(vec+j)) > 0) {
               tmp = *(vec+j-1);
               *(vec+j-1) = *(vec+j);
               *(vec+j) = tmp;
            }
         }
      }
   }
   else if (PFTP_SORT_BY == 't') { /* sort by time */
      time_t first=0, second=0;
      MEM_CHECK((str = (char *)calloc(LONAME, sizeof(char))));
      for (i=1; i < size; i++) {
         for (j=size-1; j >= i; j--) {
            sprintf(str, "%s/%s", pdir, *(vec+j-1));
            stat(str, &buf);
            first = buf.st_ctime;
            sprintf(str, "%s/%s", pdir, *(vec+j));
            stat(str, &buf);
            second = buf.st_ctime;
            if (first > second) {
               tmp = *(vec+j-1);
               *(vec+j-1) = *(vec+j);
               *(vec+j) = tmp;
            }
         }
      }
      free(str);
   }
   else if (PFTP_SORT_BY == 's') { /* sort by size */
      off_t first=0, second=0;
      MEM_CHECK((str = (char *)calloc(LONAME, sizeof(char))));
      for (i=1; i < size; i++) {
         for (j=size-1; j >= i; j--) {
            sprintf(str, "%s/%s", pdir, *(vec+j-1));
            stat(str, &buf);
            first = buf.st_size;
            sprintf(str, "%s/%s", pdir, *(vec+j));
            stat(str, &buf);
            second = buf.st_size;
            if (first > second) {
               tmp = *(vec+j-1);
               *(vec+j-1) = *(vec+j);
               *(vec+j) = tmp;
            }
         }
      }
      free(str);
   }
}
