/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <ctype.h>
#include <syslog.h>
#include <string.h>
#include <stdlib.h>

#include "mserver.h"

int getstat_pppdlock(void);
int getstat_lockonly(void);
int getstat_netdev(void);
int getstat_exitcode(void);

int getstat(void)
{
	char stattype[1024];

	config_getvalue_default ("stattype", stattype, "pppdlock", 1024);

	if (!strncmp("pppdlock", stattype, 1024))
	{
		return getstat_pppdlock();
	}
	else if (!strncmp("lockonly", stattype, 1024))
	{
		return getstat_lockonly();
	}
	else if (!strncmp("netdev", stattype, 1024))
	{
		return getstat_netdev();
	}
	else if (!strncmp("exitcode", stattype, 1024))
	{
		return getstat_exitcode();
	}
	else
	{
		syslog(LOG_ERR, "Undefined stat type: %s", stattype);
		return false;
	}
}

int getstat_netdev(void)
{
	FILE *netdev;
	
	char devfile[1024];
	char searchdev[1024];
	char temp[1024];

	bool found;

	config_getvalue_default("devfile", devfile, "/proc/net/dev", 1024);
#ifndef UTIL
	config_getvalue_cname("netdev", searchdev, 1024);
#else
	config_getvalue("netdev", searchdev, 1024);
#endif

	netdev = fopen(devfile, "r");
	
	if (netdev == NULL)
	{
		syslog(LOG_WARNING, "Could not open net device file: %s", devfile);
	}

	/* Ignore the first two lines */
	fgets(temp, 1024, netdev);
	fgets(temp, 1024, netdev);

	found = false;

#ifdef DEBUG
 	syslog(LOG_DEBUG, "searching for: %s", searchdev);
#endif

	while ((fgets(temp, 1024, netdev) != NULL) && found == false)
	{
		int i;
		int n;
		size_t len;

#ifdef DEBUG
 	syslog(LOG_DEBUG, "got line: %s", temp);
#endif

		len = strlen(temp);
		for (i = 0; i < len && isspace(temp[i]); i++);
		for (n = i; n < len && temp[n] != ':'; n++);
		temp[n] = '\0';

#ifdef DEBUG
		syslog(LOG_DEBUG, "found device: [%s]", &temp[i]);
#endif

		if (!strncmp(&temp[i], searchdev, 1024))
		{
			found = true;
		}	
	}

	fclose(netdev);

	return found;
}

int getstat_pppdlock(void)
{
	FILE *lock;
	FILE *proc;
	int pid;

	char temp[1024];
	char pidtemp[1024];
	char lockfile[1024];

	config_getvalue("lockfile", lockfile, 1024);

	lock = fopen(lockfile, "r");

	if (lock == NULL)
	{
		return false;
	}
	fgets(temp, 1024, lock);
	fclose (lock);

	pid = atoi(temp);

	snprintf(pidtemp, 1024, "%d", pid);	
	snprintf(temp, 1024, "/proc/%s/status", pidtemp);		
	proc = fopen (temp, "r");
	
	if (proc == NULL)
	{
		return false;
	}

	fgets(temp, 1024, proc);
	fclose (proc);

	/* Cut off the last character */
	temp[strlen(temp) - 1] = '\0';
		
	if (strncmp(&temp[strlen(temp) - 4], "pppd", 1025))
	{
		return false;
	}

	return true;
}

int getstat_lockonly(void)
{
	FILE *lock;

	char lockfile[1024];

	config_getvalue("lockfile", lockfile, 1024);

	lock = fopen(lockfile, "r");

	if (lock == NULL)
	{
		return false;
	}

	fclose (lock);

	return true;
}

int getstat_exitcode(void)
{
	char command[1024];
	char checkhost[1024];
	char temp[1024];

	config_getvalue("linkcheck", command, 1024);
#ifndef UTIL
	config_getvalue_cname("checkhost", checkhost, 1024);
#else
	config_getvalue("checkhost", checkhost, 1024);
#endif

	snprintf(temp, 1024, command, checkhost);

	if (util_system_wait(temp) == config_getvalue_int("goodcode", 0))
	{
		return true;
	}
	else	
	{
		return false;
	}
}
