#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <sys/types.h>

#include "gfcc.h"

extern struct _fwchain fwchain[];
extern struct _fwentry fwentry;
extern gint maxchains;

static GtkWidget *hostlist = NULL;
static GtkWidget *user_defined_host = NULL;
static GtkWidget *target = NULL;

static GtkWidget *menu_host_new;
static GtkWidget *menu_host_edit;
static GtkWidget *menu_host_delete;
static GtkWidget *host_popup = NULL;
static GtkWidget *create_host_popup_menu();

static GtkWidget *button_host_edit;
static GtkWidget *button_host_delete;
static GtkWidget *button_host_apply;

static GtkWidget *host_e_win = NULL;

static void host_edit_win_destroy(GtkWidget *, gpointer);
static void hwin_destroy(GtkWidget *, gpointer);
static void host_edit_window(GtkWidget *, RuleAction);
static void host_edit(GtkWidget *, RuleAction);
static void put_hostdata(GtkWidget *);
static void host_delete(GtkWidget *, gchar *);
static void host_apply(GtkWidget *, gchar *);
static void update_address_list(gchar *, gint);
static gint host_event_handler(GtkWidget *, GdkEvent*, gchar *);
static void host_select_handler(GtkWidget *,gint,gint,GdkEventButton*,gchar *);
static void host_unselect_handler(GtkWidget*,gint,gint,GdkEventButton*,gchar*);
static gint is_newname(gchar *, gchar *, gchar *, gint);

static GdkPixmap *pixmap;
static GdkBitmap *mask;
static guint8 spacing;

static void host_cancel(GtkWidget *w, gchar *data)
{
	gtk_widget_hide(gtk_widget_get_toplevel(w));
}

void get_host_name()
{
	FILE *fp;
	gchar buf[128];
	gchar hostname[32], hostip[32];
	gchar *content[2];
	gint row, nread;
	
	
	select_host_window(NULL, NULL);

	if(hostlist)
		gtk_clist_clear(GTK_CLIST(hostlist));
	
	content[0] = content_new("0.0.0.0/0");
	content[1] = content_new("Any");
	row = gtk_clist_append(GTK_CLIST(hostlist), content);
	g_free(content[0]);
	g_free(content[1]);

	fp = fopen("/etc/hosts", "r");
	if(!fp)
		goto USER_DEFINED_HOST;

	while(fgets(buf, sizeof(buf), fp)) {
		if(buf[0] == '#' || buf[0] == '\n')
			continue;
		nread = sscanf(buf, "%s %s", hostip, hostname);
		if(nread != 2)
			continue;

		strcat(hostip, "/32");
		content[0] = content_new(hostip);
		content[1] = content_new(hostname);
		row = gtk_clist_append(GTK_CLIST(hostlist), content);
		g_free(content[0]);
		g_free(content[1]);
	}
	fclose(fp);

USER_DEFINED_HOST:

	if(user_defined_host)
		gtk_clist_clear(GTK_CLIST(user_defined_host));

	fp = fopen(GFCC_HOME"/host_networks", "r");
	if(!fp)
		return;
	while(fgets(buf, sizeof(buf), fp)) {
		if(buf[0] == '#' || buf[0] == '\n')
			continue;
		nread = sscanf(buf, "%s %s", hostip, hostname);
		if(nread != 2)
			continue;

		content[0] = content_new(hostip);
		content[1] = content_new(hostname);
		row = gtk_clist_append(GTK_CLIST(user_defined_host), content);
		g_free(content[0]);
		g_free(content[1]);
	}
	fclose(fp);
}

static gint host_event_handler(
		GtkWidget *widget, GdkEvent *event, gchar *data)
{
	GList *selection;
	GdkEventButton *bevent;
	gint active;
	
	switch(event->type) {
	case GDK_BUTTON_PRESS:
		switch(event->button.button) {
		case 3:
			if(widget == hostlist)
				break;
			selection = GTK_CLIST(widget)->selection;
			active = selection ? TRUE : FALSE;
			gtk_widget_set_sensitive(menu_host_new, TRUE);
			gtk_widget_set_sensitive(menu_host_edit, active);
			gtk_widget_set_sensitive(menu_host_delete, active);
			bevent = (GdkEventButton *)event;
			gtk_menu_popup(GTK_MENU(host_popup), NULL, NULL,
				NULL, NULL, bevent->button, bevent->time);
			return TRUE;
		default: break;
		}
		break;
	case GDK_2BUTTON_PRESS:
		switch(event->button.button) {
		case 1:
			host_apply(widget, NULL);
			break;
		default: break;
		}
		break;
	default: break;
	}
	return FALSE;
}

static void host_select_handler(GtkWidget *widget, gint row, gint column,
		GdkEventButton *event, gchar *data)
{
	if(widget == hostlist) {
		gtk_clist_unselect_all(GTK_CLIST(user_defined_host));
		if(target)
			gtk_widget_set_sensitive(button_host_apply, TRUE);
		return;
	} else
		gtk_clist_unselect_all(GTK_CLIST(hostlist));

	if(target)
		gtk_widget_set_sensitive(button_host_apply, TRUE);
	gtk_widget_set_sensitive(button_host_edit, TRUE);
	gtk_widget_set_sensitive(button_host_delete, TRUE);
}

static void host_unselect_handler(GtkWidget *widget, gint row, gint column,
		GdkEventButton *event, gchar *data)
{
	gtk_widget_set_sensitive(button_host_apply, FALSE);
	gtk_widget_set_sensitive(button_host_edit, FALSE);
	gtk_widget_set_sensitive(button_host_delete, FALSE);
}

void call_select_host_window(GtkWidget *widget, GtkWidget *data)
{
	select_host_window(user_defined_host, NULL);
}

static void hwin_destroy(GtkWidget *widget, gpointer data)
{
	gtk_widget_hide(widget);
}

void select_host_window(GtkWidget *widget, GtkWidget *tmp_target)
{
	GtkWidget *vbox, *hbox;
	static GtkWidget *hwin=NULL;
	GtkWidget *scrolled_window;
	GtkWidget *label;
	GtkWidget *button;
	gchar *htitles[3] = { "IP address", "Host name" };
	
	target = tmp_target;
	
	if(hwin) {
		if(widget) {
			gtk_widget_show(hwin);
			gtk_clist_unselect_all(GTK_CLIST(hostlist));
			gtk_clist_unselect_all(GTK_CLIST(user_defined_host));
		}
		return;
	}
	if(!host_popup)
		host_popup = create_host_popup_menu();

	hwin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(hwin, 300, 400);
	gtk_window_set_title(GTK_WINDOW(hwin), "Host name");
	gtk_window_set_position(GTK_WINDOW(hwin), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width(GTK_CONTAINER(hwin), 10);
	gtk_signal_connect(GTK_OBJECT(hwin), "destroy",
			GTK_SIGNAL_FUNC(hwin_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(hwin), "delete_event",
			GTK_SIGNAL_FUNC(hwin_destroy), NULL);
	
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(hwin), vbox);
	gtk_widget_show(vbox);
	
	label = gfcc_label_new(vbox, "/etc/hosts");

	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(scrolled_window, -1, -1);
	gtk_scrolled_window_set_policy(
			GTK_SCROLLED_WINDOW(scrolled_window),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC); 
	gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
	gtk_widget_show(scrolled_window);

	hostlist = gtk_clist_new_with_titles(2, htitles);
	gtk_container_add(GTK_CONTAINER(scrolled_window), hostlist);
	gtk_signal_connect(GTK_OBJECT(hostlist), "event",
		GTK_SIGNAL_FUNC(host_event_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(hostlist), "select_row",
		GTK_SIGNAL_FUNC(host_select_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(hostlist), "unselect_row",
		GTK_SIGNAL_FUNC(host_unselect_handler), NULL);
	gtk_clist_set_column_width(GTK_CLIST(hostlist), 0, 110);
	gtk_widget_show(hostlist);
	
	label = gfcc_label_new(vbox, "user_defined");

	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(scrolled_window, -1, -1);
	gtk_scrolled_window_set_policy(
			GTK_SCROLLED_WINDOW(scrolled_window),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC); 
	gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
	gtk_widget_show(scrolled_window);

	user_defined_host = gtk_clist_new_with_titles(2, htitles);
	gtk_container_add(GTK_CONTAINER(scrolled_window), user_defined_host);
	gtk_signal_connect(GTK_OBJECT(user_defined_host), "event",
		GTK_SIGNAL_FUNC(host_event_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(user_defined_host), "select_row",
		GTK_SIGNAL_FUNC(host_select_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(user_defined_host), "unselect_row",
		GTK_SIGNAL_FUNC(host_unselect_handler), NULL);
	gtk_clist_set_column_width(GTK_CLIST(user_defined_host), 0, 110);
	gtk_widget_show(user_defined_host);
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_widget_show(hbox);
	
	button = gtk_button_new_with_label("New");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(host_edit_window), (RuleAction *)NEW);
	gtk_widget_show(button);
	
	button_host_edit = gtk_button_new_with_label("Edit");
	gtk_box_pack_start(GTK_BOX(hbox), button_host_edit, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button_host_edit), "clicked",
			GTK_SIGNAL_FUNC(host_edit_window), (RuleAction *)EDIT);
	gtk_widget_set_sensitive(button_host_edit, FALSE);
	gtk_widget_show(button_host_edit);
	
	button_host_delete = gtk_button_new_with_label("Delete");
	gtk_box_pack_start(GTK_BOX(hbox), button_host_delete, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button_host_delete), "clicked",
			GTK_SIGNAL_FUNC(host_delete), NULL);
	gtk_widget_set_sensitive(button_host_delete, FALSE);
	gtk_widget_show(button_host_delete);
	
	button_host_apply = gtk_button_new_with_label("Apply");
	gtk_box_pack_start(GTK_BOX(hbox), button_host_apply, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button_host_apply), "clicked",
			GTK_SIGNAL_FUNC(host_apply), NULL);
	gtk_widget_set_sensitive(button_host_apply, FALSE);
	gtk_widget_show(button_host_apply);
	
	button = gtk_button_new_with_label("Close");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(host_cancel), NULL);
	gtk_widget_show(button);

	if(widget)
		gtk_widget_show(hwin);
}

int host_iptoname(gchar *buf, gchar *ipaddr)
{
	gint i;
	gchar *host, *ip;
	
	for(i=0; i<GTK_CLIST(user_defined_host)->rows; i++) {
		gtk_clist_get_text(GTK_CLIST(user_defined_host), i, 0, &ip);
		gtk_clist_get_text(GTK_CLIST(user_defined_host), i, 1, &host);
		if(!strcmp(ip, ipaddr)) {
			strcpy(buf, host);
			return 0;
		}
	}
	for(i=0; i<GTK_CLIST(hostlist)->rows; i++) {
		gtk_clist_get_text(GTK_CLIST(hostlist), i, 0, &ip);
		gtk_clist_get_text(GTK_CLIST(hostlist), i, 1, &host);
		if(!strcmp(ip, ipaddr)) {
			strcpy(buf, host);
			return 0;
		}
	}
	strcpy(buf, ipaddr);
	
	return -1;
}

gint host_nametoip(gchar *buf, gchar *name)
{
	gint i;
	gchar *host, *ip;
	
	for(i=0; i<GTK_CLIST(user_defined_host)->rows; i++) {
		gtk_clist_get_text(GTK_CLIST(user_defined_host), i, 0, &ip);
		gtk_clist_get_text(GTK_CLIST(user_defined_host), i, 1, &host);
		if(!strcmp(host, name)) {
			strcpy(buf, ip);
			return 0;
		}
	}
	for(i=0; i<GTK_CLIST(hostlist)->rows; i++) {
		gtk_clist_get_text(GTK_CLIST(hostlist), i, 0, &ip);
		gtk_clist_get_text(GTK_CLIST(hostlist), i, 1, &host);
		if(!strcmp(host, name)) {
			strcpy(buf, ip);
			return 0;
		}
	}
	strcpy(buf, name);

	return check_host(buf);
}

gint check_host(gchar *buf)
{
	gint i, dot=0, slash=0, slashidx=0, nameflag=0;
	gint mask;
	gchar tmpname[64];
	struct hostent *checkhost;
	__u32 taddr;
	
	for(i=0; buf[i]; i++) {
		if(buf[i] == '.') {
			dot++;
			continue;
		} else if(buf[i] == '/') {
			slash++;
			slashidx = i;
			continue;
		} else if(buf[i] < '0' || buf[i] > '9')
			nameflag = 1;
	}
	if(dot != 3 && !nameflag) {
		dialog_window("Invalid Address value", NULL);
		return -1;
	}
	if(slash > 1) {
		dialog_window("Invalid Masking", NULL);
		return -1;
	}
	if(slash) {
		mask = atoi(&buf[slashidx+1]);
		if(mask < 0 || mask > 32) {
			dialog_window("Invalid mask value", NULL);
			return -1;
		}
	}
	if(nameflag) {
		strcpy(tmpname, buf);
		if(slash)
			tmpname[slashidx] = '\0';
		
		checkhost = gethostbyname(tmpname);
		if(!checkhost) {
			dialog_window("Host name lookup failure", NULL);
			return -1;
		}
		
		taddr = ntohl((*(int *)checkhost->h_addr));
		get_only_ipaddr(buf, taddr, (__u32)0xffffffff);

		return 0;
	}
	if(!slash)
		strcat(buf, "/32");

	return 0;
}

static GtkWidget *create_host_popup_menu()
{
	GtkWidget *menu = gtk_menu_new();
	
	menu_host_new = create_menu_item(menu, " New ", TRUE,
			GTK_SIGNAL_FUNC(host_edit_window),(RuleAction *)NEW);
	menu_host_edit = create_menu_item(menu, " Edit ", FALSE,
			GTK_SIGNAL_FUNC(host_edit_window),(RuleAction *)EDIT);
	menu_host_delete = create_menu_item(menu, " Delete ", FALSE,
			GTK_SIGNAL_FUNC(host_delete), NULL);
	
	return menu;
}

static GtkWidget *entry_hostname;
static GtkWidget *entry_hostaddr;

static void host_edit_window(GtkWidget *widget, RuleAction flag)
{
	GtkWidget *vbox, *hbox;
	GtkWidget *table, *child;
	GtkWidget *label, *button;
	gint i=0;
	
	if(host_e_win)
		gtk_widget_destroy(host_e_win);
	host_e_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(host_e_win, 260, 90);
	gtk_window_set_position(GTK_WINDOW(host_e_win), GTK_WIN_POS_CENTER);
	if(flag == NEW)
		gtk_window_set_title(GTK_WINDOW(host_e_win), "New host");
	else
		gtk_window_set_title(GTK_WINDOW(host_e_win), "Edit host");
	gtk_container_set_border_width(GTK_CONTAINER(host_e_win), 3);
	gtk_signal_connect(GTK_OBJECT(host_e_win), "destroy",
			GTK_SIGNAL_FUNC(host_edit_win_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(host_e_win), "delete_event",
			GTK_SIGNAL_FUNC(host_edit_win_destroy), NULL);
	
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(host_e_win), vbox);
	
	table = gtk_table_new(3, 2, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_container_add(GTK_CONTAINER(vbox), table);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 8);
	gtk_widget_show(table);
	
	child = gtk_alignment_new(1,1,0,1);
	gtk_widget_show(child);
	gtk_table_attach_defaults(GTK_TABLE(table), child, 0,1,i,i+1);
	label = gtk_label_new("Host name:");
	gtk_widget_show(label);
	gtk_container_add(GTK_CONTAINER(child), label);
	entry_hostname = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), entry_hostname, 1,2,i,i+1);
	i++;
	gtk_widget_show(entry_hostname);
	
	child = gtk_alignment_new(1,1,0,1);
	gtk_widget_show(child);
	gtk_table_attach_defaults(GTK_TABLE(table), child, 0,1,i,i+1);
	label = gtk_label_new("address/mask:");
	gtk_widget_show(label);
	gtk_container_add(GTK_CONTAINER(child), label);
	entry_hostaddr = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), entry_hostaddr, 1,2,i,i+1);
	i++;
	gtk_widget_show(entry_hostaddr);
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(vbox), hbox);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 7);
	gtk_widget_show(hbox);
	
	button = gtk_button_new_with_label("OK");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(host_edit), (RuleAction *)flag);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Cancel");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(host_edit_win_destroy), NULL);
	gtk_widget_show(button);
	
	if(flag == EDIT)
		put_hostdata(widget);
	
	gtk_widget_show(host_e_win);
}

static void host_edit_win_destroy(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(host_e_win);
	host_e_win = NULL;
}

static void put_hostdata(GtkWidget *widget)
{
	gchar *tname, *taddr;
	GList *selection;
	gint index;
	
	selection = GTK_CLIST(user_defined_host)->selection;
	if(!selection)
		return;

	index = GPOINTER_TO_INT(selection->data);
	gtk_clist_get_text(GTK_CLIST(user_defined_host), index, 0, &taddr);
	gtk_clist_get_text(GTK_CLIST(user_defined_host), index, 1, &tname);
	
	gtk_entry_set_text(GTK_ENTRY(entry_hostaddr), taddr);
	gtk_entry_set_text(GTK_ENTRY(entry_hostname), tname);
}

static void host_edit(GtkWidget *widget, RuleAction flag)
{
	gchar *tname, *taddr, *content[2];
	GList *selection;
	gint index = 0;
	gchar vhost[64];
	
	selection = GTK_CLIST(user_defined_host)->selection;
	if(!selection && flag == EDIT)
		goto ERROR;
	else if(selection)
		index = GPOINTER_TO_INT(selection->data);

	taddr = gtk_entry_get_text(GTK_ENTRY(entry_hostaddr));
	if(!*taddr)
		goto ERROR;
	strcpy(vhost, taddr);
	if(check_host(vhost) < 0)
		return;
	taddr = vhost;

	tname = gtk_entry_get_text(GTK_ENTRY(entry_hostname));
	if(!*tname)
		goto ERROR;
	
	if(flag == EDIT) {
		update_address_list(tname, index);
		gtk_clist_set_text(
			GTK_CLIST(user_defined_host), index, 0, taddr);
		gtk_clist_set_text(
			GTK_CLIST(user_defined_host), index, 1, tname);
	} else {
		content[0] = g_malloc(strlen(taddr)+1);
		strcpy(content[0], taddr);
		content[1] = g_malloc(strlen(tname)+1);
		strcpy(content[1], tname);
		index = gtk_clist_append(
				GTK_CLIST(user_defined_host), content);
		g_free(content[0]);
		g_free(content[1]);
		update_address_list(tname, index);
	}
ERROR:
	gtk_widget_destroy(host_e_win);
	host_e_win = NULL;
}

static void host_delete(GtkWidget *widget, gchar *data)
{
	GList *selection;
	gint index;
	
	selection = GTK_CLIST(user_defined_host)->selection;
	if(!selection)
		return;
	index = GPOINTER_TO_INT(selection->data);

	update_address_list(NULL, index);

	gtk_clist_remove(GTK_CLIST(user_defined_host), index);
}

static void host_apply(GtkWidget *widget, gchar *data)
{
	GtkCList *tlist;
	GList *selection;
	gchar *text;
	gint index;
	
	if(!target)
		return;

	tlist = GTK_CLIST(hostlist);
	selection = tlist->selection;
	if(!selection) {
		tlist = GTK_CLIST(user_defined_host);
		selection = tlist->selection;
		if(!selection)
			return;
	}
	index = GPOINTER_TO_INT(selection->data);

	gtk_clist_get_text(tlist, index, 1, &text);
	gtk_entry_set_text(GTK_ENTRY(target), text);

	gtk_widget_hide(gtk_widget_get_toplevel(widget));
}

void save_host_name(GtkWidget *widget, gchar *data)
{
	FILE *fp;
	gint i;
	gchar *tname, *taddr;
	
	fp = fopen(GFCC_HOME"/host_networks", "w");
	if(!fp)
		return;
	
	for(i=0; i<GTK_CLIST(user_defined_host)->rows; i++) {
		gtk_clist_get_text(GTK_CLIST(user_defined_host), i, 0, &taddr);
		gtk_clist_get_text(GTK_CLIST(user_defined_host), i, 1, &tname);
		fprintf(fp, "%s\t%s\n", taddr, tname);
	}
	fclose(fp);
}

static void update_address_list(gchar *newname, gint index)
{
	gint i, j;
	gchar *oldname, buf[64];
	GtkCList *tlist;
	
	for(i=0; i<maxchains; i++) {
		tlist = GTK_CLIST(fwchain[i].rulelist);
		for(j=0; j<tlist->rows; j++) {
			gtk_clist_get_pixtext(
				tlist,j,0,&oldname,&spacing,&pixmap,&mask);
			if(!is_newname(newname, oldname, buf, index))
				gtk_clist_set_pixtext(
					tlist, j, 0, buf,spacing,pixmap,mask);
			gtk_clist_get_pixtext(
				tlist,j,2,&oldname,&spacing,&pixmap,&mask);
			if(!is_newname(newname, oldname, buf, index))
				gtk_clist_set_pixtext(
					tlist, j, 2, buf,spacing,pixmap,mask);
		}
	}
	if(!target)
		return;

	oldname = gtk_entry_get_text(GTK_ENTRY(fwentry.src));
	if(!is_newname(newname, oldname, buf, index))
		gtk_entry_set_text(GTK_ENTRY(fwentry.src), buf);
	oldname = gtk_entry_get_text(GTK_ENTRY(fwentry.dst));
	if(!is_newname(newname, oldname, buf, index))
		gtk_entry_set_text(GTK_ENTRY(fwentry.dst), buf);
}

static gint is_newname(gchar *newname, gchar *oldname, gchar *buf, gint index)
{
	gint delete;
	gchar *taddr, *tname;

	gtk_clist_get_text(GTK_CLIST(user_defined_host), index, 0, &taddr);
	gtk_clist_get_text(GTK_CLIST(user_defined_host), index, 1, &tname);
	delete = newname ? 0 : 1;
	
	if(strcmp(tname, oldname) &&
	   strcmp(taddr, oldname))
		return -1;
	
	if(delete)
		strcpy(buf, taddr);
	else
		strcpy(buf, newname);

	return 0;
}

void write_host_data(FILE *fp)
{
	gint i;
	gchar *host, *ip, newhost[128];
	
	fprintf(fp, "\n");
	for(i=0; i<GTK_CLIST(user_defined_host)->rows; i++) {
		gtk_clist_get_text(GTK_CLIST(user_defined_host), i, 0, &ip);
		gtk_clist_get_text(GTK_CLIST(user_defined_host), i, 1, &host);
		dot_to_underbar(host, newhost);
		fprintf(fp, "%s=\"%s\"\n", newhost, ip);
	}
	for(i=0; i<GTK_CLIST(hostlist)->rows; i++) {
		gtk_clist_get_text(GTK_CLIST(hostlist), i, 0, &ip);
		gtk_clist_get_text(GTK_CLIST(hostlist), i, 1, &host);
		dot_to_underbar(host, newhost);
		fprintf(fp, "%s=\"%s\"\n", newhost, ip);
	}
	fprintf(fp, "\n");
}
