#include <gnome.h>

/* Menu definitions */
static GnomeUIInfo file_menu[]= {
  { 
    GNOME_APP_UI_ITEM,
    N_("Exit"), N_("Exit ..."),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
    'Q', GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_END
};

GnomeUIInfo empty_menu[] = {
        { GNOME_APP_UI_ENDOFINFO }
};

static GnomeUIInfo main_menu[]= 
{
  GNOMEUIINFO_SUBTREE(N_("File"), file_menu),
  GNOMEUIINFO_SUBTREE(N_("Children"), empty_menu),
  GNOMEUIINFO_END
};

/*Child Menu*/
GnomeUIInfo commands_menu[]= {
    {
    GNOME_APP_UI_ITEM,
    N_("New"), N_("New ..."),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    0, (GdkModifierType)0, NULL
    },
  GNOMEUIINFO_END
};
/*Main Child Menu*/
GnomeUIInfo main_child_menu[] = {
   GNOMEUIINFO_SUBTREE(N_("Commands"), commands_menu),
   GNOMEUIINFO_END
};

GtkWidget *make_view(GnomeMDIChild *child, gpointer data)
{
	GtkWidget *label;

   	label = gtk_label_new("This works!");
	return label;
}

int
main(int argc, char *argv[])
{
	GnomeMDI *mdi;
	GnomeMDIGenericChild *child;
	GnomeClient *client;
	
	gnome_init ("control", 0, argc, argv);

	client = gnome_master_client ();
  
	mdi = GNOME_MDI(gnome_mdi_new("gdc", "GDC"));

	gnome_mdi_set_menubar_template(mdi, main_menu);

        gnome_mdi_set_child_menu_path(mdi, _("File"));
        gnome_mdi_set_child_list_path(mdi, _("Children/"));

	gnome_mdi_open_toplevel(mdi);

	child = gnome_mdi_generic_child_new("Batch");
   	gnome_mdi_child_set_menu_template(GNOME_MDI_CHILD(child),
					     main_child_menu);
        gnome_mdi_generic_child_set_view_creator(child, make_view, NULL);
 
   	gnome_mdi_add_child(mdi, GNOME_MDI_CHILD(child));
        gnome_mdi_add_view(mdi, GNOME_MDI_CHILD(child));
   
   	gtk_main();	

}
