#!/bin/sh
#
#	@(#)papersize.sh	1.4  09/24/99
#
#	Simple Bourne shell script to change paper size settings
#	in GMT Documentation from A4 to US Letter or the other way.
#	May possibly work on all files produced by dvips.
#
#	Paul Wessel
#	21-JAN-99
#
#	Usage: In www/gmt/doc/ps, type sh papersize.sh A4|Letter

\cd ..
if [ ! -d ps ]; then
	echo "papersize.sh: Not installed in GMT3.1/www/gmt/doc/ps directory"
	exit -1
fi
\cd ps

if [ $# = 0 ]; then
	echo "usage: papersize.sh A4|Letter"
	exit
elif [ $1 = "A4" ]; then
	echo "s/BoundingBox: 0 0 612 792/BoundingBox: 0 0 595 842/g" > $$.sed
	echo "s/DocumentPaperSizes: Letter/DocumentPaperSizes: A4/g" >> $$.sed
	echo "s/PaperSize: Letter/PaperSize: A4/g" >> $$.sed
elif [ $1 = "Letter" ]; then
	echo "s/BoundingBox: 0 0 595 842/BoundingBox: 0 0 612 792/g" > $$.sed
	echo "s/DocumentPaperSizes: A4/DocumentPaperSizes: Letter/g" >> $$.sed
	echo "s/PaperSize: A4/PaperSize: Letter/g" >> $$.sed
else
	echo "usage: papersize.sh A4|Letter"
	exit
fi

for file in GMT_Docs.ps GMT_Tutorial.ps
do
	echo "Converting $file to $1 format"
	sed -f $$.sed $file > $$
	\rm -f $file
	\mv -f $$ $file
done
\rm -f $$.sed
