/* atidump version 0.22 - ATI graphics chip register dumper for Windows 9X.
 * (C) yvind Aabling <Oyvind.Aabling@uni-c.dk>.
 *
 * This software is a developers-only version. Do not
 * redistribure without permission from the author.
 *
 * Warning - using this program may cause permanent damage
 * to your computer. The author makes no representations
 * about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 */

#include "atidump.h"

static u32 _es *atiregs, regphys ;
static u16 reghigh, reglow ;
static int bogomips=10000 ;	/* This should be large enough :-! */
static FILE *file ;

#define I2C_CNTL_0	(*(atiregs+0x10F))
#define I2C_CNTL_1	(*(atiregs+0x12F))
#define I2C_FILE	file
#include "i2c.h"

/* I2C bus unit addresses */
#define BT829A	0x8A
#define FI1216	0xC6

#define REGSIZE	2048

void printreg(char *name, u32 value) {
  u16 high = value >> 16, low = value ;
  fprintf(file,"%s = 0x%04X%04X\n",name,high,low) ; }

void main(int argc, char **argv) {

  u16 linhigh, linlow ; int sel, dpmierror, i, ok ; char buf[9] ;
  u16 chiptype ; u8 chipclass ; u32 tmp ;

  if (argc < 2) {
    fprintf(stderr,"atidump: missing register aperture address\n") ;
    exit(0) ; }

  /*regphys = strtoul(argv[1],NULL,0) ;*/
  /*reghigh = regphys >> 16 ; reglow = regphys ;*/
  reghigh = strtoul(argv[1],NULL,0) ;
  reglow  = strtoul(argv[2],NULL,0) ;

  if ((file=fopen("atidump.out","ab")) == NULL) {
    perror("atidump: fopen() failed") ; exit(0) ; }

  asm {
	/* Convert Physical to Linear Address */
	mov ax, 0x0800 ;
	mov bx, reghigh ;
	mov cx, reglow ;
	mov si, 0x0003 ;
	mov di, 0x0000 ;
	int 0x31 ;
	mov ax, 0x0800 ;
	jc error1 ;
	mov linhigh, bx ;
	mov linlow, cx ;

	/* Allocate LDT Descriptors */
	mov ax, 0x0000 ;
	mov cx, 0x0001 ;
	int 0x31 ;
	mov bx, ax ;
	mov ax, 0x0000 ;
	jc error1 ;
	mov sel, bx ;

	/* Set Segment Base Address */
	mov ax, 0x0007 ;
	mov bx, sel ;
	mov cx, linhigh ;
	mov dx, linlow ;
	int 0x31 ;
	mov ax, 0x0007 ;
	jc error1 ;

	/* Set Segment Limit */
	mov ax, 0x0008 ;
	mov bx, sel ;
	mov cx, 0 ;
	mov dx, REGSIZE ;
	int 0x31 ;
	mov ax, 0x0008 ;
	jc error1 ;

	/* Set ES register */
	mov ax, sel ;
	mov es, ax ;

	/* DPMI function result */
	mov ax, 0 ;
	jmp set1 ; }
  error1:
  asm	or ax, 0x8000 ;
  set1:
  asm	mov dpmierror, ax ;

  if (dpmierror) {
    fprintf(stderr,"atidump: DPMI failed: 0x%04X\n",dpmierror) ; exit(0) ; }

  /* Point to start of register block */
  atiregs = NULL ;

  /* Ensure we point at the ATI registers before dumping them :-) */
  tmp = *(atiregs+0x138) ;
  chiptype = tmp & 0xFFFF ;
  chipclass = (tmp>>16) & 0xFF ;
  switch (chiptype&0xFF00) {
    case 0x4300:
    case 0x4700:
    case 0x4C00:
    case 0x5600:
      ok = (chipclass == 0) ; break ;
    default: ok = 0 ; break ; }
  if (!ok) {
    fprintf(stderr,"atidump: Invalid or unsupported CONFIG_CHIP_ID value: 0x%04X%04X\n",
      tmp>>16,tmp) ; exit(0) ; }

  for ( i=0 ; i<256 ; i++) {
    sprintf(buf,"MEM_0_%02X",i) ; printreg(buf,*(atiregs+0x100+i)) ; }

  for ( i=0 ; i<256 ; i++) {
    sprintf(buf,"MEM_1_%02X",i) ; printreg(buf,*(atiregs+i)) ; }

  if (!i2c_init()) { i2cdebug = 1 ;
    for ( i=0 ; i<0x20 ; i++ ) ReadReg8(BT829A,i) ;
    ReadReg8(BT829A,0x3F) ; i2c_read(FI1216|1) ; }

  asm {
	/* Free LDT Descriptor */
	mov ax, 0x0001 ;
	mov bx, sel ;
	int 0x31 ;
	mov ax, 0x0001 ;
	jc error2 ;

	/* DPMI function result */
	mov ax, 0 ;
	jmp set2 ; }
  error2:
  asm	or ax, 0x8000 ;
  set2:
  asm	mov dpmierror, ax ;

  fprintf(file,"\n") ; exit(0) ; }
