
#ifndef __triage_h__
#define __triage_h__

#include "triagetypes.h"
#include "texture2d.h"
#include "inliners.h"
#include "matrix.h"
#include "graphics.h"

enum
{
    KFlagFrontFace=0x0000001, 
    KFlagBackFace =0x0000002, 
    KFlagMoreDepth=0x0000004, 
    KFlagLessDepth=0x0000008,
};

inline Fixed CrossZ(CVector& v0, CVector& v1, CVector& v2)
{
    return
        FixedMul((v1.xf[0]-v0.xf[0]),(v2.xf[1]-v0.xf[1])) -
        FixedMul((v2.xf[0]-v0.xf[0]),(v1.xf[1]-v0.xf[1]));
}

template<class T>
inline void UnCulledTriangle(CVector& v0, PlatPixel aPixel0,
                               CVector& v1, PlatPixel aPixel1,
                               CVector& v2, PlatPixel aPixel2,
                               T& aPixelize)
{
    PlatInt x0,y0,z0,x1,y1,z1,x2,y2,z2;
    UnFixVector(x0, y0, z0, v0);
    UnFixVector(x1, y1, z1, v1);
    UnFixVector(x2, y2, z2, v2);
    Triangle(x0, y0, z0,aPixel0,
             x1, y1, z1,aPixel1,
             x2, y2, z2,aPixel2,
             aPixelize);
}


template<class T>
inline void BackCulledTriangle(CVector& v0, PlatPixel aPixel0,
                               CVector& v1, PlatPixel aPixel1,
                               CVector& v2, PlatPixel aPixel2,
                               T& aPixelize)
{
    PlatInt x0,y0,z0,x1,y1,z1,x2,y2,z2;
    Fixed crossz;

    crossz = CrossZ(v0,v1,v2);

    if (crossz<0)
    {
        UnFixVector(x0, y0, z0, v0);
        UnFixVector(x1, y1, z1, v1);
        UnFixVector(x2, y2, z2, v2);
        Triangle(x0, y0, z0,aPixel0,
                 x1, y1, z1,aPixel1,
                 x2, y2, z2,aPixel2,
                 aPixelize);
    }
}
template<class T>
inline void FrontCulledTriangle(CVector& v0, PlatPixel aPixel0,
                               CVector& v1, PlatPixel aPixel1,
                               CVector& v2, PlatPixel aPixel2,
                               T& aPixelize)
{
    PlatInt x0,y0,z0,x1,y1,z1,x2,y2,z2;
    Fixed crossz;

    crossz = CrossZ(v0,v1,v2);

    if (crossz>0)
    {
        UnFixVector(x0, y0, z0, v0);
        UnFixVector(x1, y1, z1, v1);
        UnFixVector(x2, y2, z2, v2);
        Triangle(x0, y0, z0,aPixel0,
                 x1, y1, z1,aPixel1,
                 x2, y2, z2,aPixel2,
                 aPixelize);
    }
}


class CTriage
{
public: //constructor
    CTriage(CTexture2d& aTexture,CTexture2d& aDepth);
    virtual ~CTriage();

public://render primitives    
    void Line(CVector& vv0, PlatPixel c0, CVector& vv1, PlatPixel c1);
    void Triangle(CVector& vv0, PlatPixel c0,
                  CVector& vv1, PlatPixel c1,
                  CVector& vv2, PlatPixel c2);

    void Quad(CVector& vv0, PlatPixel c0,
              CVector& vv1, PlatPixel c1,
              CVector& vv2, PlatPixel c2,
              CVector& vv3, PlatPixel c3);

public: //flag access
    inline void SetFlag(PlatInt aFlag)
    { iRenderFlags |= aFlag; }
    inline void ClearFlag(PlatInt aFlag)
    { iRenderFlags &= (~aFlag); }
    inline PlatInt Flag(PlatInt aFlag) {return iRenderFlags&aFlag;}
public://access to privates
    inline GlobalTransform &Transform() {return iTransform;}
    inline CTrig &Trig()                {return iTrig;}
    inline CTexture2d& Texture() {return iTexture;}
    inline CTexture2d& Depth()   {return iDepth;}

public://transforms
    void RotateX(PlatInt aAngle);
    void RotateY(PlatInt aAngle);
    void RotateZ(PlatInt aAngle);
    void Translate(Fixed aX, Fixed aY, Fixed aZ);

    
private:
    PlatInt iRenderFlags;
    CTexture2d& iTexture;
    CTexture2d&   iDepth;

    GlobalTransform iTransform;
    CTrig iTrig;
};

#endif

