
/* example2 : Show off some post processing to perform an implicit
 * plot of a 2d function.
 */

#include <stdio.h>
#include "render.h"
#include "triage.h"
#include "targagrabber.h"
#include "matrix.h"
#include "processing.h"




#define WIDTH  640
#define HEIGHT 480

CTexture2d texture(WIDTH,HEIGHT);
CTexture2d depth(WIDTH,HEIGHT);
CTriage    triage(texture,depth);


#define STEPS 320
CVector r[STEPS][STEPS];

void DrawField()
{
    int x,y;
    int step = 3000/STEPS;
    for (y=0;y<STEPS;y++)
        for (x=0;x<STEPS;x++)
        {
            r[x][y].xf[0] = ((WIDTH*x)/(STEPS-1))*FixedOne;
            r[x][y].xf[1] = ((WIDTH*y)/(STEPS-1))*FixedOne;
            r[x][y].xf[2] = IntToFixed(500)+500*(FixedMul(triage.Trig().Cos(step*x),triage.Trig().Cos(step*y)));
            r[x][y].xf[3] = FixedOne;
        }
    for (y=0;y<STEPS-1;y++)
        for (x=0;x<STEPS-1;x++)
        {
          triage.Quad(r[x+0][y+0],Pixel(0,0,255,255),
                      r[x+1][y+0],Pixel(0,0,255,255),
                      r[x+0][y+1],Pixel(0,0,255,255),
                      r[x+1][y+1],Pixel(0,0,255,255));
        }
}

int main(void)
{
    Clear(texture, Pixel(0,0,0,0));
    Clear(depth, 1000);

    triage.SetFlag(KFlagLessDepth);

    DrawField();
    QuantizeDepth dec;
    Quantize(depth,0  ,100,dec);
    Quantize(depth,100,200,dec);
    Quantize(depth,200,400,dec);
    Quantize(depth,400,500,dec);
    Quantize(depth,500,600,dec);
    Quantize(depth,600,800,dec);
    Quantize(depth,800,900,dec);
    Quantize(depth,900,1000,dec);

    CTexture2d* dc = DepthToColor(depth,0, 1000);
    SobelFilterLines(*dc,depth);
    CTexture2d* shrink = CombinePixels(*dc,1);
    SaveAsTarga("example2.tga",&(*shrink)[0],
                shrink->Width(), shrink->Height());
    delete dc;
    delete shrink;

   system("xv example2.tga &");

    return 0;
}

