# Makefile for yacas
# Microsoft 32-bit Visual C++ 4.0 or later (may work on earlier versions)

# To use, do "nmake /f makefile.w32"

# ------------- Microsoft Visual C++ 4.0 and later -------------
CC=cl
CFLAGS=/nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /c
INCS=-I.\plat\win32
LD=link
LDFLAGS=/lib /nologo /out:"Yacas.lib"

YACASOBJ=anumber.obj deffile.obj grower.obj infixparser.obj mathcommands.obj\
		 mathenvironment.obj mathuserfunc.obj lispatom.obj\
		 lispcleanupstack.obj lispenvironment.obj lispeval.obj lisphash.obj\
		 lispio.obj lispobject.obj lispparser.obj lispstring.obj lispuserfunc.obj\
		 platmath.obj standard.obj stdfileio.obj stdstubs.obj stringio.obj\
		 tokenizer.obj  yacasapi.obj yacasnumbers.obj
DLLOBJ=winmain.obj

all: Yacas.lib Test.exe

clean:
	del *.obj

reallyclean:
	del *.obj
	del test.*
	del yacas.lib

anumber.obj: anumber.cc anumber.h anumber.inl choices.h grower.h grower.inl\
			 lispassert.h lispstring.h lispstring.inl stubs.h plat\win32\lisptype.h \
			 plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) anumber.cc

deffile.obj: deffile.cc choices.h deffile.h deffile.inl grower.h grower.inl\
			 lispassert.h lispatom.h lispcleanupstack.h lispenvironment.h\
			 lisperror.h lispevalhash.h lisphash.h lisphash.inl lispio.h\
			 lispobject.h lispobject.inl lispstring.h lispstring.inl plat\win32\lisptype.h\
			 lispuserfunc.h numbers.h plat\win32\platfileio.h standard.h standard.inl\
			 stubs.h plat\win32\stubs.inl tokenizer.h
	$(CC) $(CFLAGS) $(INCS) deffile.cc

grower.obj: grower.cc choices.h grower.h grower.inl lispassert.h plat\win32\lisptype.h\
			stubs.h plat\win32\stubs.inl	
	$(CC) $(CFLAGS) $(INCS) grower.cc

infixparser.obj: infixparser.cc choices.h deffile.h deffile.inl grower.h\
				 grower.inl infixparser.h lispassert.h lispatom.h\
				 lispcleanupstack.h lispenvironment.h lisperror.h lispevalhash.h\
				 lisphash.h lisphash.inl lispio.h lispobject.h lispobject.inl \
				 lispparser.h lispstring.h lispstring.inl plat\win32\lisptype.h\
				 lispuserfunc.h numbers.h standard.h standard.inl stubs.h\
				 plat\win32\stubs.inl tokenizer.h
	$(CC) $(CFLAGS) $(INCS) infixparser.cc

lispatom.obj: lispatom.cc choices.h grower.h grower.inl lispassert.h lispatom.h\
			  lisperror.h lispobject.h lispobject.inl lispstring.h\
			  lispstring.inl plat\win32\lisptype.h stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) lispatom.cc


lispcleanupstack.obj: lispcleanupstack.cc choices.h grower.h grower.inl\
					  lispassert.h lispcleanupstack.h plat\win32\lisptype.h stubs.h\
					  plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) lispcleanupstack.cc

lispenvironment.obj: lispenvironment.cc choices.h deffile.h deffile.inl\
					 grower.h grower.inl lispassert.h lispcleanupstack.h\
					 lispenvironment.h lisperror.h lispevalhash.h\
					 lisphash.h lisphash.inl lispobject.h "lispobject.inl"\
					 lispstring.h lispstring.inl plat\win32\lisptype.h\
					 lispuserfunc.h stubs.h plat\win32\stubs.inl 
	$(CC) $(CFLAGS) $(INCS) lispenvironment.cc

lispeval.obj: lispeval.cc choices.h deffile.h deffile.inl grower.h\
			  grower.inl infixparser.h lispassert.h lispatom.h\
			  lispcleanupstack.h lispenvironment.h lisperror.h lispeval.h\
			  lispevalhash.h lisphash.h lisphash.inl lispio.h lispobject.h\
			  lispobject.inl lispparser.h lispstring.h lispstring.inl\
			  plat\win32\lisptype.h lispuserfunc.h numbers.h plat\win32\platfileio.h standard.h\
			  standard.inl stubs.h plat\win32\stubs.inl tokenizer.h
	$(CC) $(CFLAGS) $(INCS) lispeval.cc

lisphash.obj: lisphash.cc choices.h grower.h grower.inl lispassert.h\
			  lisperror.h lisphash.h lisphash.inl lispstring.h\
			  lispstring.inl plat\win32\lisptype.h stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) lisphash.cc

lispio.obj: lispio.cc lispio.h plat\win32\lisptype.h
	$(CC) $(CFLAGS) $(INCS) lispio.cc

lispobject.obj: lispobject.cc choices.h grower.h grower.inl lispassert.h\
				lisperror.h lispobject.h lispobject.inl lispstring.h\
				lispstring.inl plat\win32\lisptype.h stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) lispobject.cc

lispparser.obj: lispparser.cc choices.h grower.h grower.inl lispassert.h\
				lispatom.h lisperror.h lisphash.h lisphash.inl lispio.h\
				lispobject.h lispobject.inl lispparser.h lispstring.h\
				lispstring.inl plat\win32\lisptype.h stubs.h plat\win32\stubs.inl tokenizer.h
	$(CC) $(CFLAGS) $(INCS) lispparser.cc

lispstring.obj: lispstring.cc choices.h grower.h grower.inl lispassert.h\
				lispstring.h plat\win32\lisptype.h lispstring.inl stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) lispstring.cc

lispuserfunc.obj: lispuserfunc.cc choices.h deffile.h deffile.inl grower.h\
				  grower.inl lispassert.h lispatom.h lispcleanupstack.h\
				  lispenvironment.h lisperror.h lispevalhash.h lisphash.h\
				  lisphash.inl lispobject.h lispobject.inl lispstring.h\
				  lispstring.inl plat\win32\lisptype.h lispuserfunc.h numbers.h\
				  standard.h standard.inl stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) lispuserfunc.cc

mathcommands.obj: mathcommands.cc anumber.h anumber.inl choices.h deffile.h\
				  deffile.inl grower.h grower.inl infixparser.h lispassert.h\
				  lispatom.h lispcleanupstack.h lispenvironment.h lisperror.h\
				  lispeval.h lispevalhash.h lisphash.h lisphash.inl lispio.h\
				  lispobject.h lispobject.inl lispparser.h lispstring.h\
				  lispstring.inl plat\win32\lisptype.h lispuserfunc.h mathuserfunc.h\
				  numbers.h plat\win32\platfileio.h platmath.h standard.h standard.inl\
				  stdfileio.h stubs.h plat\win32\stubs.inl tokenizer.h
	$(CC) $(CFLAGS) $(INCS) mathcommands.cc

mathenvironment.obj: mathenvironment.cc choices.h deffile.h deffile.inl grower.h\
					 grower.inl lispassert.h lispatom.h lispcleanupstack.h\
					 lispenvironment.h lisperror.h lispevalhash.h lispglobals.h\
					 lisphash.h lisphash.inl lispobject.h lispobject.inl \
					 lispstring.h lispstring.inl plat\win32\lisptype.h lispuserfunc.h\
					 mathenvironment.h mathuserfunc.h numbers.h standard.h\
					 standard.inl stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) mathenvironment.cc

mathuserfunc.obj: mathuserfunc.cc choices.h deffile.h deffile.inl grower.h\
				  grower.inl lispassert.h lispatom.h lispcleanupstack.h\
				  lispenvironment.h lisperror.h lispeval.h lispevalhash.h\
				  lisphash.h lisphash.inl lispobject.h lispobject.inl \
				  lispstring.h lispstring.inl plat\win32\lisptype.h lispuserfunc.h\
				  mathuserfunc.h numbers.h standard.h standard.inl stubs.h\
				  plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) mathuserfunc.cc

platmath.obj: platmath.cc choices.h deffile.h deffile.inl grower.h grower.inl\
			  lispassert.h lispatom.h lispcleanupstack.h lispenvironment.h\
			  lisperror.h lispevalhash.h lisphash.h lisphash.inl lispobject.h\
			  lispobject.inl lispstring.h lispstring.inl plat\win32\lisptype.h lispuserfunc.h\
			  stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) platmath.cc

standard.obj: standard.cc choices.h deffile.h deffile.inl grower.h grower.inl\
			  infixparser.h lispassert.h lispatom.h lispcleanupstack.h\
			  lispenvironment.h lisperror.h lispeval.h lispevalhash.h\
			  lisphash.h lisphash.inl lispio.h lispobject.h lispobject.inl \
			  lispparser.h lispstring.h lispstring.inl plat\win32\lisptype.h\
			  lispuserfunc.h numbers.h plat\win32\platfileio.h standard.h standard.inl\
			  stubs.h plat\win32\stubs.inl tokenizer.h
	$(CC) $(CFLAGS) $(INCS) standard.cc

stdfileio.obj: stdfileio.cc choices.h deffile.h deffile.inl grower.h\
			   grower.inl lispassert.h lispcleanupstack.h\
			   lispenvironment.h lisperror.h lispevalhash.h lisphash.h\
			   lisphash.inl lispio.h lispobject.h lispobject.inl\
			   lispstring.h lispstring.inl plat\win32\lisptype.h lispuserfunc.h\
			   stdfileio.h plat\win32\platfileio.h stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) stdfileio.cc

stdstubs.obj: stdstubs.cc choices.h grower.h grower.inl lispassert.h\
			  lisperror.h lispstring.h lispstring.inl plat\win32\lisptype.h stubs.h\
			  plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) stdstubs.cc

stringio.obj: stringio.cc choices.h grower.h grower.inl lispassert.h\
			  lispio.h lispstring.h lispstring.inl plat\win32\lisptype.h stringio.h\
			  stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) stringio.cc

tokenizer.obj: tokenizer.cc choices.h grower.h grower.inl lispassert.h\
			   lisperror.h lispio.h lispstring.h lispstring.inl plat\win32\lisptype.h\
			   stubs.h plat\win32\stubs.inl tokenizer.h
	$(CC) $(CFLAGS) $(INCS) tokenizer.cc	

winmain.obj: winmain.cc choices.h deffile.h deffile.inl grower.h\
			 grower.inl infixparser.h lispassert.h lispatom.h\
			 lispcleanupstack.h lispenvironment.h lisperror.h\
			 lispeval.h lispevalhash.h lispglobals.h lisphash.h\
			 lisphash.inl lispio.h lispobject.h lispobject.inl \
			 lispparser.h lispstring.h lispstring.inl plat\win32\lisptype.h\
			 lispuserfunc.h mathenvironment.h plat\win32\platfileio.h stdfileio.h\
			 stringio.h stubs.h plat\win32\stubs.inl tokenizer.h yacas.h
	$(CC) $(CFLAGS) $(INCS) winmain.cc

yacasapi.obj: yacasapi.cc choices.h deffile.h deffile.inl grower.h\
			 grower.inl infixparser.h lispassert.h lispatom.h\
			 lispcleanupstack.h lispenvironment.h lisperror.h\
			 lispeval.h lispevalhash.h lispglobals.h lisphash.h\
			 lisphash.inl lispio.h lispobject.h lispobject.inl \
			 lispparser.h lispstring.h lispstring.inl plat\win32\lisptype.h\
			 lispuserfunc.h mathcommands.h mathenvironment.h\
			 plat\win32\platfileio.h stdfileio.h stringio.h stubs.h plat\win32\stubs.inl\
			 tokenizer.h yacas.h
	$(CC) $(CFLAGS) $(INCS) yacasapi.cc

yacasnumbers.obj: yacasnumbers.cc anumber.h anumber.inl choices.h\
				  deffile.h deffile.inl grower.h grower.inl lispassert.h\
				  lispatom.h lispcleanupstack.h lispenvironment.h\
				  lisperror.h lispevalhash.h lisphash.h lisphash.inl\
				  lispobject.h lispobject.inl lispstring.h lispstring.inl\
				  plat\win32\lisptype.h lispuserfunc.h numbers.h platmath.h\
				  standard.h standard.inl stubs.h plat\win32\stubs.inl
	$(CC) $(CFLAGS) $(INCS) yacasnumbers.cc

Yacas.lib: $(YACASOBJ)
	if exist yacas.lib del yacas.lib
	$(LD) $(LDFLAGS) $(YACASOBJ)

Test.exe: wintermclient.cc
	if exist test.exe del test.exe
	$(CC) /nologo /W3 /GX /O2 /c $(INCS) wintermclient.cc
	$(LD) yacas.lib /nologo /out:"Test.exe" wintermclient.obj