
#ifndef __commandline_h__
#define __commandline_h__

#include "lispstring.h"
#include "lisptype.h"

enum ESpecialChars
{
    eDelete     = 0x1000,
    eBackSpace,
    eLeft,
    eRight,
    eUp,
    eDown,
    eHome,
    eEnd,
    eEnter,
};

class CCommandLine
{
public:
    virtual ~CCommandLine();
    void ReadLine(LispCharPtr prompt);
public: //platform stuff
    virtual LispInt GetKey() = 0;
    virtual void NewLine()   = 0;
    virtual void ShowLine(LispCharPtr prompt,
                          LispInt promptlen,LispInt cursor) = 0;
    virtual void Pause() = 0;

private:
    void GetHistory(LispInt aLine);
    void ShowOpen(LispCharPtr prompt,LispInt promptlen,
                  LispChar aOpen, LispChar aClose, LispInt aCurPos);
    
public:
    LispString iLine;
    CArrayGrower<LispStringPtr> iHistory;
};

#endif

