

/* BaseTimesInt : multiply a with one digit in the range 0..(aBase-1)
 */
template<class T>
inline void BaseTimesInt(T& a,PlatDoubleWord aNumber, PlatDoubleWord aBase)
{
//    if (a[a.NrItems()-1] != 0)
    a.Append(0);

    PlatDoubleWord carry=0;
    LispInt i;
    LispInt nr=a.NrItems();
    
    for (i=0;i<nr;i++)
    {
        PlatDoubleWord word = ((PlatDoubleWord)(a[i]))*aNumber+carry;
        PlatWord digit = word % aBase;
        PlatWord newCarry= word / aBase;
        a[i] = digit;
        carry= newCarry;
    }
    LISPASSERT(carry == 0);
}

template<class T>
inline void BaseDivideInt(T& a,PlatDoubleWord aNumber, PlatDoubleWord aBase, PlatDoubleWord& aCarry)
{
//    if (a[a.NrItems()-1] != 0)

    PlatDoubleWord carry=0;
    LispInt i;
    LispInt nr=a.NrItems();
    
    for (i=nr-1;i>=0;i--)
    {
        PlatDoubleWord word = ((carry*aBase)+((PlatDoubleWord)(a[i])));
        PlatWord digit = word /aNumber;
        PlatWord newCarry= word % aNumber;
        a[i] = digit;
        carry= newCarry;
    }
    //carry now is the remainder
    aCarry = carry;
}


/* GrowDigits : add digits to a until it has aDigits digits
 */
template<class T>
inline void GrowDigits(T& a,LispInt aDigits)
{
    LispInt nrToAdd = aDigits-a.NrItems();
    LispInt i;
    for (i=0;i<nrToAdd;i++)
        a.Append(0);
}

/* BaseAdd : destructively add aSource to aTarget, in base aBase.
 */
template<class T>
inline void BaseAdd(T& aTarget, T& aSource, LispInt aBase)
{
    // Initialize result

    GrowDigits(aTarget,aSource.NrItems());
    aTarget.Append(0);
    
    LispInt nr1 = aTarget.NrItems();
    LispInt nr2 = aSource.NrItems();
    LispInt nr;

    // nr represents min(nr1,nr2), the number of digits to add
    if (nr1>nr2)
        nr=nr2;
    else
        nr=nr1;
    
    PlatDoubleWord carry=0;
    LispInt digit;
    for (digit=0;digit<nr;digit++)
    {
        PlatDoubleWord word;
        word = (PlatDoubleWord)aTarget[digit] +
            (PlatDoubleWord)aSource[digit] + carry;
         PlatDoubleWord newDigit = (word%aBase);
         PlatDoubleWord newCarry = (word/aBase);
         aTarget[digit] = newDigit;
         carry          = newCarry;
    }
    while (carry != 0)
    {
        PlatSignedDoubleWord ww = aTarget[nr];
        ww+=carry;
        aTarget[nr] = ww%aBase;
        carry = ww/aBase;
        nr++;
    }
}

/* BaseIntNumber : convert a number into a different base,
 * using growing arrays.
 */
template<class T>
inline void BaseIntNumber(T& aTarget, LispInt aNumber, LispInt aBase)
{
    aTarget.SetNrItems(0);
    while (aNumber != 0)
    {
        LispInt digit = aNumber%aBase;
        aTarget.Append(digit);
        aNumber/=aBase;
    }
    if (aTarget.NrItems() == 0)
        aTarget.Append(0);
}

// BaseAddMultiply : multiply x and y, and add result to aTarget
//
template<class T>
inline void BaseAddMultiply(T& aTarget, T& x, T& y, LispInt aBase)
{
    LispInt nrx=x.NrItems();
    LispInt nry=y.NrItems();
    GrowDigits(aTarget,nrx+nry+1);
    LispInt ix,iy;
    for (ix=0;ix<nrx;ix++)
    {
        PlatDoubleWord carry = 0;
        for (iy=0;iy<nry;iy++)
        {
            PlatDoubleWord word =
                static_cast<PlatDoubleWord>(aTarget[ix+iy])+
                static_cast<PlatDoubleWord>(x[ix])*
                static_cast<PlatDoubleWord>(y[iy])+carry;
            //TODO old    aTarget[ix+iy]+x[ix]*y[iy]+carry;


            aTarget[ix+iy] = word % aBase;
            carry          = word / aBase;
        }
        aTarget[ix+nry] += carry;
    }
}


#ifdef USE_KARATSUBA

/* BaseAddMultiplyK : multiply x and y, and add result to aTarget
 *                                        using Karatsuba multiplication
 */
const int cKaratsubaCutoff = 5;

template<class T>
inline void BaseAddMultiplyK(T& aTarget, T& x, T& y, LispInt aBase)
{
    LispInt nrx=x.NrItems();
    LispInt nry=y.NrItems();
    LispInt i;
    bool xmod = nrx % 2, ymod = nry % 2;
    T xlow, 	xhigh, xsum, ylow, yhigh, ysum, p1, p2, p3;

    GrowDigits(xlow, nrx/2+1);
    GrowDigits(ylow, nry/2+1);
    GrowDigits(xsum, nrx/2+1);
    GrowDigits(ysum, nry/2+1);
    GrowDigits(xhigh, nrx/2+1);
    GrowDigits(yhigh, nry/2+1);
    GrowDigits(aTarget,nrx+nry+1);

    // Too small?  Use O(n^2) multiplication
    // ToDo: change BaseAdd... so that it doesn't grow aTarget
    if (nrx+nry+1 < cKaratsubaCutoff)
    {
        BaseAddMultiply(aTarget, x, y, aBase);
        return;
    }

    // Incase the number has an odd number of digits, we
    // add all but the last, then add just that to the end

    // ToDo: Is the odd-case code correct?

    // Sigh... hope I don't have to keep the part that copys
    // into two more numbers... seems like big waste
    if (xmod)
        for (i=0;i<nrx/2;i++)
        {
            xlow[i] = x[i];
            xsum[i] = x[i] + x[i+nrx/2];
            xhigh[i] = x[i+nrx/2];
        }
    else
    {
        for (i=0;i<(nrx-1)/2;i++)
        {
            xlow[i] = x[i];
            xsum[i] = x[i] + x[i+nrx/2];
            xhigh[i] = x[i+nrx/2];
        }
        xlow[i] = x[i];
        xsum[i] = x[i];
    }

    // Ditto...
    if (ymod)
        for (i=0;i<nry/2;i++)
        {
            ylow[i] = y[i];
            ysum[i] = y[i] + y[i+nry/2];
            yhigh[i] = y[i+nry/2];
        }
    else
    {
        for (i=0;i<(nry-1)/2;i++)
        {
            ylow[i] = y[i];
            ysum[i] = y[i] + y[i+nry/2];
            yhigh[i] = y[i+nry/2];
        }
        ylow[i] = y[i];
        ysum[i] = y[i];
    }


    // The joys of recursion... =)
    BaseAddMultiplyK(p1, xlow, ylow, aBase);
    BaseAddMultiplyK(p2, xsum, ysum, aBase);
    BaseAddMultiplyK(p3, xhigh, yhigh, aBase);

    // combine recursive steps
    for (i=0; i<p2.NrItems();i++)
        p2[i] = p2[i] - p1[i] - p3[i];
    for (i=0; i<p2.NrItems();i++)
        aTarget[i] += p2[i];
}
#endif

/* BaseMultiply : multiply x and y, and put result in aTarget
 */
template<class T>
inline void BaseMultiply(T& aTarget, T& x, T& y, LispInt aBase)
{
    aTarget.SetNrItems(1);
    aTarget[0] = 0;
#ifdef USE_KARATSUBA
    BaseAddMultiplyK(aTarget, x, y, aBase);
#else
    BaseAddMultiply(aTarget, x, y, aBase);
#endif
}



template<class T>
inline LispBoolean IsZero(T& a)
{
    LispInt i;
    for (i=0;i<a.NrItems();i++)
        if (a[i] != 0)
            return LispFalse;
    return LispTrue;
}



template<class T>
inline void BaseDivide(T& aQuotient, T& aRemainder, T& a1, T& a2, PlatDoubleWord base)
{
    // Find the values n and m as described in Knuth II:
    LispInt n,m;
    n=a2.NrItems();
    LISPASSERT(n>0);
    LISPASSERT(a2[n-1] != 0);
    
    //a1.NrItems() = m+n => m = a1.NrItems()-n
    m = a1.NrItems()-n;
    LISPASSERT(m>=0);

    aQuotient.GrowTo(m+1);
    
    //D1:
//TODO old    PlatDoubleWord d = base/(a2[n-1]+1);
    PlatDoubleWord d = base/(static_cast<PlatDoubleWord>(a2[n-1])+1);


    BaseTimesInt(a1, d, base);
    BaseTimesInt(a2, d, base);

    //D2:
    LispInt j = m;

    while (j>=0)
    {
        //D3:
        PlatDoubleWord q = (a1[j+n]*base+a1[j+n-1])/a2[n-1];
        PlatDoubleWord r = (a1[j+n]*base+a1[j+n-1])%a2[n-1];

    REDO:
        if (q == base || q*a2[n-2] > base*r+a1[j+n-2])
        {
            q = q - 1;
            r = r + a2[n-1];
            if (r < base)
                goto REDO;
        }

        //D4:
        ANumber sub(Precision(aQuotient));
        sub.CopyFrom(a2);
        BaseTimesInt(sub, q, base);

        PlatSignedDoubleWord carry;
        LispInt digit;
        {//Subtract the two
            //TODO this can be generalized!!!!
            //
            // Beware though: this is not a normal subtraction. Only a
            // certain set of digits ends up being subtracted.

            // First check if qv isn't too big...
            carry = 0;
            for (digit=0;digit<=n;digit++)
            {
                PlatSignedDoubleWord word;
                word = ((PlatSignedDoubleWord)a1[digit+j]) -
                    ((PlatSignedDoubleWord)sub[digit]) +
                    (PlatSignedDoubleWord)carry;
                carry=0;
                while (word<0)
                {
                    word+=base;
                    carry--;
                }
            }
            if (carry)
            {
                q--;
                sub.CopyFrom(a2);
                BaseTimesInt(sub, q, base);
            }
            
            carry = 0;
            for (digit=0;digit<=n;digit++)
            {
                PlatSignedDoubleWord word;
                word = ((PlatSignedDoubleWord)a1[digit+j]) -
                    ((PlatSignedDoubleWord)sub[digit]) +
                    (PlatSignedDoubleWord)carry;
                carry=0;
                while (word<0)
                {
                    word+=base;
                    carry--;
                }
                a1[digit+j] = ((PlatWord)(word%base));
            }
        }
        LISPASSERT(carry == 0);
            
        //D5:
        aQuotient[j] = q;
        //D7:
        j--;
        
    }

    //D8:
    a1.SetNrItems(n);
    PlatDoubleWord carry;
    BaseDivideInt(a1, d, base,carry);
    aRemainder.CopyFrom(a1);
}


