#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#   
#   
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

proc edit_initia {} {

  global tnpath
  source $tnpath/gid/global.tcl

  set w .tngidmbar.edit.menu.initia
  catch {destroy $w}
  toplevel $w
  wm title $w "Edit initia"
  wm geometry $w $tn_window_offset
  focus $w

  set f $w.frame
  frame $f -relief groove -borderwidth 2
  pack $f -expand 1 -fill both

#   tngidmbar edit initia ready
  frame $f.framespecials -relief flat
  pack $f.framespecials -fill x -side bottom
  button $f.framespecials.ready -text "Ready" -command " destroy $w "
  pack $f.framespecials.ready -side left -pady 4m -anchor w

  frame $f.frameinitia -relief flat
  pack $f.frameinitia -expand 1 -fill both

#   tngidmbar edit initia checkbuttons
  for {set i 0} {$i<$initia_array_length} {incr i} {
    if { $initia_array_types($i) ==  "checkbutton" } {
      checkbutton $f.frameinitia.b_$i -text $initia_array($i) \
        -variable initia_array_values($i) -onvalue 1 -offvalue 0
      pack $f.frameinitia.b_$i -side top -anchor w
    }
  }
#   tngidmbar edit initia entrybuttons
  for {set i 0} {$i<$initia_array_length} {incr i} {
    if { $initia_array_types($i) ==  "entry" } {
      label $f.frameinitia.l_$i -text $initia_array($i)
      entry $f.frameinitia.b_$i -textvariable initia_array_values($i)
      pack $f.frameinitia.l_$i $f.frameinitia.b_$i -side top -anchor w
    }
  }
#   tngidmbar edit initia radiobuttons
  label $f.frameinitia.lab -text "ndim"
  radiobutton $f.frameinitia.ndim1 -variable initia_array_values(1) \
    -value 1 -text 1D 
  radiobutton $f.frameinitia.ndim2 -variable initia_array_values(1) \
    -value 2 -text 2D 
  radiobutton $f.frameinitia.ndim3 -variable initia_array_values(1) \
    -value 3 -text 3D 
  pack $f.frameinitia.lab $f.frameinitia.ndim1 $f.frameinitia.ndim2 $f.frameinitia.ndim3 -side left -anchor w

}
