;;
;; Wanderlust -- Yet Another Message Interface on Emacsen.
;;
;; Copyright (C) 1998 Yuuichi Teranishi <teranisi@gohome.org>
;;
;; Time-stamp: <99/06/15 16:36:49 teranisi>

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.
;;

(autoload 'mime/editor-mode "tm-edit" nil t)
(autoload 'mime/edit-again "tm-edit" nil t)
(eval-when-compile (require 'tm-edit))

(defvar wl-draft-buffer nil)
(defun tm-wl-yank-method (buf)
  (set-buffer wl-draft-buffer)
  (let ((mail-reply-buffer buf))
    (wl-yank-content nil)
    (kill-buffer buf)))

(defun tm-wl-yank-original ()
  (let ((wl-draft-buffer (current-buffer))
	(mime-viewer/following-method-alist 
	 (list (cons 'wl-message-original-mode 
		     (function tm-wl-yank-method))))
	mes-buf)
    (if (setq mes-buf (get-buffer wl-message-buf-name))
	(save-excursion
	  (save-restriction
	    (set-buffer mes-buf)
	    (setq mime::preview/mother-buffer nil)
	    (widen)
	    (mime-viewer/follow-content))))))

(defun tm-wl-following-method (buf)
  (wl-draft-reply buf 'to-all))

(set-alist 'mime-viewer/following-method-alist
           'wl-message-original-mode
           (function tm-wl-following-method))

(defun tm-wl-decode-message (outbuf inbuf)
  (let ((mime-viewer/content-header-filter-hook 'wl-highlight-headers))
    (mime/viewer-mode nil nil nil inbuf outbuf)))

(defun tm-wl-decode-message-with-all-header (outbuf inbuf)
  (let ((mime-viewer/ignored-field-regexp "^:$")
	(mime-viewer/content-header-filter-hook 'wl-highlight-headers))
    (mime/viewer-mode nil nil nil inbuf outbuf))
  )

(defun tm-wl-delete-mime-out-buf ()
  (let (mime-out-buf mime-out-win)
    (if (setq mime-out-buf (get-buffer mime/output-buffer-name))
	(if (setq mime-out-win (get-buffer-window mime-out-buf))
	    (delete-window mime-out-win)))))

(defun tm-wl-request-partial-message (folder number msgdb)
  (elmo-set-work-buf
   (elmo-read-msg-no-cache folder number (current-buffer) msgdb)
   (mime/parse-message nil nil)))

(defun tm-wl-mime-combine-message/partial-pieces (beg end cal)
  (interactive)
  (let* (folder
	 (msgdb (save-excursion
		  (set-buffer wl-message-buffer-cur-summary-buffer)
		  (setq folder wl-summary-buffer-folder-name)
		  wl-summary-buffer-msgdb))
	 (mime-viewer/content-header-filter-hook 'wl-highlight-headers)
	 (id (cdr (assoc "id" cal)))
	 (mother mime::article/preview-buffer)
	 (target (cdr (assq 'major-mode cal)))
	 (article-buffer (buffer-name (current-buffer)))
	 (subject-buf (eval (cdr (assq 'summary-buffer-exp cal))))
	 subject-id overviews
	 (root-dir (expand-file-name
		    (concat "m-prts-" (user-login-name)) mime/tmp-dir))
	 full-file)
    (setq root-dir (concat root-dir "/" (replace-as-filename id)))
    (setq full-file (concat root-dir "/FULL"))
    (if (null target)
	(error "%s is not supported. Sorry." target)
      )
    (if (or (file-exists-p full-file)
	    (not (y-or-n-p "Merge partials?"))
	    )
	(mime-article/decode-message/partial beg end cal)
      (message "Merging...")
      (let (cinfo the-id parameters)
	(setq subject-id 
	      (elmo-eword-decode-string
	       (decode-mime-charset-string 
		(std11-field-body "Subject")
		wl-summary-buffer-mime-charset)))
	(if (string-match "[0-9\n]+" subject-id)
	    (setq subject-id (substring subject-id 0 (match-beginning 0)))
	  )
	(setq overviews (elmo-msgdb-get-overview msgdb))
	(catch 'tag
	  (while overviews
	    (when (string-match
		   (regexp-quote subject-id)
		   (elmo-msgdb-overview-entity-get-subject
		    (car overviews)))
	      (setq cinfo
		    (tm-wl-request-partial-message 
		     folder
		     (elmo-msgdb-overview-entity-get-number (car overviews))
		     msgdb))
	      (setq parameters (mime::content-info/parameters cinfo))
	      (setq the-id (assoc-value "id" parameters))
	      (if (string= the-id id)
		  (progn
		    (set-buffer elmo-work-buf-name)
		    (setq mime::article/preview-buffer
			  (get-buffer wl-message-buf-name))
		    (mime-article/decode-message/partial
		     (point-min)(point-max) parameters)
		    (if (file-exists-p full-file)
			(throw 'tag nil)
		      )
		    )))
	    (setq overviews (cdr overviews)))
	  (message "Not all patials found."))))))

(defun tm-wl-caesar-region (beg end)
  (tm:caesar-region))

(defun tm-wl-summary-burst ()
  (interactive)
  (let ((raw-buf (wl-message-get-original-buffer))
	(i 0)
	target 
	children message-entity content-type)
    (save-excursion
      (setq target wl-summary-buffer-folder-name)
      (while (not (elmo-folder-writable-p target))
	(setq target 
	      (wl-summary-read-folder wl-default-folder "to extract to "))
	)
      (wl-summary-set-message-buffer-or-redisplay)
      (set-buffer raw-buf)
      (setq children (mime::content-info/children mime::article/content-info))
      (message "Bursting...")
      (while children
	(setq content-type (mime::content-info/type (car children)))
	(when (string= "message/rfc822" (downcase content-type))
	  (message (format "Bursting...%s" (setq i (+ 1 i))))
	  (setq message-entity 
		(car (mime::content-info/children (car children))))
	  (save-restriction
	    (narrow-to-region (mime::content-info/point-min message-entity)
			      (mime::content-info/point-max message-entity))
	    (elmo-append-msg target
			     (buffer-substring (point-min) (point-max))
			     (std11-field-body "Message-ID"))))
	(setq children (cdr children)))
      (message "Bursting...done."))
    (if (and (eq (elmo-folder-get-type target) 'imap4)
	     wl-plugged)
	(elmo-imap4-commit target))
    (wl-summary-sync-update3)))

(defun tm-wl-setup ()
  (require 'tm-view)
  (set-alist 'mime-viewer/quitting-method-alist
	     'wl-message-original-mode 'wl-message-exit)
  (set-alist 'mime-viewer/over-to-previous-method-alist
	     'wl-message-original-mode 'wl-message-exit)
  (set-alist 'mime-viewer/over-to-next-method-alist 
	     'wl-message-original-mode  'wl-message-exit)
  (set-alist 'mime-editor/message-inserter-alist
	     'wl-draft-mode (function wl-draft-insert-message))
  (set-alist 'mime-editor/mail-inserter-alist
	     'wl-draft-mode (function wl-draft-insert-message))
  (set-alist 'mime-editor/split-message-sender-alist
	     'wl-draft-mode 
	     (cdr (assq 'mail-mode 
			mime-editor/split-message-sender-alist)))
  (add-hook 'wl-summary-redisplay-hook 'tm-wl-delete-mime-out-buf)
  (add-hook 'wl-message-exit-hook 'tm-wl-delete-mime-out-buf)
  (setq wl-mime-decode-func 'tm-wl-decode-message)
  (setq wl-mime-decode-with-all-header-func 
	'tm-wl-decode-message-with-all-header)
  ;; ??? Why is this needed??
  (defvar mime::preview/mother-buffer nil)
  (setq wl-editor-mode-func 'mime/editor-mode)
  (setq wl-edit-again-func  'mime/edit-again)
  (setq wl-insert-mail-func 'mime-editor/insert-mail)
  (defalias 'wl-summary-burst 'tm-wl-summary-burst)
  (setq wl-caesar-region-func 'tm-wl-caesar-region)
  (setq wl-yank-original-func 'tm-wl-yank-original)
;;  (fset 'mime-preview/x-face-function-use-highlight-headers nil)
  (setq mime-viewer/code-converter-alist 
	(append
	 (list (cons 'wl-message-original-mode 'mime-charset/decode-buffer))
	 mime-viewer/code-converter-alist))
  (setq wl-message-read-func 'mime-viewer/scroll-up-content)
  (setq wl-message-next-content-func 'mime-viewer/next-content)
  (setq wl-message-prev-content-func 'mime-viewer/previous-content)
  (setq wl-message-play-content-func 'mime-viewer/play-content)
  (setq wl-message-extract-content-func 'mime-viewer/extract-content)
  (setq wl-message-quit-func 'mime-viewer/quit)
  (setq wl-message-button-dispatcher-func 'tm:button-dispatcher)
  (set-atype 'mime/content-decoding-condition
	     '((type . "message/partial")
	       (method . tm-wl-mime-combine-message/partial-pieces)
	       (major-mode . wl-message-original-mode)
	       (summary-buffer-exp . wl-summary-buffer-name)
	       )))
  
(provide 'tm-wl)
