#!--PERL--

## Worl Wide Sympa is a front-end to Sympa Mailing Lists Manager
## Copyright Comite Reseau des Universites


## Options :  F         -> do not detach TTY
##         :  d		-> debug -d is equiv to -dF

## Change this to point to your Sympa bin directory
use lib '--SYMPADIR--';

use List;
use Conf;
use Log;
use Getopt::Std;

require "--INSTALLDIR--/wws-lib.pl";

getopts('dF');

$Version = '0.1';

$wwsympa_conf = "--CONFIG--";

$conf = {};
$adrlist = {};

# Load WWSympa configuration
unless ($conf = &load_config($wwsympa_conf)) {
    print STDERR 'unable to load config file';
    exit;
}

## Check databse connectivity
$List::use_db = &List::probe_db();


## Put ourselves in background if not in debug mode. 
unless ($opt_d || $opt_F) {
   open(STDERR, ">> /dev/null");
   open(STDOUT, ">> /dev/null");
   if (open(TTY, "/dev/tty")) {
      ioctl(TTY, $TIOCNOTTY, 0);
      close(TTY);
   }
   setpgrp(0, 0);
   if (($_ = fork) != 0) {
      do_log('debug', "Starting archive daemon, pid $_");
      exit(0);
   }
   do_openlog($conf->{'log_facility'}, 'unix');
}

## Sympa.conf
$sympa_conf_file = $conf->{'sympa_conf_file'};



# Load sympa.conf
unless (Conf::load($sympa_conf_file)) {
    do_log  ('notice',"Unable to load sympa configuration, file $sympa_conf_file has errors.");
   exit(1);
}

## Sets the UMASK
umask($Conf{'umask'});

## Change to list root
unless (chdir($Conf{'home'})) {
    &message('chdir_error');
    &do_log('info','unable to change directory');
    exit (-1);
}

## Create and write the pidfile
unless (open(LOCK, "+>> $conf->{'archived_pidfile'}")) {
   fatal_err("Could not open %s, exiting", $conf->{'archived_pidfile'});
}
unless (flock(LOCK, 6)) {
   printf STDERR "Could not lock %s: archived is probably already running",$conf->{'archived_pidfile'} ;
   fatal_err("Could not lock %s: archived is probably already running.", $conf->{'archived_pidfile'});
}
unless (open(LCK, "> $conf->{'archived_pidfile'}")) {
   fatal_err("Could not open %s, exiting", $conf->{'archived_pidfile'});
}
unless (truncate(LCK, 0)) {
   fatal_err("Could not truncate %s, exiting.", $conf->{'archived_pidfile'});
}

print LCK "$$\n";
close(LCK);

do_log('notice', "archived $Version Started");


## Catch SIGTERM, in order to exit cleanly, whenever possible.
$SIG{'TERM'} = 'sigterm';
$end = 0;


$queue = $Conf{'queueoutgoing'};
print "queue : $queue\n";

#if (!chdir($queue)) {
#   fatal_err("Can't chdir to %s: %m", $queue);
#   ## Function never returns.
#}

## infinite loop scanning the queue (unless a sig TERM is received
while (!$end) {
   ## this sleep is important to be raisonably sure that sympa is not currently
   ## writting the file this deamon is openning. 
   sleep 2;
   ##

   unless (opendir(DIR, $queue)) {
       fatal_err("Can't open dir %s: %m", $queue); ## No return.
   }

   my @files =  (sort grep(!/^\.{1,2}$/, readdir DIR ));
   closedir DIR;
   foreach my $file (@files) {
 
       if ($file  =~ /^\.rebuild\.(.*)$/ ) {
	   do_log('debug',"rebuild found : $file for list $1");
	   unless (unlink("$queue/$file")) {
	       do_log ('notice',"Ignoring file $queue/$file because couldn't remove it, archived.pl must use the same uid as sympa");
	       next;
	   }
	   &rebuild($1);	
       }else{
	   unless ($file =~ /^(\d{4})-(\d{2})-(\d{2})-(\d{2})-(\d{2})-(\d{2})-(.*)$/) {
	       do_log ('notice',"Ignoring file $queue/$file because not to be rebuild or liste archive");
               unlink("$queue/$file");
	       next;
	   }
	   my $yyyy = $1;
	   my $mm = $2;
	   my $dd = $3;
	   my $hh = $4;
	   my $min = $5;
	   my $ss = $6;
	   my $adrlist = $7;
	   
	   $adrlist =~ /^(.*)\@(.*)$/;
	   my $listname = $1;
	   my $hostname = $2;

	   do_log('debug',"Archiving $file for list $adrlist");      
	   mail2arc ($file, $listname, $hostname, $yyyy, $mm, $dd, $hh, $min, $ss);
	   unless (unlink("$queue/$file")) {
	       do_log ('notice',"Ignoring file $queue/$file because couldn't remove it, archived.pl must use the same uid as sympa");
	       do_log ('notice',"exiting because I don't want to loop until file system is full");
	       last;
	   }
       }
   }
}
do_log('notice', 'archived exited normally due to signal');
unlink("$conf->{'archived_pidfile'}");

exit(0);


## When we catch SIGTERM, just change the value of the loop
## variable.
sub sigterm {
    $end = 1;
}


sub rebuild {

    my $adrlist = shift;
    my $arc ;

    if ($adrlist =~ /^(.*)\.(\d{4}-\d{2})$/) {
	$adrlist = $1;
        $arc = $2;
    }

    $adrlist =~ /^(.*)\@(.*)$/;
    my $listname = $1;
    my $hostname = $2;

    do_log('debug',"Rebuilding $adrlist archive ($2)");

    my $mhonarc_ressources = &get_ressources ($adrlist) ; 

    if ($arc) {
        do_log('debug',"Rebuilding  $arc of $adrlist archive");
	$arc =~ /^(\d{4})-(\d{2})$/ ;
	my $yyyy = $1 ;
	my $mm = $2 ;

	system "$conf->{'mhonarc'}  -rcfile $mhonarc_ressources -outdir $conf->{'arc_path'}/$adrlist/$yyyy-$mm  -definevars \"listname=$listname hostname=$hostname yyyy=$yyyy mois=$mm yyyymm=$yyyy-$mm wdir=$conf->{'arc_path'} base=$Conf{'wwsympa_url'}/arc \" $conf->{'arc_path'}/$adrlist/$arc/arctxt";

    }else{
        do_log('debug',"Rebuilding $adrlist archive completely");

	if (!opendir(DIR, "$conf->{'arc_path'}/$adrlist" )) {
	    do_log('notice',"unable to open $conf->{'arc_path'}/$adrlist to rebuild archive");
	    return ;
	}
	my @archives = (grep (/^\d{4}-\d{2}/, readdir(DIR)));
	close DIR ; 

	foreach my $arc (@archives) {
	    $arc =~ /^(\d{4})-(\d{2})$/ ;
	    my $yyyy = $1 ;
	    my $mm = $2 ;
	    
	    system "$conf->{'mhonarc'}  -rcfile $mhonarc_ressources -outdir $conf->{'arc_path'}/$adrlist/$yyyy-$mm  -definevars \"listname=$listname hostname=$hostname yyyy=$yyyy mois=$mm yyyymm=$yyyy-$mm wdir=$conf->{'arc_path'} base=$Conf{'wwsympa_url'}/arc \" $conf->{'arc_path'}/$adrlist/$arc/arctxt";
	}
    }
}


sub mail2arc {

    my ($file, $listname, $hostname, $yyyy, $mm, $dd, $hh, $min, $ss) = @_;
    my $arcpath = $conf->{'arc_path'};
    
    do_log('debug',"mail2arc $file for $listname\@$hostname yyyy:$yyyy, mm:$mm dd:$dd hh:$hh min$min ss:$ss");
    #    chdir($conf->{'arc_path'});
    
    if (! -d "$arcpath/$listname\@$hostname") {
	mkdir ("$arcpath/$listname\@$hostname", 0775);
	do_log('debug',"mkdir $arcpath/$listname\@$hostname");
    }
    if (! -d "$arcpath/$listname\@$hostname/$yyyy-$mm") {
	mkdir ("$arcpath/$listname\@$hostname/$yyyy-$mm", 0775);
	do_log('debug',"mkdir $arcpath/$listname\@$hostname/$yyyy-$mm");
    }
    if (! -d "$arcpath/$listname\@$hostname/$yyyy-$mm/arctxt") {
	mkdir ("$arcpath/$listname\@$hostname/$yyyy-$mm/arctxt", 0775);
	do_log('debug',"mkdir $arcpath/$listname\@$hostname/$yyyy-$mm/arctxt");
    }
    
    ## copy the file in the arctxt and in "mhonarc -add"
    opendir (DIR, "$arcpath/$listname\@$hostname/$yyyy-$mm/arctxt");
    my @files = (sort { $a <=> $b;}  readdir(DIR)) ;
    my $newfile = $files[$#files]+=1;
    
    my $mhonarc_ressources = &get_ressources ($listname . '@' . $hostname) ; 
    
    do_log ('debug',"calling $conf->{'mhonarc'} for list $listname\@$hostname" ) ;
    system "$conf->{'mhonarc'} -add -rcfile $mhonarc_ressources -outdir $arcpath/$listname\@$hostname/$yyyy-$mm  -definevars \"listname=$listname hostname=$hostname yyyy=$yyyy mois=$mm yyyymm=$yyyy-$mm wdir=$conf->{'arc_path'} base=$Conf{'wwsympa_url'}/arc \" < $queue/$file";
    
    
    open (ORIG, "$queue/$file") || fatal_err("couldn't open file $queue/$file");
    open (DEST, ">$arcpath/$listname\@$hostname/$yyyy-$mm/arctxt/$newfile") || fatal_err("couldn't open file $newfile");
    while (<ORIG>) {
        print DEST $_ ;
    }
    
    close ORIG;  
}

sub get_ressources {
    my $adrlist = shift;
    my ($mhonarc_ressources, $list);  

    $adrlist =~ /^([^@]*)\@[^@]*$/;
    unless ($list = new List ($1)) {
	do_log('notice',"unable to load list $1, continue anyway");
    }  

    my $lang = $list->{'admin'}{'lang'};
    
    if (-r "$Conf{'home'}/$list->{'name'}/$conf->{'mhonarc_ressources'}") {
	$mhonarc_ressources =  "$Conf{'home'}/$list->{'name'}/$conf->{'mhonarc_ressources'}" ;
    }elsif (-r "$conf->{'wws_path'}/$conf->{'mhonarc_ressources'}.$lang"){
        $mhonarc_ressources =  "$conf->{'wws_path'}/$conf->{'mhonarc_ressources'}.$lang" ;
    }elsif (-r "$conf->{'wws_path'}/$conf->{'mhonarc_ressources'}.default"){
	$mhonarc_ressources = "$conf->{'wws_path'}/$conf->{'mhonarc_ressources'}.default";
    }else {
	do_log('notice',"Cannot find any MhOnArc ressource file");
	return undef;
    }

    return  $mhonarc_ressources;
}
