#! --PERL--
##
## This module does the SMTP job, it does send messages using predefined
## limits.

package smtp;

use POSIX;
use Mail::Internet;
use Conf;
use Language;
use Log;

use strict;

## RCS identification.
#my $id = '@(#)$Id: smtp.pm,v 1.3 1998/11/25 14:01:09 sympa Exp $';

my $opensmtp = 0;
my $fh = 'fh0000000000';	## File handle for the stream.

my $max_arg = eval { &POSIX::_SC_ARG_MAX; };
if ($@) {
   $max_arg = 4096;
   print STDERR Msg(11, 1,
'Your system is not POSIX P1003.1 compliant, or it does not define
the _SC_ARG_MAX constant in its POSIX library. You will need to manually edit
smtp.pm and configure $max_arg
');
} else {
   $max_arg = POSIX::sysconf($max_arg);
}

my %pid = ();

## Reaper - Non blocking function called by the main loop, just to
## clean the defuncts list by waiting to any processes and decrementing
## the counter.
sub reaper {
   my $block = shift;
   my $i;

   $block = 1 unless (defined($block));
   while (($i = waitpid(-1, $block ? &POSIX::WNOHANG : 0)) > 0) {
      $block = 1;
      if (!defined($pid{$i})) {
         print STDERR "Reaper waited $i, unknown process to me\n" if ($main::opt_d);
         next;
      }
      $opensmtp--;
      delete($pid{$i});
   }
   printf STDERR "Reaper unwaited pids : %s\nOpen = %s\n", join(' ', sort keys %pid), $opensmtp if ($main::opt_d);
   return $i;
}


## Makes a sendmail ready for the recipients given as
## argument, uses a file descriptor in the smtp table
## which can be imported by other parties.
sub smtpto {
   my($from, $rcpt) = @_;
   do_log('debug2', 'smtp::smtpto(%s, %s)', $from, $rcpt);

   my($pid, $str);

   my @t = $rcpt; \@t = $rcpt;
   do_log('debug2', '[smtpto] Msg from %s, %d rcpts',$from, $#t);

   ## Escape "-" at beginning of recepient addresses
   ## prevent sendmail from taking it as argument
   if (ref($rcpt) eq 'SCALAR') {
       $$rcpt =~ s/^-/\\-/;
   }else {
       my @emails = @$rcpt;
       foreach my $i (0..$#emails) {
	   $rcpt->[$i] =~ s/^-/\\-/;
       }
   }

   ## Check how many open smtp's we have, if too many wait for a few
   ## to terminate and then do our job.
   print STDERR "Open = $opensmtp\n" if ($main::opt_d);
   while ($opensmtp > $Conf{'maxsmtp'}) {
       print STDERR "Smtpto: too many open SMTP ($opensmtp), calling reaper\n" if ($main::opt_d);
       last if (&reaper(0) == -1); ## Blocking call to the reaper.
   }

   *IN = ++$fh; *OUT = ++$fh;
   if (!pipe(IN, OUT)) {
       fatal_err(Msg(11, 2, "Can't create a pipe in smtpto: %m")); ## No return
   }
   $pid = &tools::safefork();
   $pid{$pid} = 0;
   if ($pid == 0) {
       close(OUT);
       open(STDIN, "<&IN");
       if (ref($rcpt) eq 'SCALAR') {
	   exec $Conf{'sendmail'}, '-oi', '-odi', '-oem', '-f', $from, $$rcpt;
       } else {
	   exec $Conf{'sendmail'}, '-oi', '-odi', '-oem', '-f', $from, @$rcpt;
       }
       exit 1; ## Should never get there.
   }
   if ($main::opt_m) {
       $str = "safefork: $Conf{'sendmail'} -oi -odi -oem -f $from ";
       if (ref($rcpt) eq 'SCALAR') {
	   $str .= $$rcpt;
       } else {
	   $str .= join(' ', @$rcpt);
       }
       do_log('debug', $str);
   }
   close(IN);
   $opensmtp++;
   select(undef, undef,undef, 0.3) if ($opensmtp < $Conf{'maxsmtp'});
   return("smtp::$fh"); ## Symbol for the write descriptor.
}

sub sendto {
    my($msg, $from, $rcpt) = @_;
    do_log('debug2', 'smtp::sendto(%s, %s)', $from, $rcpt);
    
    *SMTP = &smtpto($from, $rcpt);
    $msg->print(\*SMTP);
    close(SMTP);
    return 1;
}

sub mailto {
   my($msg, $from, @rcpt) = @_;
   do_log('debug2', 'smtp::mailto(%s)', $from);

   my($i, $j, $nrcpt, $size, @sendto);
   my $numsmtp = 0;

   while ($i = shift(@rcpt)) {
       my @k = reverse(split(/[\.@]/, $i));
       my @l = reverse(split(/[\.@]/, $j));
       if ($j && $#sendto >= $Conf{'avg'} && lc("$k[0] $k[1]") ne lc("$l[0] $l[1]")) {
	   &sendto($msg, $from, \@sendto);
	   $numsmtp++;
	   $nrcpt = $size = 0;
	   @sendto = ();
       }
       if ($#sendto >= 0 && (($size + length($i)) > $max_arg || $nrcpt >= $Conf{'nrcpt'})) {
	   &sendto($msg, $from, \@sendto);
	   $numsmtp++;
	   $nrcpt = $size = 0;
	   @sendto = ();
       }
       $nrcpt++; $size += length($i) + 5;
       push(@sendto, $i);
       $j = $i;
   }
   if ($#sendto >= 0) {
       &sendto($msg, $from, \@sendto) if ($#sendto >= 0);
       $numsmtp++;
   }
   
   return $numsmtp;
}

1;





