#! --PERL--
##
##
## This module is part of ML and provides some tools

package mail;

use Conf;
use Log;
use Language;
use List;

## RCS identification.
#my $id = '@(#)$Id: mail.pl,v 1.1.1.1 1998/09/18 09:16:06 sympa Exp $';

## Mail back a response to the given address.
## Data is a reference to an array or a scalar.
sub mailback {
   my($data, $subject, @rcpt) = @_;
   do_log('debug2', 'mail::mailback(%s, %s)', $subject, join(',', @rcpt));

   my $fh = smtp::smtpto("$Conf{'sympa'}", \@rcpt);
   printf $fh "To:  %s\n", join(",\n   ", @rcpt);
   print $fh "Subject: $subject\n";
   printf $fh "MIME-Version: %s\n", Msg(12, 1, '1.0');
   printf $fh "Content-Type: text/plain; charset=%s\n", Msg(12, 2, 'us-ascii');
   printf $fh "Content-Transfer-Encoding: %s\n", Msg(12, 3, '7bit');
   print $fh "\n";

   if (ref($data) eq 'SCALAR') {
      print $fh $$data;
   } elsif (ref($data) eq 'ARRAY') {
      print $fh @$data;
   }
   close($fh);
}

## send an archive file
sub mailarc {
   my($filename, $subject, @rcpt) = @_;
   do_log('debug2', 'mail::mailarc(%s, %s)', $subject, join(',', @rcpt));

   my($i);

   if (!open(IN, $filename)) {
      fatal_err("Can't send %s to %s: %m", $filename, join(',', @rcpt));
   }
   my($fh) = &smtp::smtpto($Conf{'request'}, \@rcpt);
   printf $fh "To: %s\n", join(",\n   ", @rcpt);
   print $fh "Subject: $subject\n";
   printf $fh "MIME-Version: %s\n", Msg(12, 1, '1.0');
   printf $fh "Content-Type: text/plain; charset=%s\n", Msg(12, 2, 'us-ascii');
   printf $fh "Content-Transfer-Encoding: %s\n", Msg(12, 3, '7bit');
   print $fh "\n";
   print $fh $i while ($i = <IN>);
   close($fh);
}

## send welcome,  bye, expire removed or reminder message to a user
sub mailfile {
   my ($filename, $rcpt, $data) = @_;
   do_log('debug2', 'mail::mailfile(%s, %s)', $filename, $rcpt);

   my ($full_msg, $return_path);
   
   my($fh) = &smtp::smtpto($data->{'return_path'}, \$rcpt);

   printf $fh "To: %s\n", join(",\n   ", $rcpt);
   
   ## Does the file include headers ?
   if ($filename =~ /\.tpl$/) {
       open TPL, $filename;
       my $first_line = <TPL>;
       $full_msg = 1 if ($first_line =~ /^From:\s/);
       close TPL;
   }

   ## Not a complete MIME message
   unless ( $full_msg or ($filename =~ /\.mime$/) ){
       print $fh "From: $data->{'from'}\n";
       print $fh "Subject: $data->{'subject'}\n";
       printf $fh "MIME-Version: %s\n", Msg(12, 1, '1.0');
       printf $fh "Content-Type: text/plain; charset=%s\n", Msg(12, 2, 'us-ascii');
       printf $fh "Content-Transfer-Encoding: %s\n", Msg(12, 3, '7bit');
       print $fh "\n";
   }

   if ($filename) {
       if ($filename =~ /\.tpl$/) {
	   &main::parse_tpl($data, $filename, $fh);

       }else {
	   ## Old style
	   open IN, $filename;
	   while (<IN>) {
	       s/\[listname\]/$data->{'list'}{'name'}/g;
	       s/\[subscriber_email\]/$data->{'user'}{'email'}/g;
	       s/\[email_subscriber\]/$data->{'user'}{'email'}/g;
	       s/\[subscriber_gecos\]/$data->{'user'}{'gecos'}/g;
	       s/\[sympa_email\]/$data->{'conf'}{'sympa'}/g;
	       s/\[sympa_host\]/$data->{'conf'}{'host'}/g;
	       print $fh $_ ;
	   }
	   close IN;
       }
   }else{
       print $fh $data->{'body'};
   }
       
   close ($fh);
   return 1
}


1;









