static char rcsid[] = "@(#)$Id: elmcharset.c,v 1.3.2.3 1999/11/09 19:23:31 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3.2.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "elmutil.h"
#include "s_me.h"
#include "s_elm.h"

extern char *optarg;		
extern int   optind;		

int main(argc, argv)
     int argc;
     char *argv[];
{
  int err = 0;
  int c;
  int global = 0;
  struct locale_map_item * MAP = NULL;
  struct charmap_data *charmap = NULL;
  char *targetfile = NULL;

  locale_init();
  user_init();
  init_defaults();
  
  while ((c = getopt(argc, argv, "Gd:w:")) != EOF) {
    switch(c) {
    case 'G':
	global++;
	break;
    case 'd' : 
	debug = atoi(optarg);	
	break;
    case 'w' : 
	targetfile = optarg;
	if (0 != access(targetfile,WRITE_ACCESS)) {
	    int errcode = errno;
	    
	    if (errcode != ENOENT) {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  targetfile, error_description(errcode));
		err++;
		goto fail;
	    }
	}
	break;
    case '?':
	err = 1;
	goto fail;
    }
  }

#ifndef DEBUG
  if (debug)
      printf(catgets(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
		     "Warning: system created without debugging enabled - request ignored\n"));
  debug = 0;
#endif

  if (!global)
      read_rc_file();

  if (optind < argc) {
      MAP = load_locale_map(argv[optind]);
      if (!MAP) {
	 err = 1;
	 goto fail;
      }
  }
	  
  if (!MAP) {
      if (global)
	  MAP = system_locale_map;
      else
	  MAP = user_locale_map;
  }

  if (targetfile) {
      char * tmp = elm_message(FRM("%s.N"),targetfile);
      int errcode = can_open(tmp,"w");
      FILE *f;
      
      if (errcode) {
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      f = fopen(tmp,"w");
      if (!f) {
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      dump_locale_map(f,MAP);
      if (EOF == fclose(f)) {
	  int errcode = errno;
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      if (0 != rename(tmp,targetfile)) {
	  int errcode = errno;
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
			    "Failed to rename temporary file to %.50s: %30s"),
		    targetfile, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      free(tmp);
  }    
  else
      dump_locale_map(stdout,MAP);

 fail:
  if (err)
      lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			"%s failed; exit code=%d"),
		argv[0],err);

  return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
