
static char rcsid[] = "@(#)$Id: strfcpy.c,v 1.3 1999/05/22 13:49:48 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1993 USENET Community Trust
 *****************************************************************************/

/*
 * This is just like strncpy() except:
 *
 * - The result is guaranteed to be '\0' terminated.
 *
 * - strncpy is supposed to copy _exactly_ "len" characters.  We copy
 *   _at_most_ "len" characters.  (Actually "len-1" to save space for
 *   the trailing '\0'.  That is, strncpy() fills in the end with '\0'
 *   if strlen(src)<len.  We don't bother.
 */

#include "headers.h"

char *strfcpy(dest, src, len)
     char *dest;
     CONST char *src;
     int len;
{
  int size = len;
  CONST char *src0 = src;

  char *dest0 = dest;

  while (--len > 0 && *src != '\0')
    *dest++ = *src++;

  if (*src != '\0') {
    dprint(1,(debugfile,
	      "strfcpy: --- too long string (max=%d): %.30s...\n",
	      size,src0));
  }

  *dest = '\0';
  return dest0;
}

char *strfcat(dest, src, len)
     char *dest;
     CONST char *src;
     int len;
{
  int size = len;
  CONST char *src0 = src;

  char *dest0 = dest;
  while ('\0' != *dest && --len > 0)
    dest++;
  while (--len > 0 && *src != '\0')
    *dest++ = *src++;

  if (*src != '\0') {
    dprint(1,(debugfile,
	      "strfcat: --- too long string (max target=%d): %.30s...\n",
	      size,src0));
  }

  *dest = '\0';
  return dest0;
}

#ifdef _TEST
#include <stdio.h>
main()
{
	char src[1024], dest[1024];
	int len;

	for (;;) {
		printf("string > ");
		fflush(stdout);
		if (gets(src) == NULL)
			break;
		printf("maxlen > ");
		fflush(stdout);
		if (gets(dest) == NULL)
			break;
		len = atoi(dest);
		(void) strfcpy(dest, src, len);
		printf("dest=\"%s\" maxlen=%d len=%d\n",
			dest, len, strlen(dest));
		putchar('\n');
	}
	putchar('\n');
	exit(0);
}
#endif

