;;;
;;;  cmail-19.el - cmail functions for emacs 19
;;; 
;;;  $Author: iwa $
;;;  created at: Fri May 27 13:33:49 JST 1994
;;;
;;;  Maintener:     Toshihiko Ueki <toshi@he.kobelcosys.co.jp>
;;;  Last modified: 1997/09/26
;;;
;;;  Copyright (C) 1995-1996 Yukihiro Matsumoto.

;;; cmail-19.el

(provide 'cmail-19)
(require 'cmail)

(if (featurep 'hilit19)
    (progn
      (hilit-set-mode-patterns '(cmail-readmail-mode cmail-edit-mode mime/viewer-mode mime-view-mode)
			       '(("^Subject:.*$" nil msg-subject)
				 ("^From:.*$" nil msg-from)
				 ("^--text follows this line--$"
				  nil msg-separator)
				 ("^[A-Za-z][A-Za-z0-9-]+:" nil msg-header)
				 ("^\\(In article\\|[ \t]*\\w*[]<>}|]\\).*$"
				  nil msg-quote))
			       'hilit-rehighlight-message)
      (hilit-set-mode-patterns 'cmail-summary-mode
			       '(("^ +[0-9]+ .*" nil summary-seen)
				 ("^ +[0-9]+R.*" nil msg-from)
				 ("^ +[0-9]+E.*" nil summary-Xed)
				 ("^ +[0-9]+U.*" nil summary-new)
				 ("^ +[0-9]+D.*" nil summary-deleted)
				 ("^ +[0-9]+H.*" nil msg-quote)
				 ("^\+.*" nil summary-current)))

      (defun cmail-rehighlight-line ()
	(hilit-rehighlight-region (window-start) (window-end) t))

      (mapcar (function
	       (lambda (hook)
		 (add-hook hook 'hilit-rehighlight-buffer-quietly)))
	      '(
		cmail-summary-mode-hook
		cmail-readmail-mode-hook
		cmail-edit-mode-hook
		cmail-show-contents-after-hook
		cmail-sync-header-hook
		cmail-marked-hook
		mime/viewer-mode-hook
                mime-view-mode-hook
		)
	      )
      )

  (if (or (null cmail-highlight-mode)
	  (or (null (boundp 'emacs-minor-version))
	      (< emacs-minor-version 28)))
      nil
    (if (null (boundp 'frame-parameter))
	(defun frame-parameter (frame parameter)
	  (cdr (assq parameter (frame-parameters frame)))))

    (if (null (boundp 'set-face-italic-p))
	(require 'faces)
	(defun set-face-italic-p (face italic-p &optional frame)
	  (cond ((eq italic-p nil) (make-face-unitalic face frame t))
		(t (make-face-italic face frame t)))))

    (require 'cmail-highlight)

    (let ((alist cmail-highlight-attribute-alist) entry name fore back bold italic)
      (while (setq entry (pop alist))
	(setq name (nth 0 entry)
	      fore (nth 1 entry)
	      back (nth 2 entry)
	      bold (nth 3 entry)
	      italic (nth 4 entry))
	(if fore (set-face-foreground name fore))
	(if back (set-face-background name back))
	(if bold (set-face-bold-p name bold))
	(if italic (set-face-italic-p name italic))))

    (defun cmail-highlight-mail-19 ()
      "Highlight mail."
      (interactive)
      (if cmail-highlight-mode
	(save-excursion
	  (let ((buf "*mail*"))
	    (and (get-buffer buf)
		 (set-buffer buf)
		 (cmail-highlight-message))))))

    (mapcar (function
	     (lambda (hook)
		(add-hook hook 'cmail-highlight-mail-19)))
	    '(cmail-mail-hook
	      mail-setup-hook
	      mail-mode-hook
	      text-mode-hook
	      mime/editor-mode-hook))))

(require 'timezone)

(if (null window-system)
    nil
  (define-key menu-bar-file-menu [rmail] '("Read Mail" . cmail))

  (defun cmail-mouse-select (event)
    (interactive "e")
    (mouse-set-point event)
    (cmail-read-contents (cmail-get-page-number-from-summary)))

  (require 'cmail-e19))
