/* (c) 1994,1995 by Axel Zinser aka Fifi (fifi@hiss.han.de) */
#ifdef __NeXT__
# define	_POSIX_SOURCE
# undef		__STDC__
#endif

#include	<stdio.h>
#if defined(__svr4__) || defined(__linux__)
# include	<unistd.h>
#endif
#include	<sysexits.h>
#include	<time.h>
#include	<string.h>
#include	<errno.h>
#include	<signal.h>
#include	<sys/types.h>
#include	<sys/fcntl.h>
#include	<sys/file.h>
#include	<sys/stat.h>
#include	<sys/param.h>
#include	<sys/ioctl.h>
#ifdef __svr4__
# include	<dirent.h>
#else
# include	<sys/dir.h>
#endif

#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>

#include	"alloc.h"
#include	"version.h"
#include	"xstring.h"
#include	"config.h"
#include	"depress.h"
#include	"xgetopt.h"

#if defined(sun) || defined(sun4) || defined(__NeXT__) || defined(BSD)
# define STATFS
# include	<sys/vfs.h>
#endif
#if defined(SYSV) || defined(SVR3) || defined(__svr4__)
# undef STATFS
# define USTAT
# include	<ustat.h>
# ifndef BBSIZE	/* Solaris 2.4 */
#  define BBSIZE	UBSIZE
# endif
#endif
/* ??? Was sollte das?
#if !defined(MAXSIZE) && defined(RFC1652)
# define MAXSIZE RFC1652
#endif
*/

#define	BUFLEN	4096
char	buffer[BUFLEN];

typedef struct X {
	struct X	*next;
	char		*rcpt;
} charl;

long	mode = 0;
#define	CHECKSIZE	0x0001		/* check spool space */
#define	RDSTDIN		0x0002		/* read data stream without commu */
#define	RDSTDINC	0x0004		/* data stream may be compressed */
#define	WRBSMTP		0x0008		/* write smtp cmds */
#define	WRSPOOL		0x0010		/* write to spoolfile */
#define	WRPIPE		0x0020		/* write to pipe(mailer) */
#define	NONQUIET	0x0040
#define	STDIN		0x0080
#define	DOTIMEOUT	0x0100
#define	STATE_BSMTPD	(NONQUIET|CHECKSIZE|WRBSMTP|WRSPOOL|DOTIMEOUT)
#define	STATE_BSMTP	(STDIN|CHECKSIZE|WRBSMTP|WRSPOOL|DOTIMEOUT)
#define	STATE_RBSMTP	(NONQUIET|RDSTDIN|RDSTDINC|WRPIPE)
#define	STATE_RSMTP	(NONQUIET|CHECKSIZE|WRBSMTP|WRSPOOL)

char	*montab[] = { "Jan","Feb","Mar","Apr","May","Jun","Jul",
			"Aug","Sep","Oct","Nov","Dec" };
char	*daytab[] = { "Sun","Mon","Tue","Wed","Thu","Fri","Sat" };

int	seqno = 1;
char	vstring[50];
char	*spoolfile = 0;
char	*lockfile = LOCKFILE;
long	minfree = MINFREE;
char	*tempdir = TEMPDIR;
#ifdef TIMEOUT
long	timeout = TIMEOUT;
#endif
char	*localhost;
char	*actname = 0, *remotehost = NULL;
char	*sender = NULL;
charl	*recipient = NULL;
FILE	*lfp = NULL;
long	sysspace = 0;
/* FILE	*ofp = stdout; */
FILE	*ifp = stdin;
char	*prog = 0;
#define	PROG	"bsmtpd"
char	*bparamsfile = BATCHPARAMS;
long	spoolsize = 0;
char	*bsmtphost = 0;
int	islocked = 0;

struct xpaths {
	char	*id;
	char	*path;
} xpath[] = {
#define	UUX		0
				{ "uux",		UUXPATH },
#define	GZIP		1
				{ "gzip",		GZIPPATH },
#define	COMPRESS	2
				{ "compress",		COMPRESSPATH },
#define	FREEZE		3
				{ "freeze",		FREEZEPATH },
#define	PACK		4
				{ "pack",		0 },
				{ 0,			0 }
};

typedef struct bparms {
	struct bparms *next;
	char	*site;
	long	bsize;
	int	comp;		/* 0 = no compression */
	char	*proc;
} Bparms;

Bparms	*bparms = 0;

extern int 	rcpt(), rset(), mail(), noop(), vrfy(), helo(), quit(),
	        help(), ehlo(), debug(), bsmtp_send(), turn(), data(),
	        saml(), soml(), nimp();

struct FTab {
	char	*cmd;
	int	(*func)();
} ftab[] = {
	{ "HELO",	helo },
	{ "MAIL",	mail },
	{ "RCPT",	rcpt },
	{ "DATA",	data },
	{ "RSET",	rset },
	{ "NOOP",	noop },
	{ "QUIT",	quit },
	{ "HELP",	help },
	{ "VRFY",	vrfy },
	{ "EXPN",	vrfy },
#ifdef DEBUG
	{ "DEBUG",	debug },
#endif
#ifdef FULLCMD
	{ "SEND",	bsmtp_send },
	{ "SOML",	soml },
	{ "SAML",	saml },
	{ "TURN",	turn },
#endif
# if defined(SMTPEXT) || defined(RFC1652) || defined(RFC1653) /* { */
	{ "EHLO",	ehlo },
# endif /* } SMTPEXT | RFC1652 | RFC1653 */
	{ 0,		0 }
};

int	state = 0;
#define	HELO	0x001
#define	EHLO	0x008
#define	MAIL	0x002
#define	RCPT	0x004
#define	BIT7	0x010
#define BIT8	0x20

nimp() { fprintf(stdout,"502 Command not implemented\r\n"); }
bsmtp_send() { fprintf(stdout,"502 Command not implemented\r\n"); }
saml() { fprintf(stdout,"502 Command not implemented\r\n"); }
soml() { fprintf(stdout,"502 Command not implemented\r\n"); }
turn() { fprintf(stdout,"502 Command not implemented\r\n"); }

#ifdef DEBUG
char *
now()
{
	struct tm	*nowtm;
	long		nowtime;
	static char	nowstrg[30];

	nowtime = time(0L);
	nowtm = localtime(&nowtime);
	sprintf(nowstrg,"%02d%02d:%02d%02d%02d:%05d",
		nowtm->tm_mday, nowtm->tm_mon+1, /* nowtm->tm_year, */
		nowtm->tm_hour, nowtm->tm_min, nowtm->tm_sec,
		getpid());
	return(nowstrg);
}
#endif

char *
lnow()
{
	struct tm	*tm;
	long		nowtime;
	static char	lnowstrg[30];

	nowtime = time(0L);
	tm = localtime(&nowtime);
	sprintf(lnowstrg,"%5d %2d.%2d.%2d %02d:%02d:%02d ",
		getpid(),
		tm->tm_mday, tm->tm_mon+1, tm->tm_year,
		tm->tm_hour, tm->tm_min, tm->tm_sec);
	return(lnowstrg);
}

int
read_bparams(file)
char	*file;
{
	FILE	*fp;
	char	*cp;
	static char *args[5];
	int i,line=0;
	Bparms	*bp;
	static int read_bparms = 0;

	if (read_bparms++) return(0);
	if (!file || !*file) {
		if (lfp) fprintf(lfp,"%s ERROR: no batchparms file\n",lnow());
		fprintf(stderr,"* %s no batchparms file\n",now());
		return(-1);
	}
	if (!(fp = fopen(file,"r"))) {
		if (lfp) fprintf(lfp,"%s ERROR: cannot open batchparms file \"%s\"\n",lnow(),file);
		fprintf(stderr,"* %s cannot open batchparms file \"%s\"\n",now(),file);
		return(-2);
	}
	while(fgets(buffer,BUFLEN,fp)) {
		/* host size compression process */
		line++;
		if (cp = (char*)strchr(buffer,'#')) *cp =0;
		cp = skip20(strip(buffer));
		if (!cp || !*cp) continue; /* ignore cmts & empty lines */
		if ((i = str2arr(buffer,args,4)) < 4) {
			if (lfp) fprintf(lfp,"%s ERROR: %s, line %d: not enough parameters: %d\n",lnow(),file,line,i);
			fprintf(stderr,"* %s %s, line %d: not enough parameters: %d\n",now(),file,line,i);
			continue;
		}
		for(i=1; xpath[i].id && strcmp(args[2],xpath[i].id); i++);
		if (!xpath[i].path) {
			if (lfp) fprintf(lfp,"%s ERROR: %s, line %d: unavailable compression method: %s\n",lnow(),file,line,args[2]);
			fprintf(stderr,"* %s %s, line %d: unavailable compression method: %s\n",now(),file,line,args[2]);
			continue;
		}
		bp = (Bparms *)ckalloc(1,sizeof(Bparms));
		bp->next = bparms;
		bp->site = strdup(args[0]);
		bp->bsize = atoi(args[1]);
		bp->comp = i;
		bp->proc = strdup(args[3]);
		bparms = bp;
#ifdef DEBUG
		fprintf(stderr,"* %s accepted bparm: %s %d %s %s\n",now(),bp->site,bp->bsize,xpath[i].path,bp->proc);
		fflush(stderr);

#endif
	}
	fclose(fp);
}

#ifdef TIMEOUT
void
dotimeout(sig)
int sig;
{
# ifdef DEBUG
		fprintf(stderr,"* %s timeout waiting for input after %d seconds\n",now(),timeout);
		fflush(stderr);
# endif
		fprintf(stdout,"451 timeout waiting for input after %d seconds.\r\n",timeout);
		terminate(EX_IOERR);
}
#endif

lock()
{
	int	o;

#ifdef TIMEOUT
	if (mode & DOTIMEOUT) signal(SIGALRM,SIG_IGN); /* disable timeout */
#endif
	while(!access(lockfile,F_OK) || (o=open(lockfile,O_WRONLY|O_CREAT|O_EXCL|O_NDELAY|O_SYNC,0644)) < 0)
		sleep(1);
# ifdef DEBUG
	fprintf(stderr,"* %s lock \"%s\"\n",now(),lockfile);
	fflush(stderr);
# endif
	sprintf(buffer,"%d\n",getpid());
	write(o,buffer,strlen(buffer)+1);
	close(o);
	lfp = fopen(LOGFILE,"a+");
# ifdef DEBUG /* { */
	fprintf(stderr,"* %s open log \"%s\" %s\n",now(),
		LOGFILE,(lfp ? "suceeded" : "failed"));
	fflush(stderr);
# endif /* } DEBUG */
	islocked++;
	return(0);
}

unlock()
{
	if (!islocked) return(0);
#ifdef DEBUG /* { */
	fprintf(stderr,"* %s unlock \"%s\"\n",now(),lockfile);
	if (access(lockfile,F_OK)) fprintf(stderr,"* %s missing lockfile\n",now());
	fflush(stderr);
#endif /* } DEBUG */
	if (lfp) fclose(lfp);
	unlink(lockfile);
	islocked = 0;
#ifdef TIMEOUT
	if (mode & DOTIMEOUT) {
		alarm(timeout);
		signal(SIGALRM,dotimeout);
	}
#endif
}

fsize(file)
char *file;
{
	struct stat st;

	if (access(spoolfile,F_OK))
		/* not existing */
		return(0);
	if (stat(spoolfile,&st))
		/* no access */
		return(0);
	/* if (!st.st_size)
		// empty //
		return(0); */
	return(st.st_size);
}

uux()
{
	FILE	*pp;
	FILE	*fp;
#ifdef BACKUPFILE /* { */
	static char bakfile[256];
#endif /* } BACKUPFILE */
#if defined(BACKUPFILE) /* { */
	long	t = time(0L);
#endif /* } BACKUPFILE */
	static char deliver[256];
	Bparms *bp;

	if (!fsize(spoolfile)) {
		if (lfp) fprintf(lfp,"%s ERROR: %s not existing, empty or unavailable\n",lnow(),spoolfile);
		return(0);
	}
	/* check wether uux(1) is available */
	if (!xpath[UUX].path || access(xpath[UUX].path, X_OK)) {
		if (lfp) fprintf(lfp,"%s ERROR: uux \"%s\" not existing or executable\n",lnow(),(xpath[UUX].path?xpath[UUX].path:"<undefined>"));
		fprintf(stderr,"* %s uux \"%s\" not existing or executable\n",now(),(xpath[UUX].path?xpath[UUX].path:"<undefined>"));
		return;
	}
	/* read batchparms file */
	read_bparams(bparamsfile);
	for(bp = bparms; bp && strcmp(bsmtphost,bp->site); bp = bp->next);
	if (!bp) {
		if (lfp) fprintf(lfp,"%s ERROR: no batchparms for system \"%s\"\n",lnow(),bsmtphost);
		fprintf(stderr,"* %s no batchparms for system \"%s\"\n",now(),bsmtphost);
		fflush(stderr);
		return;
	}
	/* look for give compression program */
	if (!bp->comp || access(xpath[bp->comp].path, X_OK)) {
		if (lfp) fprintf(lfp,"%s ERROR: compression program \"%s\" not existing or executable\n",lnow(),(bp->comp?xpath[bp->comp].path:"<undefined>"));
		fprintf(stderr,"* %s compression program \"%s\" not existing or executable\n",now(),(bp->comp?xpath[bp->comp].path:"<undefined>"));
	}
	sprintf(deliver,"%s %s %s - -gA -r %s!%s",
		(bp->comp?xpath[bp->comp].path:""),(bp->comp?"|":""),
		xpath[UUX].path,
		bsmtphost,
		bp->proc);
	if (pp = popen(deliver,"w")) {
		if (fp = fopen(spoolfile,"r")) {
#ifdef DEBUG /* { */
			fprintf(stderr,"* %s open pipe \"%s\"\n",now(),deliver);
			fflush(stderr);
#endif /* } DEBUG */
			if (lfp) fprintf(lfp,"%s %s\n",lnow(),deliver);
			fprintf(pp,"HELO %s\n",localhost);
			while(fgets(buffer,BUFLEN,fp)) fputs(buffer,pp);
			fprintf(pp,"QUIT\n");
			fclose(fp);
#ifdef BACKUP
# error Bitte BACKUPFILE setzen!
#endif
#ifdef BACKUPFILE /* { */
			sprintf(bakfile,BACKUPFILE,bsmtphost,t,getpid());
			if (rename(spoolfile,bakfile)) {
				perror("* popen");
				fprintf(stderr,"* %s cannot rename \"%s\"\n",now(),bakfile);
				fflush(stderr);
			}
			if (lfp) fprintf(lfp,"%s %s => %s\n",lnow(),spoolfile,bakfile);
#else /* }{ BACKUPFILE */
			unlink(spoolfile);
			if (lfp) fprintf(lfp,"%s %s processed\n",lnow(),spoolfile);
#endif /* } BACKUPFILE */
			
		}
		pclose(pp);
	}
#ifdef DEBUG /* { */
	else {
		perror("* popen");
		fprintf(stderr,"* %s cannot open pipe \"%s\"\n",now(),deliver);
		fflush(stderr);
	}
#endif /* } DEBUG */
}

#ifdef DEBUG
debug()
{
	fprintf(stdout,"500 Command unrecognized\r\n");
	fprintf(stderr,"* %s Debug turned on. Keep care of what you're doing!\n",now());
	fflush(stderr);
	state |= (RCPT|MAIL);
	if (!sender) sender = strdup("fifi@kaa.han.de");
	if (!recipient) {
		recipient = (charl *)ckalloc(1,sizeof(charl));
		recipient->next = 0;
		recipient->rcpt = strdup("fifi@kaa.han.de");
	}
}
#endif

data()
{
	int	i;
	FILE	*tp,*fp;
	int	term = 0;
	static char tempfile[MAXNAMLEN];
	charl	*rp;
	Bparms	*bp;
#ifdef AUTOUUX
	long	sz;
#endif
#ifdef MAXSIZE
	long	msgs = 0;
#endif
#ifdef RECEIVED /* { */
	int	body = 0;
	int	recv = 0;
#endif /* } RECEIVED */
	struct tm *tm;
	long size=0, lines=0;
	long	t;

	t = time(0L);
#if defined(RECEIVED) /* { */
	tm = gmtime(&t);
#endif /* } RECEIVED */
	if (!(state & MAIL)) {
		fprintf(stdout,"503 Need MAIL command\r\n");
		return(1);
	}
	if (!(state & RCPT)) {
		fprintf(stdout,"503 Need RCPT (recipient)\r\n");
		return(1);
	}
	/* open temporary file */
	sprintf(tempfile,"%s/q%05d.%02d.%d",tempdir,getpid(),seqno++,t);
# ifdef DEBUG /* { */
	fprintf(stderr,"* %s open tempfile %s\n",now(),tempfile);
	fflush(stderr);
# endif /* } DEBUG */
	if (!(tp = fopen(tempfile,"w"))) {
		/* open failed... */
#ifdef DEBUG
		perror("* open failed");
#endif
		fprintf(stdout,"550 Requested action not taken: tempfile unavailable\r\n");
		terminate(EX_CANTCREAT);
	}
	chmod(tempfile,S_IWUSR|S_IRUSR);
	if (mode & WRBSMTP) {
		fprintf(tp,"MAIL FROM: <%s>\n",sender);
#ifdef DEBUG /* { */
		fprintf(stderr,"* %s MAIL FROM: <%s>\n",now(),sender);
		fflush(stderr);
#endif /* } DEBUG */
		rp = recipient;
		while (rp) {
			fprintf(tp,"RCPT TO: <%s>\n",rp->rcpt);
#ifdef DEBUG /* { */
			fprintf(stderr,"* %s RCPT TO: <%s>\n",now(),rp->rcpt);
			fflush(stderr);
#endif /* } DEBUG */
			rp = rp->next;
		}
		fprintf(tp,"DATA\n");
		if (mode & NONQUIET) {
			fprintf(stdout,"354 Send");
			if (state & BIT7) fprintf(stdout," 7BIT");
			else if (state & BIT8) fprintf(stdout," 8BITMIME");
			fprintf(stdout," message, end with \".\" on a line by itself\r\n");
			fflush(stdout);
		}
# ifdef DEBUG
		fprintf(stderr,"* %s start mail\n",now());
		fflush(stderr);
# endif
	}
	while(fgets(buffer,BUFLEN,ifp)) {
#ifdef TIMEOUT
		if (mode & DOTIMEOUT) alarm(timeout); /* reset timer */
#endif
		stripcr(buffer);
#ifdef RECEIVED /* { */
		if (!body && !recv && (!*buffer || !strnucmp(buffer,"Received: ",10))) {
			if (!remotehost || !*remotehost) remotehost = localhost;
			if (!actname || !*actname) actname = remotehost;
			fprintf(tp,"%s: from %s (%s)\n\tby %s (%s);\n\t%s",
				RECEIVED, remotehost, actname,
				localhost, vstring, asctime(tm));
# ifdef DEBUG
			fprintf(tp,"\tusing %s\n",tempfile);
# endif
			fflush(tp);
			recv++;
		}
		if (!*buffer) body++;
#endif /* } RECEIVED */
		strcat(buffer,"\n");
		if (!fputs(buffer,tp)) {
			/* error occured */
#ifdef DEBUG /* { */
			perror("* write failed");
#endif /* } DEBUG */
			fprintf(stdout,"552 Requested mail action aborted: write failed\r\n");
			terminate(EX_IOERR);
		}
#ifdef MAXSIZE
		msgs += strlen(buffer);
		if ((msgs / 1024) > MAXSIZE) {
			fprintf(stdout,"552 Requested mail action aborted: exceeeded permitted message size\r\n");
			terminate(EX_NOPERM);
		}
#endif
		stripcr(buffer);
		if (!(mode & STDIN) && !strcmp(buffer,".")) {
			term++;
#ifdef DEBUG /* { */
			fprintf(stderr,"* %s eof detected\n",now());
			fflush(stderr);
#endif /* } DEBUG */
			break;
		}
		lines++; size += strlen(buffer);
	}
	if (mode & STDIN) fputs(".\n",tp);
	fclose(tp);
#ifdef DEBUG /* { */
	fprintf(stderr,"* %s fclose ok\n",now(),fp);
	fflush(stderr);
#endif /* } DEBUG */
	if (!(mode & STDIN) && !term) {
#ifdef DEBUG /* { */
		fprintf(stderr,"* %s eof missed\n",now());
		fflush(stderr);
#endif /* } DEBUG */
		unlink(tempfile);
		terminate(EX_IOERR);
	}
	/* try to deliver file */
	lock();
	if (lfp) fprintf(lfp,"%s %s %s -> @%s:", lnow(), prog,sender,bsmtphost);
	/* reopen tempfile */
	if (!(tp = fopen(tempfile,"r"))) {
#ifdef DEBUG
		perror("* reopen failed");
#endif
		fprintf(stdout,"550 Requested action not taken: tempfile reopen failed\r\n");
		terminate(EX_IOERR);
	}
	if (mode & WRSPOOL) {
# ifdef DEBUG /* { */
		fprintf(stderr,"* %s open file %s\n",now(),spoolfile);
		fflush(stderr);
# endif /* } DEBUG */
		if (!(fp = fopen(spoolfile,"a+"))) {
# ifdef DEBUG
			perror("* open failed");
# endif
			fprintf(stdout,"550 Requested action not taken: mailbox unavailable\r\n");
			terminate(EX_CANTCREAT);
		}
		chmod(spoolfile,S_IWUSR|S_IRUSR);
	} else /* if (mode & WRPIPE) */ {
		/* accept data from ifp */
#ifdef V8SENDMAIL
		sprintf(buffer,"%s -p BSMTP:%s -f%s ",SENDMAIL,remotehost,sender);
#else
		sprintf(buffer,"%s -f%s ",SENDMAIL,sender);
#endif
	}
	while (recipient) {
		if (mode & WRPIPE) {
			strcat(buffer,"\"");
			strcat(buffer,recipient->rcpt);
			strcat(buffer,"\"");
			strcat(buffer," ");
		}
		if (lfp) fprintf(lfp,"%s ",recipient->rcpt);
		recipient = recipient->next;
	}
	if (mode & WRPIPE) {
# ifdef DEBUG
		fprintf(stderr,"* %s popen(%s)\n",now(),buffer);
		fflush(stderr);
# endif
		if (!(fp = popen(buffer,"w"))) {
			fprintf(stderr,"* %5d popen(%s) failed \n",getpid(),buffer);
			terminate(EX_OSERR);
		}
	}
	reset();
	while(fgets(buffer,BUFLEN,tp)) {
		if (!fputs(buffer,fp)) {
			/* error occured */
#ifdef DEBUG /* { */
			perror("* write failed");
#endif /* } DEBUG */
			fprintf(stdout,"552 Requested mail action aborted: write failed\r\n");
			terminate(EX_IOERR);
		}
	}
	fclose(tp);
	if (mode & WRSPOOL) fclose(fp);
	   else /* if (mode & WRPIPE) */ pclose(fp);
	unlink(tempfile);
#ifdef DEBUG /* { */
	fprintf(stderr,"* %s fclose ok\n",now(),fp);
	fflush(stderr);
#endif /* } DEBUG */
	if (lfp) {
		fprintf(lfp,"(L:%d,S:%d)\n",lines,size);
		fflush(lfp);
	}
#if defined(AUTOUUX) /* { */
	if (mode & WRSPOOL) {
		sz = fsize(spoolfile);
		read_bparams(bparamsfile);
		for(bp=bparms; bp && strcmp(bsmtphost,bp->site); bp=bp->next);
		if (!bp) {
			if (lfp) fprintf(lfp,"%s ERROR: no batchparms for system \"%s\"\n", lnow(),bsmtphost);
#  ifdef DEBUG /* { */
			fprintf(stderr,"* %s no batchparms for system \"%s\"\n",now(),bsmtphost);
			fflush(stderr);
#  endif /* } DEBUG */
			spoolsize = -1;
		} else
			spoolsize = bp->bsize;
# ifdef DEBUG /* { */
		fprintf(stderr,"* %s %s: %d (uux: %d)\n",now(),spoolfile,sz,spoolsize);
		fflush(stderr);
# endif /* } DEBUG */
		if ((spoolsize > 0) && (sz > spoolsize)) uux();
	}
#endif /* } AUTOUUX */
	unlock();
	if (mode & NONQUIET) fprintf(stdout,"250 Ok\r\n");
	return(0);
}

reset()
{
	sender = 0;
	recipient = 0;
	state &= ~(BIT7|BIT8|MAIL|RCPT);
}

rset()
{
	reset();
	fprintf(stdout,"250 Reset state\r\n");
	return(0);
}

rcpt()
{
	char	*cp,*sp;
	charl	*cl;

	if (!(cp = strchr(buffer,':'))) {
		fprintf(stdout,"501 Syntax error\r\n");
		return(1);
	}
	cp = skip20(cp+1);
	if (!cp || !*cp) return(0);
	while (*cp == '<') {
		cp++;
		if (sp = strrchr(cp,'>')) *sp = 0;
	}
	state |= RCPT;
	cl = (charl*)ckalloc(1,sizeof(charl));
	cl->next = recipient;
	cl->rcpt = strdup(cp);
	recipient = cl;
	fprintf(stdout,"250 %s... Recipient ok\r\n",recipient->rcpt);
	return(0);
}

mail()
{
	char	*cp;
	char	*sp;
#if defined(RFC1653) /* { */
	long	s = 0;
#endif /* } */

	if (state & MAIL) {
		fprintf(stdout,"554 Nested MAIL command\r\n");
		return(1);
	}
	if (!(cp = strchr(buffer,':'))) {
		fprintf(stdout,"501 Syntax error\r\n");
		return(1);
	}
	state |= MAIL;
	cp = skip20(cp+1);
	if (!cp || !*cp) cp = "root";
#if defined(RFC1653) || defined(RFC1652) /* { */
	if (state & EHLO) {
		/* look for size parameter */
		if (sp = skipch(cp,' ')) *sp++ = 0;
		while (sp && *sp && (sp = skip20(sp))) {
# if defined(RFC1652) /* { */
			if (!strnucmp(sp,"body=",5)) {
				sp += 5;
#ifdef DEBUG
				fprintf(stderr,"* %s got body=%s\n",now(),sp);
#endif
				if (!struncmp(sp,"7bit",4)) {
					state |= BIT7;	
				} else if (!struncmp(sp,"8bitmime",8)) {
					state |= BIT8;
				} else {
					fprintf(stdout,"501 Syntax error in parameter body\r\n");
					reset();
					return(1);
				}
				sp = skip2space(sp);
				continue;
			}
# endif /* } RFC1652 */
# if defined(RFC1653) /* { */
			if (!strnucmp(sp,"size=",5)) {
				s = atol(sp+5);
#ifdef DEBUG
				fprintf(stderr,"* %s got size=%d\n",now(),s);
#endif
#ifdef MAXSIZE
				/* because some systems ignore the size-
				 * parameter at greeting message time */
				if (((s+1023)/1024) > MAXSIZE) {
					fprintf(stdout,"452 Message too large\r\n");
					reset();
					return(1);
				}
#endif
				if (((s+1023)/1024) > sysspace) {
					/* out of memory */
					fprintf(stdout,"452 Message too long\r\n");
					reset();
					return(1);
				}
				sp = skip2space(sp);
				continue;
			}
# endif /* } RFC1653 */
			fprintf(stdout,"501 Syntax error in arguments: %s\r\n",sp);
			reset();
			return(1);
		}
	}
#endif /* } RFC1653 || RFC1652 */
	while (*cp == '<') {
		cp++;
		if (sp = strrchr(cp,'>')) *sp = 0;
	}
	if (!*cp) {
		sender = (char*)ckalloc(1,(strlen("Mailer-Deamon")+strlen(remotehost)+5));
		sprintf(sender,"%s!%s",remotehost,"Mailer-Deamon");
	} else {
		sender = strdup(cp);
	}
	fprintf(stdout,"250 %s... Sender ok\r\n",sender);
	return(0);
}

vrfy()
{
	char	*cp;
	cp = skip20(buffer+sizeof("HELO"));

	fprintf(stdout,"250 %s (unchecked)\r\n",cp);
	return(0);
}

#if defined(RFC1652) || defined(RFC1653) /* { */
ehlo()
{
	helo();
	state = EHLO;
#ifdef MIME
# if defined(RFC1652) || defined(RFC1653) /* { */
	fprintf(stdout,"250-MIME\r\n");
# else
	fprintf(stdout,"250 MIME\r\n");
# endif /* } */
#endif
# ifdef RFC1653 /* { */
#  ifdef RFC1652 /* { */
	fprintf(stdout,"250-SIZE %d\r\n",RFC1653*1024);
#  else
	fprintf(stdout,"250 SIZE %d\r\n",RFC1653*1024);
#  endif
# endif /* } RFC1653 */
# ifdef RFC1652 /* { */
	fprintf(stdout,"250 8BITMIME\r\n");
# endif /* } RFC1653 */
	return(0);
}
#endif /* } RFC1652 | RFC1653 */

helo()
{
	char	*cp;

	state = HELO;
	cp = skip20(buffer+sizeof("HELO"));
	actname = strdup(cp);
	if (!remotehost) remotehost = actname;
#if defined(MIME) || defined(RFC1652) || defined(RFC1653) /* { */
	if ((*buffer == 'E') || (*buffer == 'e'))
		fprintf(stdout,"250-");
	else
#endif /* } */
	fprintf(stdout,"250 ");
	fprintf(stdout,"%s Hi %s, ",localhost,remotehost);
	if (!strucmp(remotehost,cp)) fprintf(stdout,"nice to meet you\r\n");
		else fprintf(stdout,"why do you call yourself %s?\r\n",cp);
	return(0);
}

noop()
{
	fprintf(stdout,"200 OK\r\n");
	return(EX_OK);
}

quit()
{
	terminate(EX_OK);
}

terminate(status)
int status;
{
	unlock();
	fprintf(stdout,"221 %s closing connection\r\n",localhost);
#ifdef DEBUG
	fprintf(stderr,"* %s ready...\n",now());
	fflush(stderr);
#endif
	fflush(stdout);
	exit(status);
}

help()
{
	int	i;

	fprintf(stdout,"214-Commands:\r\n");
	for(i=0; ftab[i].cmd; i++) {
		if (!(i%5)) fprintf(stdout,"214-");
		fprintf(stdout,"   %-5.5s",ftab[i].cmd);
		if ((i%5) == 4) fprintf(stdout,"\r\n");
	}
	if ((i%5) != 4) fprintf(stdout,"\r\n");
	fprintf(stdout,"214-In case of problems please contact fifi@rz.uni-hildesheim.de\r\n");
	fprintf(stdout,"214 End of help info\r\n");
	return(0);
}

main(argc,argv)
int	argc;
char	**argv;
{
	char	*cp;
	struct tm	*tm;
	long	t;
	int	i;
	FILE	*fp;
#ifdef BSMTP
	int	opt;
	charl	*cl;
#endif
	Bparms	*bp;
	int fromlen;
	struct sockaddr_in from;
	struct hostent *hp;
#ifdef STATFS
	struct statfs sfs;
#endif
#ifdef USTAT
	struct	stat st;
	struct	ustat ust;
#endif

	setuid(geteuid());
	prog = basename(argv[0]);
#if defined(DEBUG) && defined(DEBUGDEV)
	if ((i = open(DEBUGDEV,O_CREAT|O_WRONLY|O_APPEND,0600))) {
		close(2);
		dup(i);
		close(i);
	}
#endif

	gethostname(buffer,BUFLEN);
	localhost = strdup(buffer);
	t = time(0L);
	tm = gmtime(&t);

	sprintf(vstring,"%s %s",prog,VERSION);
#ifdef MIME
	strcat(vstring,"m");
#endif
#ifdef RFC1652
	strcat(vstring,"M");
#endif
#ifdef RFC1653
	strcat(vstring,"S");
#endif

# ifdef DEBUG
	fprintf(stderr,"* %s %s (%s) ready\n",now(),argv[0],vstring);
	fprintf(stderr,"* uid()=%d, euid()=%d\n",getuid(),geteuid());
	fflush(stderr);
# endif

	if (!strcmp(prog,BSMTPD)) {
		mode = STATE_BSMTPD;
		fromlen = sizeof (from);
		if (getpeername(0, &from, &fromlen) < 0) {
			fprintf(stdout,"522 Can't get peer name of remote host\r\n");
			terminate(EX_PROTOCOL);
		}
		from.sin_port = ntohs((u_short)from.sin_port);
		if (!(hp = gethostbyaddr((char*)&from.sin_addr, sizeof (struct in_addr), from.sin_family)))
			remotehost = (char*)inet_ntoa(from.sin_addr);
		else
			remotehost = hp->h_name;
# ifdef DEBUG
		fprintf(stderr,"* %s remote host: %s\n",now(),remotehost);
		fflush(stderr);
# endif
	}
# ifdef DEBUG
	else if (!strcmp(prog,"lock")) {
		lock();
		exit(EX_OK);
	} else if (!strcmp(prog,"unlock")) {
		islocked++;
		unlock();
		exit(EX_OK);
	}
#endif
#ifdef CALLUUX /* { */
	else if (!strcmp(prog,CALLUUX)) {
		while((opt = xgetopt(argc,argv,"B:U:C:F:G:h")) != EOF) {
			switch(opt) {
			default:
			case '?':
			case 'h':
				fprintf(stdout,"%s V%s\n",PROG,VERSION);
				fprintf(stdout,"usage: %s [options] site[s]\n",prog);
				fprintf(stdout,"\tOptions:\n");
				fprintf(stdout,"\t-U %%s\tpath to uux (Def.: %s)\n",(xpath[UUX].path?xpath[UUX].path:"-none-"));
				fprintf(stdout,"\t-C %%s\tpath to compress (Def.: %s)\n",(xpath[COMPRESS].path?xpath[COMPRESS].path:"-none-"));
				fprintf(stdout,"\t-F %%s\tpath to freeze (Def.: %s)\n",(xpath[FREEZE].path?xpath[FREEZE].path:"-none-"));
				fprintf(stdout,"\t-G %%s\tpath to gzip (Def.: %s)\n",(xpath[GZIP].path?xpath[GZIP].path:"-none-"));
				fprintf(stdout,"\t-B %%s\tpath to batchparms (Def.: %s)\n",(bparamsfile?bparamsfile:"-none-"));
				exit(EX_USAGE);
			case 'C':
				if (access(xoptarg,X_OK)) {
					fprintf(stderr,"* %s file \"%s\" not existing or executable\n",now(),xoptarg);
					exit('c');
				}
				xpath[COMPRESS].path = strdup(xoptarg);
				break;
			case 'F':
				if (access(xoptarg,X_OK)) {
					fprintf(stderr,"* %s file \"%s\" not existing or executable\n",now(),xoptarg);
					exit('f');
				}
				xpath[FREEZE].path = strdup(xoptarg);
				break;
			case 'G':
				if (access(xoptarg,X_OK)) {
					fprintf(stderr,"* %s file \"%s\" not existing or executable\n",now(),xoptarg);
					exit('g');
				}
				xpath[GZIP].path = strdup(xoptarg);
				break;
			case 'U':
				if (access(xoptarg,X_OK)) {
					fprintf(stderr,"* %s file \"%s\" not existing or executable\n",now(),xoptarg);
					exit('c');
				}
				xpath[UUX].path = strdup(xoptarg);
				break;
			case 'B':
				bparamsfile = strdup(xoptarg);
				break;
			}
		}
		read_bparams(bparamsfile);
		if (xoptind >= argc) {
			for(bp=bparms; bp; bp=bp->next) {
				if (!bp->comp) continue;
				bsmtphost = bp->site;
				spoolfile = ckalloc(1,sizeof(SPOOLFILE)+1+strlen(bsmtphost)+1);
				sprintf(spoolfile,SPOOLFILE,bsmtphost);
#ifdef DEBUG
				fprintf(stderr,"* %s spoolfile is %s\n",now(),spoolfile);
				fflush(stderr);
#endif
				if (i=fsize(spoolfile)) {
					lock();
					uux();
					unlock();
#ifdef DEBUG
					fprintf(stderr,"* %s filesize: %d\n",now(),i);
					fflush(stderr);
				} else {
					fprintf(stderr,"* %s spoolfile empty\n",now());
					fflush(stderr);
#endif
				}
				ckfree(spoolfile);
			}
		} else while(xoptind < argc) {
			bsmtphost = argv[xoptind++];
			spoolfile = ckalloc(1,sizeof(SPOOLFILE)+1+strlen(bsmtphost)+1);
			sprintf(spoolfile,SPOOLFILE,bsmtphost);
#ifdef DEBUG
			fprintf(stderr,"* %s spoolfile is %s\n",now(),spoolfile);
			fflush(stderr);
#endif
			if (i=fsize(spoolfile)) {
				lock();
				uux();
				unlock();
#ifdef DEBUG
				fprintf(stderr,"* %s filesize: %d\n",now(),i);
				fflush(stderr);
			} else {
				fprintf(stderr,"* %s spoolfile empty\n",now());
				fflush(stderr);
#endif
			}
			ckfree(spoolfile);
		}
		exit(EX_OK);
	}
#endif /* } CALLUUX */
# ifdef BSMTP
	else if (!strcmp(prog,BSMTP)) {
		mode = STATE_BSMTP;
		state = MAIL|RCPT|HELO;
		sender = 0;
		bsmtphost = 0;
		while((opt = xgetopt(argc,argv,"U:C:G:F:B:p:T:ht:s:i:f:")) != EOF) {
			switch(opt) {
			default:
			case '?':
			case 'h':
				fprintf(stdout,"%s V%s\n",PROG,VERSION);
				fprintf(stdout,"usage: %s -t host -f from [options] receipient[s]\n",prog);
				fprintf(stdout,"\t-t %%s\tdestination host\n");
				fprintf(stdout,"\t-f %%s\tsender adress (fqdn)\n");
				fprintf(stdout,"\tOptions:\n");
/*
				fprintf(stdout,"\t-p %%s\tdelivery program (Def.: %s)\n",recvproc);
*/
				fprintf(stdout,"\t-s %%d\tmaximum message size (Def.: %d)\n",spoolsize);
				fprintf(stdout,"\t-i %%?\tnot yet implemented\n");
#ifdef TIMEOUT /* { */
				fprintf(stdout,"\t-T %%d\ttimout [sec.] (Def.: %d)\n",timeout);
#endif /* } */
				fprintf(stdout,"\t-U %%s\tpath to uux (Def.: %s)\n",(xpath[UUX].path?xpath[UUX].path:"-none-"));
				fprintf(stdout,"\t-C %%s\tpath to compress (Def.: %s)\n",(xpath[COMPRESS].path?xpath[COMPRESS].path:"-none-"));
				fprintf(stdout,"\t-F %%s\tpath to freeze (Def.: %s)\n",(xpath[FREEZE].path?xpath[FREEZE].path:"-none-"));
				fprintf(stdout,"\t-G %%s\tpath to gzip (Def.: %s)\n",(xpath[GZIP].path?xpath[GZIP].path:"-none-"));
				fprintf(stdout,"\t-B %%s\tpath to batchparms (Def.: %s)\n",(bparamsfile?bparamsfile:"-none-"));
				exit(EX_USAGE);
			case 'C':
				xpath[COMPRESS].path = strdup(xoptarg);
				break;
			case 'F':
				xpath[FREEZE].path = strdup(xoptarg);
				break;
			case 'G':
				xpath[GZIP].path = strdup(xoptarg);
				break;
			case 'U':
				xpath[UUX].path = strdup(xoptarg);
				break;
			case 'B':
				bparamsfile = strdup(xoptarg);
				break;
			case 's':
				spoolsize = atoi(xoptarg);
#ifdef DEBUG
				fprintf(stderr,"* %s spoolsize set to %d\n",now(),spoolsize);
				fflush(stderr);
#endif
				break;
			case 'i':
				/* ignore now */
				break;
#ifdef TIMEOUT /* { */
			case 'T':
				timeout = atoi(xoptarg);
				if (timeout <= 0) {
					timeout = 0;
					mode &= ~DOTIMEOUT;
				} else {
					mode |= DOTIMEOUT;
				}
# ifdef DEBUG
				fprintf(stderr,"* %s timeout set to %d seconds\n",now(),timeout);
				fflush(stderr);
# endif
				break;
#endif /* } TIMEOUT */
/*
			case 'p':
				recvproc = strdup(xoptarg);
#ifdef DEBUG
				fprintf(stderr,"* %s %s... recvproc ok\n",now(),recvproc);
				fflush(stderr);
#endif
				break;
*/
			case 't':
				bsmtphost = strdup(xoptarg);
#ifdef DEBUG
				fprintf(stderr,"* %s %s... bsmtphost ok\n",now(),bsmtphost);
				fflush(stderr);
#endif
				break;
			case 'f':
				sender = strdup(xoptarg);
#ifdef DEBUG
				fprintf(stderr,"* %s %s... Sender ok\n",now(),sender);
				fflush(stderr);
#endif
				break;
			}
		}
		while(xoptind < argc) {
			cl = (charl*)ckalloc(1,sizeof(charl));
			cl->next = recipient;
			cl->rcpt = strdup(argv[xoptind]);
			recipient = cl;
#ifdef DEBUG
			fprintf(stderr,"* %s %s... Recipient ok\n",now(),recipient->rcpt);
			fflush(stderr);
#endif
			xoptind++;
		}
		if (!recipient || !sender || !bsmtphost) {
			fprintf(stdout,"insufficient parameters\n");
			exit(EX_USAGE);
		}
	}
#endif
# ifdef RBSMTP
	else 
#  ifndef RBSMTPELSE
	     if (!strcmp(prog,RBSMTP))
#  endif
	{
		mode = STATE_RBSMTP;
		bsmtphost = localhost;
		close(1);
		dup(2);
	}
#  ifndef RBSMTPELSE
	else {
		fprintf(stderr,"invalid name: %s\n",prog);
		exit(EX_USAGE);
	}
#  endif
# endif
	spoolfile = ckalloc(1,sizeof(SPOOLFILE)+1+strlen(bsmtphost)+1);
	sprintf(spoolfile,SPOOLFILE,bsmtphost);
	/*
	lockfile = ckalloc(1, strlen(spoolfile)+6);
	sprintf(lockfile,"%s.lck",spoolfile);
	*/
#ifdef DEBUG
	fprintf(stderr,"* %s spoolfile is %s\n",now(),spoolfile);
#endif

	if (mode & CHECKSIZE) {
		/*
		 * check for existence of files and directories and
		 * for minfree kB free space
		 */
# ifdef DEBUG
		fprintf(stderr,"* %s Check spool file %s\n",now(),spoolfile);
		fflush(stderr);
# endif
		if (mode & STDIN) {
			while (!(fp = fopen(spoolfile,"a+"))) {
				fprintf(stderr,"* %s Requested action not taken: mailbox unavailable\r\n",now());
				fflush(stderr);
				sleep(5);
			}
		} else if (!(fp = fopen(spoolfile,"a+"))) {
			fprintf(stdout,"550 Requested action not taken: mailbox unavailable\r\n");
			/*
			if (mode & STDIN) {
				fprintf(stderr,"* %s Requested action not taken: mailbox unavailable\r\n",now());
				fflush(stderr);
				exit(43);
			}
			*/
			terminate(EX_CANTCREAT);
		}
		fclose(fp);
		chmod(spoolfile,S_IWUSR|S_IRUSR);
#if defined(STATFS) || defined(USTAT) /* { */
# ifdef STATFS /* { */
		if (statfs(spoolfile,&sfs)) {
			fprintf(stdout,"551 Requested action aborted: error in processing: statfs\r\n");
			if (mode & STDIN) {
				fprintf(stderr,"* %s Requested action aborted: error in processing: statfs\r\n",now());
				fflush(stderr);
				exit(EX_OSERR);
			}
			terminate(EX_OSERR);
		} else {
			sysspace = (sfs.f_bavail * sfs.f_bsize)/1024;
#  ifdef DEBUG
			fprintf(stderr,"* %s System storage: %d kB left (free=%d, avail=%d, unit=%d)\n",now(),sysspace,sfs.f_bfree,sfs.f_bavail,sfs.f_bsize);
			fflush(stderr);
#  endif
			if (sysspace < minfree) {
				fprintf(stdout,"452 Requested action not taken: insufficient system storage\r\n");
				if (mode & STDIN) {
					fprintf(stderr,"* %s Requested action not taken: insufficient system storage\r\n",now());
					fflush(stderr);
					exit(EX_NOPERM);
				}
				terminate(EX_NOPERM);
			}
		}
# else /* STATFS } { USTAT */
		if (stat(spoolfile,&st)) {
			fprintf(stdout,"551 Requested action aborted: error in processing: stat\r\n");
			if (mode & STDIN) {
				fprintf(stderr,"* %s Requested action aborted: error in processing: stat\r\n",now());
				fflush(stderr);
				exit(EX_OSERR);
			}
			terminate(EX_OSERR);
		}
		if (ustat(st.st_dev,&ust)) {
			if (mode & STDIN) {
				fprintf(stderr,"* %s Requested action aborted: error in processing: ustat\r\n",now());
				fflush(stderr);
				exit(EX_OSERR);
			}
			fprintf(stdout,"551 Requested action aborted: error in processing: ustat\r\n");
			terminate(EX_OSERR);
		} else {
			sysspace = (ust.f_tfree * BBSIZE)/1024;
#  ifdef DEBUG
			fprintf(stderr,"* %s System storage: %d kB left (free=%d, unit=%d)\n",now(),sysspace,ust.f_tfree,BBSIZE);
			fflush(stderr);
#  endif
			if (sysspace < minfree) {
				fprintf(stdout,"452 Requested action not taken: insufficient system storage\r\n");
				if (mode & STDIN) {
					fprintf(stderr,"* %s Requested action not taken: insufficient system storage\r\n",now());
					fflush(stderr);
					exit(EX_NOPERM);
				}
				terminate(EX_NOPERM);
			}
		}
# endif /* } USTAT */
#else /*  USTAT | STATFS } { */
# ifdef DEBUG
		fprintf(stderr,"* %s no system storage size information\n",now());
# endif
		sysspace = 0;
#endif /* } STATFS || USTAT */
	}
	/*
	 * Greetings...
	 */
	if (mode & NONQUIET) {
#ifdef DEBUG
		fprintf(stdout,"220-%s %s ready at %s, %d %s %d %02d:%02d:%02d GMT\r\n",
			localhost,vstring,
			daytab[tm->tm_wday],tm->tm_mday,montab[tm->tm_mon],
			tm->tm_year, tm->tm_hour,tm->tm_min,tm->tm_sec);
# ifdef RFC1652
		fprintf(stdout,"220-8-BIT SMTP Extension (RFC-1652) supported.\r\n");
# endif
# ifdef RFC1652
		fprintf(stdout,"220-Message size declaration (RFC-1653) supported.\r\n");
# endif
# ifdef RFC1652
		fprintf(stdout,"220-MIME supported.\r\n");
# endif
		fprintf(stdout,"220 In case of problems please contact fifi@rz.uni-hildesheim.de\r\n");
#else /* else outside ... */
		fprintf(stdout,"220 %s %s ready at %s, %d %s %d %02d:%02d:%02d GMT\r\n",
			localhost,vstring,
			daytab[tm->tm_wday],tm->tm_mday,montab[tm->tm_mon],
			tm->tm_year, tm->tm_hour,tm->tm_min,tm->tm_sec);
#endif
		fflush(stdout);
	}
#ifdef TIMEOUT
	if (timeout <= 0) {
		mode &= ~DOTIMEOUT;
		timeout = 0;
	}
#ifdef DEBUG
	fprintf(stderr,"* %s timeout is %d sec.\n",now(),timeout);
	fflush(stderr);
#endif
	if (mode & DOTIMEOUT) {
		alarm(timeout);
		signal(SIGALRM,dotimeout);
	}
#endif
	if (mode & STDIN) {
		/* bsmtp */
		data();
		exit(EX_OK);
	}

	if (mode & RDSTDINC) {
		if (!(ifp = depress(stdin))) {
			fprintf(stderr,"* %5d error depress\n",getpid());
			exit(EX_DATAERR);
		}
	}

	while(fgets(buffer,BUFLEN,ifp)) {
#ifdef TIMEOUT
		if (mode & DOTIMEOUT) alarm(timeout); /* reset timer */
#endif
		strip(buffer);
#ifdef DEBUG
		fprintf(stderr,"< %s \"%s\"\n",now(),buffer);
		fflush(stderr);
#endif
		for(i=0; ftab[i].cmd && strnucmp(ftab[i].cmd,buffer,strlen(ftab[i].cmd)); i++);
		if (ftab[i].cmd) {
			ftab[i].func();	
		} else {
			fprintf(stdout,"500 Command unrecognized\r\n");
			if (mode & RDSTDIN) exit(EX_USAGE);
		}
		fflush(stdout);
	}
	fclose(ifp);
#ifdef DEBUG
	fprintf(stderr,"* %s connection closed by foreign host\n",now());
	fflush(stderr);
#endif
	return(0);
}
	
