#include <signal.h>

#include "../include/strexp.h"
#include "../include/string.h"

#include "yiffconfig.h"


fname_struct fname;
option_struct option;
gen_dialog_struct dialog;
yc_win_struct yc_win;
add_mode_dialog_struct add_mode_dialog;


int main(int argc, char *argv[])
{
	gint i;


        signal(SIGINT, YCSignalHandler);
        signal(SIGTERM, YCSignalHandler);


	/* Set default configuration file. */
	strncpy(fname.rcfile, DEF_RCFILE, PATH_MAX + NAME_MAX);
	fname.rcfile[PATH_MAX + NAME_MAX - 1] = '\0';


	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    if(argv[i] == NULL)
		continue;


	    if(strcasepfx(argv[i], "--h") ||
               strcasepfx(argv[i], "-h") ||
               strcasepfx(argv[i], "-?")
            )
	    {
		printf(PROG_USAGE_MESG);
		return(0);
	    }
	    else if(strcasepfx(argv[i], "--ver") ||
                    strcasepfx(argv[i], "-ver")
            )
            {
                printf("%s Version %s\n%s\n",
		    PROG_NAME,
		    PROG_VERSION,
		    PROG_COPYRIGHT
		);
                return(0);
            }
            else if((argv[i][0] != '+') &&
                    (argv[i][0] != '-')
            )
	    {
		/* Set new rcfile name. */
                strncpy(fname.rcfile, argv[i], PATH_MAX + NAME_MAX);
                fname.rcfile[PATH_MAX + NAME_MAX - 1] = '\0';
	    }
	}



        gtk_init(&argc, &argv);

	YCCreate();
	AddModeCreate();
	GenDialogCreate(&dialog, NULL, GDIALOG_OPT_OK_BTN);

	RCLoadFromFile(fname.rcfile);

        gtk_timeout_add(
            1000,
            YCTimeoutCB,
            NULL
        );

        gtk_main();

	return(0);
}
