/********************************************************************************
*                                                                               *
*                   T o g g l e    B u t t o n    O b j e c t                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXToggleButton.cpp,v 1.3 1999/10/20 03:39:09 jeroen Exp $                *
********************************************************************************/
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXToggleButton.h"


/*
  Notes:
  - If the altlabel is empty, the normal label will be used;
    likewise for the icon.
*/

/*******************************************************************************/

// Map
FXDEFMAP(FXToggleButton) FXToggleButtonMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXToggleButton::onPaint),
  FXMAPFUNC(SEL_UPDATE,0,FXToggleButton::onUpdate),
  FXMAPFUNC(SEL_ACTIVATE,0,FXToggleButton::onActivate),
  FXMAPFUNC(SEL_DEACTIVATE,0,FXToggleButton::onDeactivate),
  FXMAPFUNC(SEL_ENTER,0,FXToggleButton::onEnter),
  FXMAPFUNC(SEL_LEAVE,0,FXToggleButton::onLeave),
  FXMAPFUNC(SEL_FOCUSIN,0,FXToggleButton::onFocusIn),
  FXMAPFUNC(SEL_FOCUSOUT,0,FXToggleButton::onFocusOut),
  FXMAPFUNC(SEL_KEYPRESS,FXWindow::ID_HOTKEY,FXToggleButton::onHotKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,FXWindow::ID_HOTKEY,FXToggleButton::onHotKeyRelease),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_TIP,FXToggleButton::onQueryTip),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_HELP,FXToggleButton::onQueryHelp),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_CHECK,FXToggleButton::onCheck),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_UNCHECK,FXToggleButton::onUncheck),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXToggleButton::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXToggleButton::onCmdSetIntValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXToggleButton::onCmdGetIntValue),
  };


// Object implementation
FXIMPLEMENT(FXToggleButton,FXLabel,FXToggleButtonMap,ARRAYNUMBER(FXToggleButtonMap))

  
// Deserialization
FXToggleButton::FXToggleButton(){
  alticon=(FXIcon*)-1;
  state=FALSE;
  oldstate=FALSE;
  }


// Construct and init
FXToggleButton::FXToggleButton(FXComposite* p,const FXString& text1,const FXString& text2,FXIcon* icon1,FXIcon* icon2,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXLabel(p,text1,icon1,opts,x,y,w,h,pl,pr,pt,pb){
  flags|=FLAG_ENABLED;
  target=tgt;
  message=sel;
  altlabel=text2.extract(0,'\t','&');
  alticon=icon2;
  tip=text1.extract(1,'\t');
  help=text1.extract(2,'\t');
  alttip=text2.extract(1,'\t');
  althelp=text2.extract(2,'\t');
  althotkey=fxparsehotkey(text2.text());
  althotoff=fxfindhotkeyoffset(text2.text());
  addHotKey(althotkey);
  oldstate=FALSE;
  state=FALSE;
  }


// Create window
void FXToggleButton::create(){
  FXLabel::create();
  if(alticon) alticon->create();
  }
 

// Detach window
void FXToggleButton::detach(){
  FXLabel::detach();
  if(alticon) alticon->detach();
  }
 

// Enable the window
void FXToggleButton::enable(){
  if(!(flags&FLAG_ENABLED)){
    FXWindow::enable();
    update();
    }
  }


// Disable the window
void FXToggleButton::disable(){
  if(flags&FLAG_ENABLED){
    FXWindow::disable();
    update();
    }
  }


// Get default width
FXint FXToggleButton::getDefaultWidth(){
  FXint tw=0,iw=0,s=0,w1,w2;
  if(!label.empty()) tw=labelWidth(label);
  if(icon) iw=icon->getWidth(); 
  if(iw && tw) s=4;
  if(!(options&(ICON_AFTER_TEXT|ICON_BEFORE_TEXT))) w1=FXMAX(tw,iw); else w1=tw+iw+s;
  if(!altlabel.empty()) tw=labelWidth(altlabel); else if(!label.empty()) tw=labelWidth(label);
  if(alticon) iw=alticon->getWidth(); else if(icon) iw=icon->getWidth(); 
  if(iw && tw) s=4;
  if(!(options&(ICON_AFTER_TEXT|ICON_BEFORE_TEXT))) w2=FXMAX(tw,iw); else w2=tw+iw+s;
  return FXMAX(w1,w2)+padleft+padright+(border<<1);
  }


// Get default height
FXint FXToggleButton::getDefaultHeight(){
  FXint th=0,ih=0,h1,h2;
  if(!label.empty()) th=labelHeight(label);
  if(icon) ih=icon->getHeight(); 
  if(!(options&(ICON_ABOVE_TEXT|ICON_BELOW_TEXT))) h1=FXMAX(th,ih); else h1=th+ih;
  if(!altlabel.empty()) th=labelHeight(altlabel); else if(!label.empty()) th=labelHeight(label);
  if(alticon) ih=alticon->getHeight(); else if(icon) ih=icon->getHeight(); 
  if(!(options&(ICON_ABOVE_TEXT|ICON_BELOW_TEXT))) h2=FXMAX(th,ih); else h2=th+ih;
  return FXMAX(h1,h2)+padtop+padbottom+(border<<1);
  }


// Set button state
void FXToggleButton::setState(FXuint s){
  if(state!=s){
    state=s;
    update();
    }
  }


// If window can have focus
FXbool FXToggleButton::canFocus() const { return 1; }


// Update value from a message
long FXToggleButton::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  setState((FXint)(long)ptr);
  return 1;
  }


// Update value from a message
long FXToggleButton::onCmdSetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetIntValue: NULL pointer.\n",getClassName()); }
  setState(*((FXint*)ptr));
  return 1;
  }


// Obtain value from text field
long FXToggleButton::onCmdGetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetIntValue: NULL pointer.\n",getClassName()); }
  *((FXint*)ptr)=getState();
  return 1;
  }


// Check the menu button
long FXToggleButton::onCheck(FXObject*,FXSelector,void*){ 
  setState(TRUE); 
  return 1; 
  }


// Check the menu button
long FXToggleButton::onUncheck(FXObject*,FXSelector,void*){ 
  setState(FALSE); 
  return 1; 
  }


// Gained focus
long FXToggleButton::onFocusIn(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onFocusIn(sender,sel,ptr);
  update(border,border,width-(border<<1),height-(border<<1));
  return 1;
  }

  
// Lost focus
long FXToggleButton::onFocusOut(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onFocusOut(sender,sel,ptr);
  update(border,border,width-(border<<1),height-(border<<1));
  return 1;
  }


// Hot key combination pressed
long FXToggleButton::onHotKeyPress(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyPress %08x\n",getClassName(),this));
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    handle(this,MKUINT(0,SEL_ACTIVATE),ptr);
    }
  return 1;
  }


// Hot key combination released
long FXToggleButton::onHotKeyRelease(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyRelease %08x\n",getClassName(),this));
  flags&=~FLAG_TIP;
  if(isEnabled()){ 
    handle(this,MKUINT(0,SEL_DEACTIVATE),ptr); 
    }
  return 1;
  }


// Implement auto-hide or auto-gray modes
long FXToggleButton::onUpdate(FXObject* sender,FXSelector sel,void* ptr){
  if(!FXLabel::onUpdate(sender,sel,ptr)){
    if(options&TOGGLEBUTTON_AUTOHIDE){if(shown()){hide();recalc();}}
    if(options&TOGGLEBUTTON_AUTOGRAY){disable();}
    }
  return 1;
  }


// Button being activated
long FXToggleButton::onActivate(FXObject*,FXSelector,void*){
  flags|=FLAG_PRESSED;
  flags&=~FLAG_UPDATE;
  oldstate=state;
  setState(!oldstate);
  return 0;
  }
  

// Button being deactivated
long FXToggleButton::onDeactivate(FXObject*,FXSelector,void*){
  flags&=~FLAG_PRESSED;
  flags|=FLAG_UPDATE;
  update();
  if(state!=oldstate){
    if(target && target->handle(this,MKUINT(message,SEL_COMMAND),(void*)state)) return 1;
    }
  return 1;
  }


// We were asked about status text
long FXToggleButton::onQueryHelp(FXObject* sender,FXSelector,void*){
  if(flags&FLAG_HELP){
    if(state){
      if(!althelp.empty()){
        sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&althelp);
        return 1;
        }
      }
    if(!help.empty()){
      sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&help);
      return 1;
      }
    }
  return 0;
  }


// We were asked about tip text
long FXToggleButton::onQueryTip(FXObject* sender,FXSelector,void*){
  if(flags&FLAG_TIP){
    if(state){
      if(!alttip.empty()){
        sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&alttip);
        return 1;
        }
      }
    if(!tip.empty()){
      sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&tip);
      return 1;
      }
    }
  return 0;
  }


// Entered button
long FXToggleButton::onEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onEnter(sender,sel,ptr);
  if(isEnabled()){
    if(flags&FLAG_PRESSED) setState(!oldstate);
    if(options&TOGGLEBUTTON_TOOLBAR) update();
    }
  return 1;
  }


// Left button
long FXToggleButton::onLeave(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onLeave(sender,sel,ptr);
  if(isEnabled()){
    if(flags&FLAG_PRESSED) setState(oldstate);
    if(options&TOGGLEBUTTON_TOOLBAR) update();
    }
  return 1;
  }


// Handle repaint 
long FXToggleButton::onPaint(FXObject*,FXSelector,void* ptr){
  FXint tw=0,th=0,iw=0,ih=0,tx,ty,ix,iy;
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  
  // Got a border at all?
  if(options&(FRAME_RAISED|FRAME_SUNKEN)){

    // Toolbar style
    if(options&TOGGLEBUTTON_TOOLBAR){
      
      // Enabled and cursor inside, and up
      if(isEnabled() && underCursor() && !(flags&FLAG_PRESSED)){
        dc.setForeground(backColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleRaisedRectangle(dc,0,0,width,height);
        else drawRaisedRectangle(dc,0,0,width,height);
        }
      
      // Enabled and cursor inside and down
      else if(isEnabled() && underCursor() && (flags&FLAG_PRESSED)){
        dc.setForeground(hiliteColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width,height);
        else drawSunkenRectangle(dc,0,0,width,height);
        }
      
      // Disabled or unchecked or not under cursor
      else{
        dc.setForeground(backColor);
        dc.fillRectangle(0,0,width,height);
        }
      }
 
    // Normal style
    else{
      
      // Draw sunken if pressed
      if(underCursor() && (flags&FLAG_PRESSED)){
        dc.setForeground(hiliteColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width,height);
        else drawSunkenRectangle(dc,0,0,width,height);
        }

      // Draw raised if not currently pressed down
      else{
        dc.setForeground(backColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleRaisedRectangle(dc,0,0,width,height);
        else drawRaisedRectangle(dc,0,0,width,height);
        }
 
      }
    }

  // No borders
  else{
    dc.setForeground(backColor);
    dc.fillRectangle(0,0,width,height);
    }

  // Place text & icon
  if(state && !altlabel.empty()){
    tw=labelWidth(altlabel);
    th=labelHeight(altlabel);
    }
  else if(!label.empty()){
    tw=labelWidth(label);
    th=labelHeight(label);
    }
  if(state && alticon){
    iw=alticon->getWidth();
    ih=alticon->getHeight();
    }
  else if(icon){
    iw=icon->getWidth();
    ih=icon->getHeight();
    }
  
  just_x(tx,ix,tw,iw);
  just_y(ty,iy,th,ih);
  
  // Shift a bit when pressed
  if(underCursor() && (flags&FLAG_PRESSED) && (options&(FRAME_RAISED|FRAME_SUNKEN))){ ++tx; ++ty; ++ix; ++iy; }

  // Draw enabled state
  if(isEnabled()){
    if(state && alticon) 
      dc.drawIcon(alticon,ix,iy);
    else if(icon) 
      dc.drawIcon(icon,ix,iy);
    if(state && !altlabel.empty()){
      dc.setTextFont(font);
      dc.setForeground(textColor);
      drawLabel(dc,altlabel,althotoff,tx,ty,tw,th);
      if(hasFocus()){
        drawFocusRectangle(dc,border+2,border+2,width-2*border-4,height-2*border-4);
        }
      }
    else if(!label.empty()){
      dc.setTextFont(font);
      dc.setForeground(textColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      if(hasFocus()){
        drawFocusRectangle(dc,border+2,border+2,width-2*border-4,height-2*border-4);
        }
      }
    }
  
  // Draw grayed-out state
  else{
    if(state && alticon) 
      dc.drawIconShaded(alticon,ix,iy);
    else if(icon) 
      dc.drawIconShaded(icon,ix,iy);
    if(state && !altlabel.empty()){
      dc.setTextFont(font);
      dc.setForeground(hiliteColor);
      drawLabel(dc,altlabel,althotoff,tx+1,ty+1,tw,th);
      dc.setForeground(shadowColor);
      drawLabel(dc,altlabel,althotoff,tx,ty,tw,th);
      }
    else if(!label.empty()){
      dc.setTextFont(font);
      dc.setForeground(hiliteColor);
      drawLabel(dc,label,hotoff,tx+1,ty+1,tw,th);
      dc.setForeground(shadowColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      }
    }
  return 1;
  }


// Change text
void FXToggleButton::setAltText(const FXString& text){
  if(altlabel!=text){
    altlabel=text;
    hotoff=-1;
    recalc();
    update();
    }
  }


// Change icon
void FXToggleButton::setAltIcon(FXIcon* ic){
  if(alticon!=ic){
    alticon=ic;
    recalc();
    update();
    }
  }


// Change help text
void FXToggleButton::setHelpText(const FXString& text){
  help=text;
  }


// Change help text
void FXToggleButton::setAltHelpText(const FXString& text){
  althelp=text;
  }


// Change tip text
void FXToggleButton::setTipText(const FXString& text){
  tip=text;
  }


// Change tip text
void FXToggleButton::setAltTipText(const FXString& text){
  alttip=text;
  }


// Save object to stream
void FXToggleButton::save(FXStream& store) const {
  FXLabel::save(store);
  store << altlabel;
  store << alticon;
  store << althotkey;
  store << althotoff;
  store << tip;
  store << help;
  store << alttip;
  store << althelp;
  }

      

// Load object from stream
void FXToggleButton::load(FXStream& store){
  FXLabel::load(store);
  store >> altlabel;
  store >> alticon;
  store >> althotkey;
  store >> althotoff;
  store >> tip;
  store >> help;
  store >> alttip;
  store >> althelp;
  }  


// Destruct
FXToggleButton::~FXToggleButton(){
  remHotKey(althotkey);
  alticon=(FXIcon*)-1;
  }
