/********************************************************************************
*                                                                               *
*                     D i a l o g   B o x    O b j e c t                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDialogBox.cpp,v 1.5 1999/11/12 07:59:17 jeroen Exp $                   *
********************************************************************************/
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXCursor.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXRootWindow.h"
#include "FXShell.h"
#include "FXTopWindow.h"
#include "FXDialogBox.h"

/*

  To do:
  - Iconified/normal
  - Unmap when main window unmapped
  - Transient For stuff
  - Place so that cursor over dialog
  - Hitting ESC will cancel out of the dialog
  - Hitting RETURN will localize the default button, and then send it a RETURN;
    Note that the default button is initially assigned, but whichever button
    has the focus will be the default button; default-ness moves between buttons.
*/

/*******************************************************************************/


// Map
FXDEFMAP(FXDialogBox) FXDialogBoxMap[]={
  FXMAPFUNC(SEL_KEYPRESS,0,FXDialogBox::onKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,0,FXDialogBox::onKeyRelease),
  FXMAPFUNC(SEL_CLOSE,0,FXDialogBox::onClose),
  FXMAPFUNC(SEL_COMMAND,FXDialogBox::ID_CANCEL,FXDialogBox::onCmdCancel),
  FXMAPFUNC(SEL_COMMAND,FXDialogBox::ID_ACCEPT,FXDialogBox::onCmdAccept),
  };


// Object implementation
FXIMPLEMENT(FXDialogBox,FXTopWindow,FXDialogBoxMap,ARRAYNUMBER(FXDialogBoxMap))


// Contruct free floating dialog
FXDialogBox::FXDialogBox(FXApp* a,const FXString& name,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint hs,FXint vs):
  FXTopWindow(a,name,NULL,NULL,opts,x,y,w,h,hs,vs){
  }


// Contruct dialog which will stay on top of owner
FXDialogBox::FXDialogBox(FXWindow* owner,const FXString& name,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint hs,FXint vs):
  FXTopWindow(owner,name,NULL,NULL,opts,x,y,w,h,hs,vs){
  }


// Close window & cancel out of dialog
long FXDialogBox::onClose(FXObject*,FXSelector,void*){
  if(target && target->handle(this,MKUINT(message,SEL_CLOSE),NULL)) return 1;
  handle(this,MKUINT(FXDialogBox::ID_CANCEL,SEL_COMMAND),NULL);
  return 1;
  }


// Close dialog with an accept
long FXDialogBox::onCmdAccept(FXObject*,FXSelector,void*){
  getApp()->stopModal(this,TRUE);
  hide();
  return 1;
  }


// Close dialog with a cancel
long FXDialogBox::onCmdCancel(FXObject*,FXSelector,void*){
  getApp()->stopModal(this,FALSE);
  hide();
  return 1;
  }



// Show window such that the cursor is in it
void FXDialogBox::show(){
  FXint rw,rh,wx,wy,ww,wh,x,y; 
  FXuint state;
  if(!shown()){
    
    // Get old dialog location
    translateCoordinatesTo(wx,wy,getRoot(),0,0);
    
    // Size
    ww=getWidth();
    wh=getHeight();

    // Fix width and height for convenience
    if(ww<8) ww=getDefaultWidth();
    if(wh<8) wh=getDefaultHeight();

    // Where's the mouse?
    getRoot()->getCursorPosition(x,y,state);

    // Place such that mouse in the middle
    if(x<wx || y<wy || wx+ww<=x || wy+wh<=y){

      // Get root window size
      rw=getRoot()->getWidth();
      rh=getRoot()->getHeight();

      // Move by the minimal amount
      if(x<wx) wx=x-20; else if(wx+ww<=x) wx=x-ww+20;
      if(y<wy) wy=y-20; else if(wy+wh<=y) wy=y-wh+20;

      // Adjust so dialog is fully visible
      if(wx<0) wx=10;
      if(wy<0) wy=10;
      if(wx+ww>rw) wx=rw-ww-10;
      if(wy+wh>rh) wy=rh-wh-10;

      position(wx,wy,ww,wh);
      }

    // Pop the window
    FXTopWindow::show();
    }
  }


// Keyboard press; handle escape to close the dialog
long FXDialogBox::onKeyPress(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(FXTopWindow::onKeyPress(sender,sel,ptr)) return 1;
  if(event->code==KEY_Escape){
    handle(this,MKUINT(ID_CANCEL,SEL_COMMAND),NULL);
    return 1;
    }
  return 0;
  }


// Keyboard release; handle escape to close the dialog
long FXDialogBox::onKeyRelease(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(FXTopWindow::onKeyRelease(sender,sel,ptr)) return 1;
  if(event->code==KEY_Escape){
    return 1;
    }
  return 0;
  }



// Execute dialog box modally
FXuint FXDialogBox::execute(){
  create();
  show();
  return getApp()->runModalFor(this);
  }
