/********************************************************************************
*                                                                               *
*                           B u t t o n    O b j e c t s                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXButton.cpp,v 1.3 1999/10/20 03:39:09 jeroen Exp $                      *
********************************************************************************/
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXObjectList.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXButton.h"


/*
  To do:
  - Use flags for button instead of a whole integer
  - Add ``flat'' toolbar style also
  - Need check-style also (stay in when pressed, pop out when unpressed).
  - Who owns the icon(s)?
  - Arrow buttons should auto-repeat with a timer of some kind
  - "&Label\tTooltip\tHelptext\thttp://server/application/helponitem.html"
  - CheckButton should send SEL_COMMAND.
  - Default button mode:- should somehow get focus.
  - Add button multiple-click translations elsewhere
  - Button should be able to behave like a check (radio) button.
  - Need to draw ``around'' the icon etc. So it doesn't flash to background.
*/

// Spec
// Button styles
#define BUTTON_MASK        (BUTTON_AUTOGRAY|BUTTON_AUTOHIDE|BUTTON_TOOLBAR)

/*******************************************************************************/

// Map
FXDEFMAP(FXButton) FXButtonMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXButton::onPaint),
  FXMAPFUNC(SEL_UPDATE,0,FXButton::onUpdate),
  FXMAPFUNC(SEL_ACTIVATE,0,FXButton::onActivate),
  FXMAPFUNC(SEL_DEACTIVATE,0,FXButton::onDeactivate),
  FXMAPFUNC(SEL_ENTER,0,FXButton::onEnter),
  FXMAPFUNC(SEL_LEAVE,0,FXButton::onLeave),
  FXMAPFUNC(SEL_FOCUSIN,0,FXButton::onFocusIn),
  FXMAPFUNC(SEL_FOCUSOUT,0,FXButton::onFocusOut),
  FXMAPFUNC(SEL_KEYPRESS,FXWindow::ID_HOTKEY,FXButton::onHotKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,FXWindow::ID_HOTKEY,FXButton::onHotKeyRelease),
  FXMAPFUNC(SEL_UNGRABBED,0,FXButton::onUngrabbed),
  FXMAPFUNC(SEL_CLICKED,0,FXButton::onClicked),
  FXMAPFUNC(SEL_DOUBLECLICKED,0,FXButton::onDoubleClicked),
  FXMAPFUNC(SEL_TRIPLECLICKED,0,FXButton::onTripleClicked),
  FXMAPFUNC(SEL_COMMAND,0,FXButton::onCommand),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_TIP,FXButton::onQueryTip),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_HELP,FXButton::onQueryHelp),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_CHECK,FXButton::onCheck),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_UNCHECK,FXButton::onUncheck),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXButton::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXButton::onCmdSetIntValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXButton::onCmdGetIntValue),
  };


// Object implementation
FXIMPLEMENT(FXButton,FXLabel,FXButtonMap,ARRAYNUMBER(FXButtonMap))

  
// Deserialization
FXButton::FXButton(){
  flags|=FLAG_ENABLED;
  state=STATE_UP;
  }


// Construct and init
FXButton::FXButton(FXComposite* p,const FXString& text,FXIcon* ic,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXLabel(p,text,ic,opts,x,y,w,h,pl,pr,pt,pb){
  flags|=FLAG_ENABLED;
  tip=text.extract(1,'\t');
  help=text.extract(2,'\t');
  target=tgt;
  message=sel;
  state=STATE_UP;
  if(options&BUTTON_DEFAULT) addHotKey(MKUINT(KEY_Return,0));
  }


// Enable the window
void FXButton::enable(){
  if(!(flags&FLAG_ENABLED)){
    FXWindow::enable();
    update();
    }
  }


// Disable the window
void FXButton::disable(){
  if(flags&FLAG_ENABLED){
    FXWindow::disable();
    update();
    }
  }


// Set button state
void FXButton::setState(FXuint s){
  if(state!=s){
    state=s;
    update();
    }
  }


// If window can have focus
FXbool FXButton::canFocus() const { return 1; }


// Update value from a message
long FXButton::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  setState((FXint)(long)ptr);
  return 1;
  }


// Update value from a message
long FXButton::onCmdSetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetIntValue: NULL pointer.\n",getClassName()); }
  setState(*((FXint*)ptr));
  return 1;
  }


// Obtain value from text field
long FXButton::onCmdGetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetIntValue: NULL pointer.\n",getClassName()); }
  *((FXint*)ptr)=getState();
  return 1;
  }


// Check the menu button
long FXButton::onCheck(FXObject*,FXSelector,void*){ 
  setState(STATE_ENGAGED); 
  return 1; 
  }


// Check the menu button
long FXButton::onUncheck(FXObject*,FXSelector,void*){ 
  setState(STATE_UP); 
  return 1; 
  }


// Implement auto-hide or auto-gray modes
long FXButton::onUpdate(FXObject* sender,FXSelector sel,void* ptr){
  if(!FXLabel::onUpdate(sender,sel,ptr)){
    if(options&BUTTON_AUTOHIDE){if(shown()){hide();recalc();}}
    if(options&BUTTON_AUTOGRAY){disable();}
    }
  return 1;
  }


// Gained focus
long FXButton::onFocusIn(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onFocusIn(sender,sel,ptr);
  update(border,border,width-(border<<1),height-(border<<1));
  return 1;
  }

  
// Lost focus
long FXButton::onFocusOut(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onFocusOut(sender,sel,ptr);
  update(border,border,width-(border<<1),height-(border<<1));
  return 1;
  }


// Hot key combination pressed
long FXButton::onHotKeyPress(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyPress %08x\n",getClassName(),this));
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    handle(this,MKUINT(0,SEL_ACTIVATE),ptr);
    }
  return 1;
  }


// Hot key combination released
long FXButton::onHotKeyRelease(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyRelease %08x\n",getClassName(),this));
  flags&=~FLAG_TIP;
  if(isEnabled()){ 
    handle(this,MKUINT(0,SEL_DEACTIVATE),ptr); 
    }
  return 1;
  }

 
// The widget lost the grab for some reason
long FXButton::onUngrabbed(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onUngrabbed(sender,sel,ptr);
  flags&=~FLAG_PRESSED;
  flags|=FLAG_UPDATE;
  if(state!=STATE_ENGAGED) setState(STATE_UP);
  return 1;
  }


// Button being activated
long FXButton::onActivate(FXObject*,FXSelector,void*){
  flags|=FLAG_PRESSED;
  flags&=~FLAG_UPDATE;
  if(state!=STATE_ENGAGED) setState(STATE_DOWN);
  return 1;
  }
  

// Button being deactivated
long FXButton::onDeactivate(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  FXuint click=(state==STATE_DOWN);
  flags&=~FLAG_PRESSED;
  flags|=FLAG_UPDATE;
  if(state!=STATE_ENGAGED) setState(STATE_UP);
  if(event->click_count==1) handle(this,MKUINT(0,SEL_CLICKED),(void*)click);
  else if(event->click_count==2) handle(this,MKUINT(0,SEL_DOUBLECLICKED),(void*)click);
  else if(event->click_count==3) handle(this,MKUINT(0,SEL_TRIPLECLICKED),(void*)click);
  if(click) handle(this,MKUINT(0,SEL_COMMAND),(void*)click);
  return 1;
  }


// Clicked on button
long FXButton::onClicked(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_CLICKED),ptr);
  }
  

// Double clicked on button
long FXButton::onDoubleClicked(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_DOUBLECLICKED),ptr);
  }
  
  
// Triple clicked
long FXButton::onTripleClicked(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_TRIPLECLICKED),ptr);
  }


// Command message
long FXButton::onCommand(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_COMMAND),ptr);
  }


// We were asked about status text
long FXButton::onQueryHelp(FXObject* sender,FXSelector,void*){
  if(!help.empty() && (flags&FLAG_HELP)){
    sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&help);
    return 1;
    }
  return 0;
  }


// We were asked about tip text
long FXButton::onQueryTip(FXObject* sender,FXSelector,void*){
  if(!tip.empty() && (flags&FLAG_TIP)){
    sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&tip);
    return 1;
    }
  return 0;
  }


// Entered button
long FXButton::onEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onEnter(sender,sel,ptr);
  if(isEnabled()){
    if((flags&FLAG_PRESSED) && (state!=STATE_ENGAGED)) setState(STATE_DOWN);
    if(options&BUTTON_TOOLBAR) update();
    }
  return 1;
  }


// Left button
long FXButton::onLeave(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onLeave(sender,sel,ptr);
  if(isEnabled()){
    if((flags&FLAG_PRESSED) && (state!=STATE_ENGAGED)) setState(STATE_UP);
    if(options&BUTTON_TOOLBAR) update();
    }
  return 1;
  }


// Handle repaint 
long FXButton::onPaint(FXObject*,FXSelector,void* ptr){
  FXint tw=0,th=0,iw=0,ih=0,tx,ty,ix,iy;
  FXEvent *ev=(FXEvent*)ptr;
  
  // Start drawing
  FXDCWindow dc(this,ev);
  
  // Got a border at all?
  if(options&(FRAME_RAISED|FRAME_SUNKEN)){

    // Toolbar style
    if(options&BUTTON_TOOLBAR){
      
      // Enabled and cursor inside, and up
      if(isEnabled() && underCursor() && (state==STATE_UP)){
        dc.setForeground(backColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleRaisedRectangle(dc,0,0,width,height);
        else drawRaisedRectangle(dc,0,0,width,height);
        }
      
      // Enabled and cursor inside and down
      else if(isEnabled() && underCursor() && (state==STATE_DOWN)){
        dc.setForeground(backColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width,height);
        else drawSunkenRectangle(dc,0,0,width,height);
        }
      
      // Enabled and checked
      else if(isEnabled() && (state==STATE_ENGAGED)){
        dc.setForeground(hiliteColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width,height);
        else drawSunkenRectangle(dc,0,0,width,height);
        }
        
      // Disabled or unchecked or not under cursor
      else{
        dc.setForeground(backColor);
        dc.fillRectangle(0,0,width,height);
        }
      }
 
    // Normal style
    else{
      
      // Default
      if(isDefault()){
        
        // Draw in up state if disabled or up
        if(!isEnabled() || (state==STATE_UP)){
          dc.setForeground(backColor);
          dc.fillRectangle(border+1,border+1,width-border*2-1,height-border*2-1);
          if(options&FRAME_THICK) drawDoubleRaisedRectangle(dc,1,1,width-1,height-1);
          else drawRaisedRectangle(dc,1,1,width-1,height-1);
          }
        
        // Draw sunken if enabled and either checked or pressed
        else{
          if(state==STATE_ENGAGED) dc.setForeground(hiliteColor); else dc.setForeground(backColor);
          dc.fillRectangle(border,border,width-border*2-1,height-border*2-1);
          if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width-1,height-1);
          else drawSunkenRectangle(dc,0,0,width-1,height-1);
          }
        
        // Black default border
        drawBorderRectangle(dc,0,0,width,height);
        }
      
      // Non-Default
      else{
        
        // Draw in up state if disabled or up
        if(!isEnabled() || (state==STATE_UP)){
          dc.setForeground(backColor);
          dc.fillRectangle(border,border,width-border*2,height-border*2);
          if(options&FRAME_THICK) drawDoubleRaisedRectangle(dc,0,0,width,height);
          else drawRaisedRectangle(dc,0,0,width,height);
          }
        
        // Draw sunken if enabled and either checked or pressed
        else{
          if(state==STATE_ENGAGED) dc.setForeground(hiliteColor); else dc.setForeground(backColor);
          dc.fillRectangle(border,border,width-border*2,height-border*2);
          if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width,height);
          else drawSunkenRectangle(dc,0,0,width,height);
          }
        }
      }
    }
  
  // No borders
  else{
    if(isEnabled() && (state==STATE_ENGAGED)){
      dc.setForeground(hiliteColor);
      dc.fillRectangle(0,0,width,height);
      }
    else{
      dc.setForeground(backColor);
      dc.fillRectangle(0,0,width,height);
      }
    }
  
  // Place text & icon
  if(!label.empty()){
    tw=labelWidth(label);
    th=labelHeight(label);
    }
  if(icon){
    iw=icon->getWidth();
    ih=icon->getHeight();
    }
  just_x(tx,ix,tw,iw);
  just_y(ty,iy,th,ih);
  
  // Shift a bit when pressed
  if(state && (options&(FRAME_RAISED|FRAME_SUNKEN))){ ++tx; ++ty; ++ix; ++iy; }

  // Draw the icon
  if(icon){
    if(isEnabled())
      dc.drawIcon(icon,ix,iy);
    else
      dc.drawIconShaded(icon,ix,iy);
    }
  
  // Draw the text
  if(!label.empty()){
    dc.setTextFont(font);
    if(isEnabled()){
      dc.setForeground(textColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      if(hasFocus()){
        drawFocusRectangle(dc,border+2,border+2,width-2*border-4,height-2*border-4);
        }
      }
    else{
      dc.setForeground(hiliteColor);
      drawLabel(dc,label,hotoff,tx+1,ty+1,tw,th);
      dc.setForeground(shadowColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      }
    }
  return 1;
  }


// Change help text
void FXButton::setHelpText(const FXString& text){
  help=text;
  }


// Change tip text
void FXButton::setTipText(const FXString& text){
  tip=text;
  }


// Set icon positioning
void FXButton::setButtonStyle(FXuint style){
  FXuint opts=(options&~BUTTON_MASK) | (style&BUTTON_MASK);
  if(options!=opts){
    options=opts;
    update();
    }
  }


// Get icon positioning
FXuint FXButton::getButtonStyle() const { 
  return (options&BUTTON_MASK); 
  }


// Test if default
FXbool FXButton::isDefault() const {
  return (options&BUTTON_DEFAULT)!=0;
  }


// Set as default widget
void FXButton::setDefault(FXbool def){
  if((options&BUTTON_DEFAULT) && !def){
    options&=~BUTTON_DEFAULT;
    remHotKey(MKUINT(KEY_Return,0));
    update();
    }
  else if(!(options&BUTTON_DEFAULT) && def){
    options|=BUTTON_DEFAULT;
    addHotKey(MKUINT(KEY_Return,0));
    update();
    }
  }



// Save object to stream
void FXButton::save(FXStream& store) const {
  FXLabel::save(store);
  store << tip;
  store << help;
  }

      

// Load object from stream
void FXButton::load(FXStream& store){
  FXLabel::load(store);
  store >> tip;
  store >> help;
  }  


// Destroy
FXButton::~FXButton(){
  if(options&BUTTON_DEFAULT) remHotKey(MKUINT(KEY_Return,0));
  }
