/********************************************************************************
*                                                                               *
*                  S w i t c h   C o n t a i n e r   W i d g e t                *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXSwitcher.h,v 1.4 1999/11/09 23:58:37 jeroen Exp $                      *
********************************************************************************/
#ifndef FXSWITCHER_H
#define FXSWITCHER_H



// Switcher widget
class FXAPI FXSwitcher : public FXPacker {
  FXDECLARE(FXSwitcher)
protected:
  FXint  current;  
protected:
  FXSwitcher(){}
  virtual void layout();
private:
  FXSwitcher(const FXSwitcher&);
  FXSwitcher& operator=(const FXSwitcher&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
  long onCmdOpen(FXObject*,FXSelector,void*);
  long onUpdOpen(FXObject*,FXSelector,void*);
public:
  enum {
    ID_OPEN_FIRST=FXPacker::ID_LAST,
    ID_OPEN_LAST=ID_OPEN_FIRST+1000,
    ID_LAST
    };
public:
  FXSwitcher(FXComposite *p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_SPACING,FXint pr=DEFAULT_SPACING,FXint pt=DEFAULT_SPACING,FXint pb=DEFAULT_SPACING);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  void setCurrent(FXint panel);
  FXint getCurrent() const { return current; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  };

#endif
