/********************************************************************************
*                                                                               *
*             O p e n G L   T r i a n g l e   M e s h   O b j e c t             *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLTriangleMesh.h,v 1.3 1999/09/29 22:56:57 jeroen Exp $                *
********************************************************************************/
#ifndef FXGLTRIANGLEMESH_H
#define FXGLTRIANGLEMESH_H
    

/*
 * Arrays Formats
 *
 * vertex: x,y,z
 * normal: x,y,z
 * Color: r,g.b,a
 * texture: u,v
 */

class FXAPI FXGLTriangleMesh : public FXGLShape {
  FXDECLARE(FXGLTriangleMesh)
private:
  FXfloat   *vertexBuffer;
  FXfloat   *colorBuffer;
  FXfloat   *normalBuffer;
  FXfloat   *textureBuffer;
  FXint      vertexNumber;
protected:
  FXGLTriangleMesh();
  virtual void drawshape(FXGLViewer* viewer);
  virtual void recomputerange();
  virtual void generatenormals();
public:
  FXGLTriangleMesh(FXfloat x,FXfloat y,FXfloat z,FXint nv,FXfloat *v,FXfloat *n=NULL,FXfloat *c=NULL,FXfloat *t=NULL);
  FXGLTriangleMesh(FXfloat x,FXfloat y,FXfloat z,FXint nv,FXfloat *v,FXfloat *n,FXfloat *c,FXfloat *t,const FXMaterial& mtl);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  void setVertexNumber(FXint nvertices){ vertexNumber=nvertices; }
  FXint getVertexNumber() const { return vertexNumber; }
  void setVertexBuffer(FXfloat *vertices);
  void setColorBuffer(FXfloat *colors){ colorBuffer=colors; }
  void setNormalBuffer(FXfloat *normals){ normalBuffer=normals; }
  void setTextureCoordBuffer(FXfloat *textures){ textureBuffer=textures; }
  FXfloat* getVertexBuffer() const { return vertexBuffer; }
  FXfloat* getColorBuffer() const { return colorBuffer; }
  FXfloat* getNormalBuffer() const { return normalBuffer; }
  FXfloat* getTextureCoordBuffer() const { return textureBuffer; }
  virtual ~FXGLTriangleMesh();
  };


#endif
