#
# $Header: /usr/local/cvsroot/pythondoc/formatters/format_init.py,v 1.2 1999/05/01 01:17:00 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.

"""Format manual pages.

A manual page formatter translates a ManualPage into a concrete document
format, such as HTML, MIF, UNIX man or some other format.
"""

__author__ = "Daniel Larsson"
__version__ = "$Revision: 1.2 $"[11:-2]

import os

# Will contain all available formatters
formatters = {}

def init(path, options):
    import pythondoc.message
    message = pythondoc.message
    files = reduce(lambda c, dir: c+os.listdir(dir), path, [])
    modules = filter(lambda file: file[-12:] == 'Formatter.py', files)
    for module in modules:
	py_module = module[:-3]
	try:
	    exec "import %s" % py_module
	except ImportError:
	    import sys
	    message.warning('Failed to import %s (%s: %s)\n' %
			    (py_module, sys.exc_type, sys.exc_value))
	except NameError:
	    import sys
	    message.warning('Failed to import %s (%s: %s)\n' %
			    (py_module, sys.exc_type, sys.exc_value))

	except:
	    import sys
	    raise sys.exc_type, sys.exc_value, sys.exc_traceback

	try:
	    exec "%s.init(options)" % py_module
	except AttributeError, sym:
	    import sys
	    if sym == "init":
		message.warning('Failed to call %s.init function' %
				py_module)
	    else:
		raise AttributeError, sym, sys.exc_traceback
	except NameError:
	    import sys
	    message.warning('Failed to initialize %s (%s: %s)\n' %
			    (py_module, sys.exc_type, sys.exc_value))
	except:
	    import sys
	    raise sys.exc_type, sys.exc_value, sys.exc_traceback
		    

def add_formatter(name, formatter):
    if formatters.has_key(name):
	from pythondoc import message
	message.warning('There is already a formatter named %s (module %s)' \
			% (name, formatters[name].__module__))
	message.warning("Couldn't register formatter %s (module %s)" \
			% (formatter.__name__, formatter.__module__))
	return

    formatters[name] = formatter

#
# $Log: format_init.py,v $
# Revision 1.2  1999/05/01 01:17:00  daniel
# *** empty log message ***
#
# 
# *****************  Version 3  *****************
# User: Daniel       Date: 98-10-04   Time: 20:45
# Updated in $/Pythondoc/formatters
# Fixed erroneous import.
# 
# *****************  Version 2  *****************
# User: Daniel       Date: 98-08-06   Time: 16:58
# Updated in $/Pythondoc/formatters
# Added header and footer.
# Removed debug printing.
# 
