/***********************************************************
Copyright 1991-1995 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI or Corporation for National Research Initiatives or
CNRI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

While CWI is the initial source for this software, a modified version
is made available by the Corporation for National Research Initiatives
(CNRI) at the Internet address ftp://ftp.python.org.

STICHTING MATHEMATISCH CENTRUM AND CNRI DISCLAIM ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH
CENTRUM OR CNRI BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* This header file includes some new APIs that are not available in
   older API versions, yet are used by the mx-Extensions. Since there
   is no supporting documentation other than this file itself, no
   copyright notice appears in packages using this header file. Hope
   that's ok... */

/* Emulate PY_VERSION_HEX for older Python versions. */

#ifndef PY_VERSION_HEX
# if PYTHON_API_VERSION == 1007
#  define PY_VERSION_HEX 0x010500F0
# endif
# if PYTHON_API_VERSION == 1006
#  define PY_VERSION_HEX 0x010400F0
# endif
# if PYTHON_API_VERSION < 1006
#  define PY_VERSION_HEX 0
# endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
  ----------------------------------------------------------------
  Python 1.5.2b2:
  ----------------------------------------------------------------
*/

#if PY_VERSION_HEX == 0x010502B2

#if 0

/* Returns 1 if the given object supports the reading buffer
   interface. */

static
int PyBuffer_ReadableCheck(PyObject *obj)
{
    PyBufferProcs *pb = obj->ob_type->tp_as_buffer;

    if ( pb == NULL ||
	 (pb->bf_getreadbuffer == NULL &&
	  pb->bf_getcharbuffer == NULL) ||
	 pb->bf_getsegcount == NULL )
	return 0;
    else
	return 1;
}

/* Returns 1 if the given object supports the writing buffer
   interface. */

static
int PyBuffer_WriteableCheck(PyObject *obj)
{
    PyBufferProcs *pb = obj->ob_type->tp_as_buffer;

    if ( pb == NULL ||
	 pb->bf_getwritebuffer == NULL ||
	 pb->bf_getsegcount == NULL )
	return 0;
    else
	return 1;
}

/* Returns the size in bytes of the memory location the buffer points
   to or raises an error and returns -1. 

   XXX Only supports single segment buffers.

*/

static
int PyBuffer_GetSize(PyObject *obj)
{
    PyBufferProcs *pb = obj->ob_type->tp_as_buffer;
    int size = 0;
    
    if ( pb == NULL ||
	 pb->bf_getsegcount == NULL ) {
	PyErr_BadInternalCall();
	goto onError;
    }
    if ((*pb->bf_getsegcount)(obj,&size) != 1) {
	PyErr_SetString(PyExc_TypeError,
			"single-segment buffer object expected");
	return -1;
    }
    return size;

 onError:
    return -1;
}

/* Takes an arbitrary object which must support the (readable, single
   segment) buffer interface and returns a pointer to a read-only
   memory location useable as character based input for subsequent
   processing.

   buffer and buffer_len are only set in case no error
   occurrs. Otherwise, -1 is returned and an exception set.

*/

static
int PyBuffer_AsStringAndSize(PyObject *obj,
			     char **buffer,
			     int *buffer_len)
{
    PyBufferProcs *pb = obj->ob_type->tp_as_buffer;
    char *pp;
    int len;

    if ( pb == NULL ||
	 pb->bf_getreadbuffer == NULL ||
	 pb->bf_getsegcount == NULL ) {
	PyErr_SetString(PyExc_TypeError,
			"expected a single-segment readable buffer object");
	goto onError;
    }
    if ( (*pb->bf_getsegcount)(obj,NULL) != 1 ) {
	PyErr_SetString(PyExc_TypeError,
			"expected a single-segment readable buffer object");
	goto onError;
    }
    len = (*pb->bf_getreadbuffer)(obj,0,(void **)&pp);
    if (len < 0)
	goto onError;
    *buffer = pp;
    *buffer_len = len;
    return 0;

 onError:
    return -1;
}

#endif

#endif /* Python Version 1.5.2b2 */

/*
  ----------------------------------------------------------------
  Python 1.5.2b1 and older:
  ----------------------------------------------------------------
*/

#if PY_VERSION_HEX <= 0x010502B1

/* These are missing from PC/python_nt.def and thus didn't get included
   in python1.5.lib on Windows platforms. */
#ifdef MS_WIN32
# define PyString_InternInPlace(x)
# define PyString_InternFromString(x) PyString_FromString(x)
#endif

#endif /* Python Version <= 1.5.2b1 */

/*
  ----------------------------------------------------------------
  Python 1.5.2a2 and older:
  ----------------------------------------------------------------
*/

#if PY_VERSION_HEX <= 0x010502A2

extern long PyOS_strtol Py_PROTO((const char *, char **, int));
        
#endif /* Python Version <= 1.5.2a2 */

/*
  ----------------------------------------------------------------
  Python 1.5.2a1 and older:
  ----------------------------------------------------------------
*/

#if PY_VERSION_HEX <= 0x010502A1

#ifndef PyList_SET_ITEM
# define PyList_SET_ITEM(l,i,w) PyList_GET_ITEM(l,i) = w
#endif

#endif /* Python Version < 1.5.2a1 */

/*
  ----------------------------------------------------------------
  Prior to Python 1.5:
  ----------------------------------------------------------------
*/

#if PY_VERSION_HEX < 0x010500F0

/* New in Python1.5: */
# undef  PyString_AS_STRING
# define PyString_AS_STRING(op) (((PyStringObject *)(op))->ob_sval)
# define PyString_GET_SIZE(op)  (((PyStringObject *)(op))->ob_size)
# define PyTuple_GET_SIZE(op)    (((PyTupleObject *)(op))->ob_size)
# define PyList_GET_SIZE(op)    (((PyListObject *)(op))->ob_size)

/* Changed since 1.4 */
# undef PyList_GET_ITEM
# define PyList_GET_ITEM(op, i) (((PyListObject *)(op))->ob_item[i])
# undef  PyInt_AS_LONG
# define PyInt_AS_LONG(op) (((PyIntObject *)(op))->ob_ival)
# undef PyFloat_AS_DOUBLE
# define PyFloat_AS_DOUBLE(op) (((PyFloatObject *)(op))->ob_fval)

/* This function is taken from error.c in Python 1.5 */
#ifdef HAVE_STDARG_PROTOTYPES
PyObject *
PyErr_Format(PyObject *exception, const char *format, ...)
#else
PyObject *
PyErr_Format(exception, format, va_alist)
	PyObject *exception;
	const char *format;
	va_dcl
#endif
{
	va_list vargs;
	char buffer[500]; /* Caller is responsible for limiting the format */

#ifdef HAVE_STDARG_PROTOTYPES
	va_start(vargs, format);
#else
	va_start(vargs);
#endif

	vsprintf(buffer, format, vargs);
	PyErr_SetString(exception, buffer);
	return NULL;
}

/* Python 1.5 uses instances as exceptions, the 1.4 API only knows
   about strings. */
#define PyErr_NewException(name,base,dict) PyString_FromString(fullname);

/* Missing from rename2.h in Python 1.4 */
#ifndef PyVarObject
# define PyVarObject varobject
#endif

#endif /* Python Version < 1.5 */

#ifdef __cplusplus
}
#endif
