#include "global.h"

/*
 * Misc
 */
static VALUE
misc_set_align(self, xalign, yalign)
    VALUE self, xalign, yalign;
{
    gtk_misc_set_alignment(GTK_MISC(get_widget(self)),
			   NUM2DBL(xalign), NUM2DBL(yalign));
    return self;
}

static VALUE
misc_set_padding(self, xpad, ypad)
    VALUE self, xpad, ypad;
{
    gtk_misc_set_padding(GTK_MISC(get_widget(self)),
			 NUM2DBL(xpad), NUM2DBL(ypad));
    return self;
}

static VALUE
misc_get_xalign(self)
    VALUE self;
{
    return rb_float_new(GTK_MISC(get_widget(self))->xalign);
}

static VALUE
misc_get_yalign(self)
    VALUE self;
{
    return rb_float_new(GTK_MISC(get_widget(self))->yalign);
}

static VALUE
misc_get_xpad(self)
    VALUE self;
{
    return INT2NUM(GTK_MISC(get_widget(self))->xpad);
}

static VALUE
misc_get_ypad(self)
    VALUE self;
{
    return INT2NUM(GTK_MISC(get_widget(self))->ypad);
}

void Init_gtk_misc()
{
    gMisc = rb_define_class_under(mGtk, "Misc", gWidget);

    rb_define_method(gMisc, "set_alignment", misc_set_align, 2);
    rb_define_method(gMisc, "set_padding", misc_set_padding, 2);
    rb_define_method(gMisc, "xalign", misc_get_xalign, 0);
    rb_define_method(gMisc, "yalign", misc_get_yalign, 0);
    rb_define_method(gMisc, "xpad", misc_get_xpad, 0);
    rb_define_method(gMisc, "ypad", misc_get_ypad, 0);
}

/*
 * Arrow
 */
static VALUE
arrow_initialize(self, arrow_t, shadow_t)
    VALUE self, arrow_t, shadow_t;
{
    set_widget(self, gtk_arrow_new((GtkArrowType)NUM2INT(arrow_t),
				   (GtkShadowType)NUM2INT(shadow_t)));
    return Qnil;
}

static VALUE
arrow_set(self, arrow_t, shadow_t)
    VALUE self, arrow_t, shadow_t;
{
    gtk_arrow_set(GTK_ARROW(get_widget(self)),
		  (GtkArrowType)NUM2INT(arrow_t),
		  (GtkShadowType)NUM2INT(shadow_t));
    return self;
}

void Init_gtk_arrow()
{
    gArrow = rb_define_class_under(mGtk, "Arrow", gMisc);

    rb_define_method(gArrow, "initialize", arrow_initialize, 2);
    rb_define_method(gArrow, "set", arrow_set, 2);
}

/*
 * Image
 */
static VALUE
image_initialize(self, val, mask)
    VALUE self, val, mask;
{
    set_widget(self, gtk_image_new(get_gdkimage(val),
				   (GdkBitmap*)get_gdkpixmap(mask)));
    return Qnil;
}

static VALUE
image_set(self, val, mask)
    VALUE self, val, mask;
{
    gtk_image_set(GTK_IMAGE(get_widget(self)), get_gdkimage(val),
		  get_gdkpixmap(mask));
    return self;
}

static VALUE
image_get(self)
    VALUE self;
{
    GdkImage  *val;
    GdkBitmap *mask;

    gtk_image_get(GTK_IMAGE(get_widget(self)), &val, &mask);

    return rb_assoc_new(make_gdkimage(val),
			make_gdkpixmap(mask));
}

void Init_gtk_image()
{
    gImage = rb_define_class_under(mGtk, "Image", gMisc);

    rb_define_method(gImage, "initialize", image_initialize, 2);
    rb_define_method(gImage, "set", image_set, 2);
    rb_define_method(gImage, "get", image_get, 0);
}

/*
 * Label
 */
static VALUE
label_initialize(self, label)
    VALUE self, label;
{
    set_widget(self, gtk_label_new(STR2CSTR(label)));
    return Qnil;
}

static VALUE
label_get(self)
    VALUE self;
{
    gchar* str;
    gtk_label_get(GTK_LABEL(get_widget(self)), &str);
    return rb_str_new2(str);
}

static VALUE
label_set_text(self, str)
    VALUE self, str;
{
    gtk_label_set_text(GTK_LABEL(get_widget(self)), STR2CSTR(str));
    return Qnil;
}

static VALUE
label_get_jtype(self)
    VALUE self;
{
    return(INT2FIX(GTK_LABEL(get_widget(self))->jtype));
}

static VALUE
label_set_jtype(self, jtype)
    VALUE self, jtype;
{
    GtkJustification j;
    j = (GtkJustification) NUM2INT(jtype);
    gtk_label_set_justify(GTK_LABEL(get_widget(self)), j);
    return self;
}

static VALUE
label_set_line_wrap(self, wrap)
    VALUE self, wrap;
{
    gtk_label_set_line_wrap(GTK_LABEL(get_widget(self)), (gboolean)RTEST(wrap));
    return self;
}

static VALUE
label_set_pattern(self, pattern)
    VALUE self, pattern;
{
    gtk_label_set_pattern(GTK_LABEL(get_widget(self)), STR2CSTR(pattern));
    return self;
}

static VALUE
label_parse_uline(self, string)
    VALUE self, string;
{
    guint i = gtk_label_parse_uline(GTK_LABEL(get_widget(self)),
				    STR2CSTR(string));
    return INT2FIX(i);
}

void Init_gtk_label()
{
    gLabel = rb_define_class_under(mGtk, "Label", gMisc);

    rb_define_method(gLabel, "initialize", label_initialize, 1);
    rb_define_method(gLabel, "get_text", label_get, 0);
    rb_define_method(gLabel, "get", label_get, 0);
    rb_define_method(gLabel, "text", label_get, 0);
    rb_define_method(gLabel, "set_text", label_set_text, 1);
    rb_define_method(gLabel, "set", label_set_text, 1);
    rb_define_method(gLabel, "text=", label_set_text, 1);
    rb_define_method(gLabel, "jtype", label_get_jtype, 0);
    rb_define_method(gLabel, "jtype=", label_set_jtype, 1);
    rb_define_method(gLabel, "set_line_wrap", label_set_line_wrap, 1);
    rb_define_method(gLabel, "set_pattern", label_set_pattern, 1);
    rb_define_method(gLabel, "parse_uline", label_parse_uline, 1);
}

/*
 * TipsQuery
 */
static VALUE
tipsquery_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_tips_query_new());
    return Qnil;
}

static VALUE
tipsquery_start(self)
    VALUE self;
{
    gtk_tips_query_start_query(GTK_TIPS_QUERY(get_widget(self)));
    return self;
}

static VALUE
tipsquery_stop(self)
    VALUE self;
{
    gtk_tips_query_stop_query(GTK_TIPS_QUERY(get_widget(self)));
    return self;
}

static VALUE
tipsquery_set_caller(self, win)
    VALUE self, win;
{
    gtk_tips_query_set_caller(GTK_TIPS_QUERY(get_widget(self)),
			      get_widget(win));
    return self;
}

static VALUE
tipsquery_set_labels(self, label_inactive, label_no_tip)
    VALUE self, label_inactive, label_no_tip;
{
    gtk_tips_query_set_labels(GTK_TIPS_QUERY(get_widget(self)),
			      STR2CSTR(label_inactive),
			      STR2CSTR(label_no_tip));
    return self;
}

void Init_gtk_tips_query()
{
    gTipsQuery = rb_define_class_under(mGtk, "TipsQuery", gLabel);

    rb_define_const(gTipsQuery, "SIGNAL_START_QUERY", rb_str_new2("start_query"));
    rb_define_const(gTipsQuery, "SIGNAL_STOP_QUERY", rb_str_new2("stop_query"));
    rb_define_const(gTipsQuery, "SIGNAL_WIDGET_ENTERED", rb_str_new2("widget_entered"));
    rb_define_const(gTipsQuery, "SIGNAL_WIDGET_SELECTED", rb_str_new2("widget_selected"));

    rb_define_method(gTipsQuery, "initialize", tipsquery_initialize, 0);
    rb_define_method(gTipsQuery, "start", tipsquery_start, 0);
    rb_define_method(gTipsQuery, "stop", tipsquery_stop, 0);
    rb_define_method(gTipsQuery, "set_caller", tipsquery_set_caller, 1);
    rb_define_method(gTipsQuery, "set_labels", tipsquery_set_labels, 2);
}

/*
 * Pixmap
 */
static VALUE
pixmap_initialize(self, val, mask)
    VALUE self, val, mask;
{
    GdkPixmap *pixdata;
    GdkBitmap *maskdata;

#ifdef HAVE_GDKIMLIB
    if(rb_obj_is_kind_of(val, cImlibImage)){
        pixdata = get_gdkimlibpixmap(val);
        maskdata = get_gdkimlibmask(mask);
    } else {
#endif
        pixdata = get_gdkpixmap(val);
        maskdata = get_gdkbitmap(mask);
#ifdef HAVE_GDKIMLIB
    }
#endif
    set_widget(self, gtk_pixmap_new(pixdata, maskdata));
    return Qnil;
}

static VALUE
pixmap_set(self, val, mask)
    VALUE self, val, mask;
{
    GdkPixmap *pixdata;
    GdkBitmap *maskdata;

#ifdef HAVE_GDKIMLIB
    if(rb_obj_is_kind_of(val, cImlibImage)){
        pixdata = get_gdkimlibpixmap(val);
        maskdata = get_gdkimlibmask(mask);
    } else {
#endif
        pixdata = get_gdkpixmap(val);
        maskdata = get_gdkbitmap(mask);
#ifdef HAVE_GDKIMLIB
    }
#endif
    gtk_pixmap_set(GTK_PIXMAP(get_widget(self)), pixdata, maskdata);
    return self;
}

static VALUE
pixmap_get(self)
    VALUE self;
{
    GdkPixmap  *val;
    GdkBitmap *mask;

    gtk_pixmap_get(GTK_PIXMAP(get_widget(self)), &val, &mask);

    return rb_assoc_new(make_gdkpixmap(val),
			make_gdkbitmap(mask));
}

void Init_gtk_pixmap()
{
    gPixmap = rb_define_class_under(mGtk, "Pixmap", gMisc);

    rb_define_method(gPixmap, "initialize", pixmap_initialize, 2);
    rb_define_method(gPixmap, "set", pixmap_set, 2);
    rb_define_method(gPixmap, "get", pixmap_get, 0);
}
