#include "global.h"

/*
 * Editable
 */
static VALUE
edit_sel_region(self, start, end)
    VALUE self, start, end;
{
    gtk_editable_select_region(GTK_EDITABLE(get_widget(self)),
			       NUM2INT(start), NUM2INT(end));
    return self;
}

static VALUE
edit_insert_text(self, new_text, pos)
    VALUE self, new_text, pos;
{
    gint p = NUM2INT(pos);

    Check_Type(new_text, T_STRING);
    gtk_editable_insert_text(GTK_EDITABLE(get_widget(self)),
			     RSTRING(new_text)->ptr,
			     RSTRING(new_text)->len,
			     &p);
    return INT2NUM(p);
}

static VALUE
edit_delete_text(self, start, end)
    VALUE self, start, end;
{
    gtk_editable_delete_text(GTK_EDITABLE(get_widget(self)),
			     NUM2INT(start), NUM2INT(end));
    return self;
}

static VALUE
edit_get_chars(self, start, end)
    VALUE self, start, end;
{
    gchar *s;
    VALUE ret;

    s = gtk_editable_get_chars(GTK_EDITABLE(get_widget(self)), /* check s */
			       NUM2INT(start), NUM2INT(end));  /* check start,end */
    if (s) {
        ret = rb_str_new2(s);
        g_free(s);
    } else {
        ret = Qnil;
    }
    return ret;
}

/*
static VALUE
edit_cut_clipboard(self, time)
    VALUE self, time;
{
    gtk_editable_cut_clipboard(GTK_EDITABLE(get_widget(self)),NUM2INT(time));
    return self;
}

static VALUE
edit_copy_clipboard(self, time)
    VALUE self, time;
{
    gtk_editable_copy_clipboard(GTK_EDITABLE(get_widget(self)),NUM2INT(time));
    return self;
}
	
static VALUE
edit_paste_clipboard(self, time)
    VALUE self, time;
{
    gtk_editable_paste_clipboard(GTK_EDITABLE(get_widget(self)),NUM2INT(time));
    return self;
}
*/
	
static VALUE
edit_claim_selection(self, claim, time)
    VALUE self, claim, time;
{
    gtk_editable_claim_selection(GTK_EDITABLE(get_widget(self)),
				 RTEST(claim), NUM2INT(time));
    return self;
}
	
static VALUE
edit_delete_selection(self)
    VALUE self;
{
    gtk_editable_delete_selection(GTK_EDITABLE(get_widget(self)));
    return self;
}

static VALUE
edit_changed(self)
    VALUE self;
{
    gtk_editable_changed(GTK_EDITABLE(get_widget(self)));
    return self;
}

static VALUE
edit_is_editable(self)
    VALUE self;
{
    return GTK_EDITABLE(get_widget(self))->editable? Qtrue: Qfalse;
}

static VALUE
edit_get_position(self)
    VALUE self;
{
    return INT2NUM(gtk_editable_get_position(GTK_EDITABLE(get_widget(self))));
}

static VALUE
edit_set_position(self, position)
    VALUE self, position;
{
    gtk_editable_set_position(GTK_EDITABLE(get_widget(self)),
			      NUM2INT(position));
    return self;
}

static VALUE
edit_set_editable(self, editable)
    VALUE self, editable;
{
    gtk_editable_set_editable(GTK_EDITABLE(get_widget(self)), RTEST(editable));
    return self;
}

static VALUE
edit_cut_clipboard(self)
    VALUE self;
{
    gtk_editable_cut_clipboard(GTK_EDITABLE(get_widget(self)));
    return self;
}

static VALUE
edit_copy_clipboard(self)
    VALUE self;
{
    gtk_editable_copy_clipboard(GTK_EDITABLE(get_widget(self)));
    return self;
}

static VALUE
edit_paste_clipboard(self)
    VALUE self;
{
    gtk_editable_paste_clipboard(GTK_EDITABLE(get_widget(self)));
    return self;
}

static VALUE
edit_has_selection_p(self)
    VALUE self;
{
    return GTK_EDITABLE(get_widget(self))->has_selection? Qtrue: Qfalse;
}

static VALUE
edit_selection_start_pos(self)
    VALUE self;
{
    return INT2NUM(GTK_EDITABLE(get_widget(self))->selection_start_pos);
}

static VALUE
edit_selection_end_pos(self)
    VALUE self;
{
    return INT2NUM(GTK_EDITABLE(get_widget(self))->selection_end_pos);
}

void Init_gtk_editable()
{
    gEditable = rb_define_class_under(mGtk, "Editable", gWidget);

    rb_define_const(gEditable, "SIGNAL_ACTIVATE", rb_str_new2("activate"));
    rb_define_const(gEditable, "SIGNAL_CHANGED", rb_str_new2("changed"));

    rb_define_method(gEditable, "select_region", edit_sel_region, 2);
    rb_define_method(gEditable, "insert_text", edit_insert_text, 2);
    rb_define_method(gEditable, "delete_text", edit_delete_text, 2);
    rb_define_method(gEditable, "get_chars", edit_get_chars, 2);
    /*
      rb_define_method(gEditable, "cut_clipboard", edit_cut_clipboard, 1);
      rb_define_method(gEditable, "copy_clipboard", edit_copy_clipboard, 1);
      rb_define_method(gEditable, "paste_clipboard", edit_paste_clipboard, 1);
    */
    rb_define_method(gEditable, "claim_selection", edit_claim_selection, 2);
    rb_define_method(gEditable, "delete_selection", edit_delete_selection, 0);
    rb_define_method(gEditable, "changed", edit_changed, 0);
    rb_define_method(gEditable, "editable?", edit_is_editable, 0);
    rb_define_method(gEditable, "position", edit_get_position, 0);
    rb_define_method(gEditable, "position=", edit_set_position, 1);
    rb_define_method(gEditable, "set_editable", edit_set_editable, 1);
    rb_define_method(gEditable, "copy_clipboard", edit_copy_clipboard, 0);
    rb_define_method(gEditable, "cut_clipboard", edit_cut_clipboard, 0);
    rb_define_method(gEditable, "paste_clipboard", edit_paste_clipboard, 0);
    rb_define_method(gEditable, "has_selection?", edit_has_selection_p, 0);
    rb_define_method(gEditable, "selection_start_pos", edit_selection_start_pos, 0);
    rb_define_method(gEditable, "selection_end_pos", edit_selection_end_pos, 0);
}

/*
 * Entry
 */
static VALUE
entry_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_entry_new());
    return Qnil;
}

static VALUE
entry_set_text(self, text)
    VALUE self, text;
{
    gtk_entry_set_text(GTK_ENTRY(get_widget(self)), STR2CSTR(text));

    return self;
}

static VALUE
entry_append_text(self, text)
    VALUE self, text;
{
    gtk_entry_append_text(GTK_ENTRY(get_widget(self)), STR2CSTR(text));
    return self;
}

static VALUE
entry_prepend_text(self, text)
    VALUE self, text;
{
    gtk_entry_prepend_text(GTK_ENTRY(get_widget(self)), STR2CSTR(text));
    return self;
}

static VALUE
entry_set_position(self, position)
    VALUE self, position;
{
    gtk_entry_set_position(GTK_ENTRY(get_widget(self)), NUM2INT(position));
    return self;
}

static VALUE
entry_get_text(self)
    VALUE self;
{
    gchar* text;
    VALUE ret;
    text = gtk_entry_get_text(GTK_ENTRY(get_widget(self)));
    ret = rb_str_new2(text);
    return ret;
}

static VALUE
entry_set_visibility(self, visibility)
    VALUE self, visibility;
{
    gtk_entry_set_visibility(GTK_ENTRY(get_widget(self)), RTEST(visibility));
    return self;
}

static VALUE
entry_set_max_length(self, max)
    VALUE self, max;
{
    gtk_entry_set_max_length(GTK_ENTRY(get_widget(self)), NUM2INT(max));
    return self;
}

void Init_gtk_entry()
{
    gEntry = rb_define_class_under(mGtk, "Entry", gEditable);

    rb_define_method(gEntry, "initialize", entry_initialize, 0);
    rb_define_method(gEntry, "set_text", entry_set_text, 1);
    rb_define_method(gEntry, "append_text", entry_append_text, 1);
    rb_define_method(gEntry, "prepend_text", entry_prepend_text, 1);
    rb_define_method(gEntry, "set_position", entry_set_position, 1);
    rb_define_method(gEntry, "get_text", entry_get_text, 0);
    rb_define_method(gEntry, "set_visibility", entry_set_visibility, 1);
    rb_define_method(gEntry, "set_max_length", entry_set_max_length, 1);
}

/*
 * SpinButton
 */
static VALUE
sbtn_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE arg1, arg2, arg3;
    GtkAdjustment *adj = NULL;
    gfloat climb_rate;
    gint digits;
    GtkWidget *widget;

    rb_scan_args(argc, argv, "03", &arg1, &arg2, &arg3);

    if (!NIL_P(arg1)) adj = GTK_ADJUSTMENT(get_gobject(arg1));
    climb_rate = (NIL_P(arg2))? 0.0: NUM2DBL(arg2);
    digits     = (NIL_P(arg3))?   0: NUM2INT(arg3);

    widget = gtk_spin_button_new(adj, climb_rate, digits);

    set_widget(self, widget);
    return Qnil;
}
static VALUE
sbtn_set_adjustment(self,adj)
    VALUE self, adj;
{
    gtk_spin_button_set_adjustment(GTK_SPIN_BUTTON(get_widget(self))
				   ,GTK_ADJUSTMENT(get_gobject(adj)));
    return self;
}
static VALUE
sbtn_get_adjustment(self)
    VALUE self;
{
    return make_gobject(gAdjustment,
			GTK_OBJECT(gtk_spin_button_get_adjustment(
			    GTK_SPIN_BUTTON(get_widget(self)))));
}
static VALUE
sbtn_digits(self)
    VALUE self;
{
    return INT2NUM(GTK_SPIN_BUTTON(get_widget(self))->digits);
}
static VALUE
sbtn_set_digits(self,n)
    VALUE self, n;
{
    (void)gtk_spin_button_set_digits(GTK_SPIN_BUTTON(get_widget(self))
				     , NUM2INT(n));
    return self;
}
static VALUE
sbtn_get_value_as_float(self)
    VALUE self;
{
    float w;
    w = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(get_widget(self)));
    return rb_float_new(w);
}
static VALUE
sbtn_get_value_as_int(self)
    VALUE self;
{
    int w;
    w = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget(self)));
    return INT2NUM(w);
}
static VALUE
sbtn_set_value(self,n)
    VALUE self, n;
{
    (void)gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget(self))
				    , NUM2DBL(n));
    return self;
}
static VALUE
sbtn_set_numeric(self,n)
    VALUE self, n;
{
    (void)gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(get_widget(self))
				      , RTEST(n));
    return self;
}
static VALUE
sbtn_set_update_policy(self,w)
    VALUE self, w;
{
    (void)gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(get_widget(self))
					    ,NUM2INT(w) );
    return self;
}
static VALUE
sbtn_spin(self,n,m)
    VALUE self, n, m;
{
    (void)gtk_spin_button_spin(GTK_SPIN_BUTTON(get_widget(self))
			       ,NUM2INT(n)
			       ,NUM2DBL(m));
    return self;
}
static VALUE
sbtn_set_wrap(self,n)
    VALUE self, n;
{
    (void)gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(get_widget(self)),
				   RTEST(n));
    return self;
}
static VALUE
sbtn_set_snap_to_ticks(self,n)
    VALUE self, n;
{
    (void)gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(get_widget(self)),
					    RTEST(n));
    return self;
}

void Init_gtk_spin_button()
{
    gSButton = rb_define_class_under(mGtk, "SpinButton", gEntry);

    rb_define_method(gSButton, "initialize",        sbtn_initialize, -1);
    rb_define_method(gSButton, "set_adjustment",    sbtn_set_adjustment,1);
    rb_define_method(gSButton, "get_adjustment",    sbtn_get_adjustment,0);
    rb_define_method(gSButton, "digits",            sbtn_digits, 0);
    rb_define_method(gSButton, "set_digits",        sbtn_set_digits, 1);
    rb_define_method(gSButton, "get_value_as_float",sbtn_get_value_as_float,0);
    rb_define_method(gSButton, "get_value_as_int",  sbtn_get_value_as_int, 0);
    rb_define_method(gSButton, "set_value",         sbtn_set_value, 1);
    rb_define_method(gSButton, "set_numeric",       sbtn_set_numeric, 1);
    rb_define_method(gSButton, "set_update_policy", sbtn_set_update_policy,1);
    rb_define_method(gSButton, "spin",              sbtn_spin,2);
    rb_define_method(gSButton, "set_wrap",          sbtn_set_wrap,1);
    rb_define_method(gSButton, "set_snap_to_ticks", sbtn_set_snap_to_ticks, 1);
    /*
      rb_define_method(gSButton, "get_type",          sbtn_get_type,0);
      rb_define_method(gSButton, "construct",         sbtn_construct,4);
    */
    rb_define_const(gSButton, "UPDATE_ALWAYS", INT2FIX(GTK_UPDATE_ALWAYS));
    rb_define_const(gSButton, "UPDATE_IF_VALID", INT2FIX(GTK_UPDATE_IF_VALID));
    /* 1.2.x
       rb_define_const(gSButton, "UPDATE_SNAP_TO_TICKS", INT2FIX(GTK_UPDATE_SNAP_TO_TICKS));
    */
}

/*
 * Text
 */
static VALUE
txt_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE arg1, arg2;
    GtkAdjustment *h_adj = NULL;
    GtkAdjustment *v_adj = NULL;

    rb_scan_args(argc, argv, "02", &arg1, &arg2);
    if (!NIL_P(arg1)) h_adj = GTK_ADJUSTMENT(get_gobject(arg1));
    if (!NIL_P(arg2)) v_adj = GTK_ADJUSTMENT(get_gobject(arg2));

    set_widget(self, gtk_text_new(h_adj, v_adj));
    return Qnil;
}

static VALUE
txt_set_word_wrap(self, word_wrap)
    VALUE self, word_wrap;
{
    gtk_text_set_word_wrap(GTK_TEXT(get_widget(self)), RTEST(word_wrap));
    return self;
}

static VALUE
txt_set_adjustment(self, h_adj, v_adj)
    VALUE self, h_adj, v_adj;
{
    gtk_text_set_adjustments(GTK_TEXT(get_widget(self)),
			     GTK_ADJUSTMENT(get_gobject(h_adj)),
			     GTK_ADJUSTMENT(get_gobject(v_adj)));

    return self;
}

static VALUE
txt_set_point(self, index)
    VALUE self, index;
{
    gtk_text_set_point(GTK_TEXT(get_widget(self)), NUM2INT(index));
    return self;
}

static VALUE
txt_get_point(self)
    VALUE self;
{
    int index = gtk_text_get_point(GTK_TEXT(get_widget(self)));
    
    return INT2FIX(index);
}

static VALUE
txt_get_length(self)
    VALUE self;
{
    int len = gtk_text_get_length(GTK_TEXT(get_widget(self)));
    
    return INT2FIX(len);
}

static VALUE
txt_freeze(self)
    VALUE self;
{
    gtk_text_freeze(GTK_TEXT(get_widget(self)));
    return self;
}

static VALUE
txt_thaw(self)
    VALUE self;
{
    gtk_text_thaw(GTK_TEXT(get_widget(self)));
    return self;
}

static VALUE
txt_insert(self, font, fore, back, str)
    VALUE self, font, fore, back, str;
{
    Check_Type(str, T_STRING);
    gtk_text_insert(GTK_TEXT(get_widget(self)), 
		    get_gdkfont(font),
		    get_gdkcolor(fore),
		    get_gdkcolor(back),
		    RSTRING(str)->ptr,
		    RSTRING(str)->len);

    return self;
}

static VALUE
txt_backward_delete(self, nchars)
    VALUE self, nchars;
{
    gtk_text_backward_delete(GTK_TEXT(get_widget(self)), NUM2INT(nchars));
    return self;
}

static VALUE
txt_forward_delete(self, nchars)
    VALUE self, nchars;
{
    gtk_text_forward_delete(GTK_TEXT(get_widget(self)), NUM2INT(nchars));
    return self;
}

static VALUE
txt_has_cursor(self)
    VALUE self;
{
    rb_notimplement();
    /*  return GTK_TEXT(get_widget(self))->has_cursor? Qtrue: Qfalse; */
}

void Init_gtk_text()
{
    gText = rb_define_class_under(mGtk, "Text", gEditable);

    rb_define_method(gText, "initialize", txt_initialize, -1);
    rb_define_method(gText, "set_word_wrap", txt_set_word_wrap, 1);
    rb_define_method(gText, "set_adjustment", txt_set_adjustment, 2);
    rb_define_method(gText, "set_point", txt_set_point, 1);
    rb_define_method(gText, "get_point", txt_get_point, 0);
    rb_define_method(gText, "get_length", txt_get_length, 0);
    rb_define_method(gText, "freeze", txt_freeze, 0);
    rb_define_method(gText, "thaw", txt_thaw, 0);
    rb_define_method(gText, "insert", txt_insert, 4);
    rb_define_method(gText, "backward_delete", txt_backward_delete, 1);
    rb_define_method(gText, "forward_delete", txt_forward_delete, 1);
    rb_define_method(gText, "has_cursor?", txt_has_cursor, 0);
}
