=begin
extconf.rb for gtk extention library
=end

require "mkmf"

#
# detect GTK+ (and Imlib) configurations
#
if /mswin32/ !~ PLATFORM
  config_cmds = ["gtk-config"]
  if enable_config("imlib", true)
    config_cmds.unshift("imlib-config")
  end
  while /^--/ =~ ARGV.shift; end
  if ARGV.size > 0
    config_cmds.unshift(ARGV[0])
  end
  
  begin
    config_cmds.each do |config_cmd|
      version = `#{config_cmd} --version`
      if not version.chomp.empty?
	if /^imlib/ === File.basename(config_cmd)
	  with_imlib = true
	  config_libs, config_cflags = "--libs-gdk", "--cflags-gdk"
	else
	  with_imlib = false
	  config_libs, config_cflags = "--libs", "--cflags"
	end
	$LDFLAGS, *libs = `#{config_cmd} #{config_libs}`.chomp.split(/(-l.*)/)
	$libs = libs.join(' ') + ' ' + $libs
	$CFLAGS = `#{config_cmd} #{config_cflags}`.chomp
	if with_imlib
	  $CFLAGS = $CFLAGS + " -DHAVE_GDKIMLIB"
	  STDERR.puts("Imlib support enabled.")
	end
	break
      end
    end
  rescue
    $LDFLAGS = '-L/usr/X11R6/lib -L/usr/local/lib'
    $CFLAGS = '-I/usr/X11R6/lib -I/usr/local/include'
    $libs = '-lm -lc'
  end
else
  $LDFLAGS = '-L/usr/local/lib'
  $CFLAGS = '-I/usr/local/include/gdk/win32 -I/usr/local/include/glib -I/usr/local/include'
end

#
# detect location of GDK include files
#
gdkincl = nil
tmpincl = $CFLAGS.gsub(/-D\w+/, '').split('-I') + '/usr/include'
tmpincl.each do |i|
  i.strip!
  
  if FileTest.exist?(i + "/gdk/gdkcursors.h") and
      FileTest.exist?(i + "/gdk/gdkkeysyms.h")
    gdkincl = i + "/gdk"
    break
  end
end

#
# create Makefiles
#
mdir = $mdir
begin
  $mdir = "gtk/src"
  Dir.chdir "src"

  lib_ary = []
  if /mswin32/ !~ PLATFORM
    lib_ary = [ ["X11", "XOpenDisplay"],
                ["Xext", "XShmQueryVersion"],
                ["Xi", "XOpenDevice"],
#                ["glib", "g_print"],
#                ["gdk", "gdk_init"],
#                ["gtk", "gtk_init"],
    ]
  else
    lib_ary = [ ["glib-1.3", "g_print"],
                ["gdk-1.3", "gdk_init"],
                ["gtk-1.3", "gtk_init"] ]
  end

  lib_ary.each do |ary|

    if not have_library(ary[0], ary[1])
      msg = format("cannot found %s in %s.", ary[1], ary[0])
      if ary[0] == "X11"
	msg += " (or maybe `gtk-config --lib' is incorrect...)"
      end
      raise Interrupt, msg
    end
  end
  if /mswin32/ =~ PLATFORM
     if have_library("gdk_imlib", "gdk_imlib_init")
       $CFLAGS = $CFLAGS + " -DHAVE_GDKIMLIB"
       STDERR.puts("Imlib support enabled.")
     end
  end
  have_func("XReadBitmapFileData")
  if have_func("gdk_ic_attr_new")
       $CFLAGS = $CFLAGS + " -DUSE_XIM"
  end

  obj_ext = ".#{$OBJEXT}"

  $libs = $libs.split(/\s/).uniq.join(' ')
  $objs = [
    "global",
    "init",
    "rbgdk",
    "rbgdkcolor",
    "rbgdkconst",
    "rbgdkdraw",
    "rbgdkevent",
    "rbgdkim",
    "rbgdkimlib",
    "rbgdkpixmap", 
    "rbgdkregion", 
    "rbgdkrgb", 
    "rbgdkwindow",
    "rbgtk",
    "rbgtkbox",
    "rbgtkbutton",
    "rbgtkclist",
    "rbgtkconst",
    "rbgtkcontainer",
    "rbgtkctree",
    "rbgtkdata",
    "rbgtkeditable",
    "rbgtkframe",
    "rbgtkitem",
    "rbgtklayout",
    "rbgtklist",
    "rbgtkmisc",
    "rbgtknotebook",
    "rbgtkrange",
    "rbgtkstyle",
    "rbgtktoolbar",
    "rbgtkwidget",
    "rbgtkwindow",
  ].collect{|item| item + obj_ext}

  if /mswin32/ =~ PLATFORM
    $objs << "rbgdkkeysyms.lib"
  else
    $objs << "librbgdkkeysyms.a"
  end

  if /mswin32/ !~ PLATFORM
    $LOCAL_LIBS = $local_libs = " -L. -Lext/gtk/src -lrbgdkkeysyms "
  end

  create_makefile("gtk")
  raise Interrupt if not FileTest.exist? "Makefile"

  mfile = File.open("Makefile", "a")
  if /mswin32/ =~ PLATFORM
    mfile.puts "	copy /Y  gtk.lib .."
    mfile.puts
  end
  mfile.print "\

rbgdkconst#{obj_ext}: rbgdkconst.c global.h
rbgdkcolor#{obj_ext}: rbgdkcolor.c global.h
rbgdkdraw#{obj_ext}: rbgdkdraw.c global.h
rbgdkevent#{obj_ext}: rbgdkevent.c global.h
rbgdkim#{obj_ext}: rbgdkim.c global.h
rbgdkimlib#{obj_ext}: rbgdkimlib.c global.h
rbgdkpixmap#{obj_ext}: rbgdkpixmap.c global.h
rbgdkregion#{obj_ext}: rbgdkregion.c global.h
rbgdkrgb#{obj_ext}: rbgdkrgb.c global.h
rbgdkwindow#{obj_ext}: rbgdkwindow.c global.h
rbgtkbox#{obj_ext}: rbgtkbox.c global.h
rbgtkbutton#{obj_ext}: rbgtkbutton.c global.h
rbgtkclist#{obj_ext}: rbgtkclist.c global.h
rbgtkconst#{obj_ext}: rbgtkconst.c global.h
rbgtkcontainer#{obj_ext}: rbgtkcontainer.c global.h
rbgtkctree#{obj_ext}: rbgtkctree.c global.h
rbgtkdata#{obj_ext}: rbgtkdata.c global.h
rbgtkeditable#{obj_ext}: rbgtkeditable.c global.h
rbgtkframe#{obj_ext}: rbgtkframe.c global.h
rbgtkitem#{obj_ext}: rbgtkitem.c global.h
rbgtklayout#{obj_ext}: rbgtklayout.c global.h
rbgtklist#{obj_ext}: rbgtklist.c global.h
rbgtkmisc#{obj_ext}: rbgtkmisc.c global.h
rbgtknotebook#{obj_ext}: rbgtknotebook.c global.h
rbgtkrange#{obj_ext}: rbgtkrange.c global.h
rbgtkstyle#{obj_ext}: rbgtkstyle.c global.h
rbgtktoolbar#{obj_ext}: rbgtktoolbar.c global.h
rbgtkwidget#{obj_ext}: rbgtkwidget.c global.h
rbgtkwindow#{obj_ext}: rbgtkwindow.c global.h

rbgdk#{obj_ext}: rbgdk.c rbgdkcursors.h
"
if /mswin32/ =~ PLATFORM
  mfile.print "\
rbgdkkeysyms.lib: makedefconst.rb rbgdkkeysyms.h
	$(RUBY) makedefconst.rb rbgdkkeysyms.h Init_gtk_gdkkeysyms
	cd rbgdkkeysyms
	nmake ..\\$@
	cd ..
"
else
  mfile.print "\

librbgdkkeysyms.a: makedefconst.rb rbgdkkeysyms.h
	$(RUBY) $? Init_gtk_gdkkeysyms
	cd rbgdkkeysyms; make ../$@; cd ..
"
end

  mfile.print "\

rbgdkcursors.h:;	$(RUBY) makecursors.rb #{gdkincl}/gdkcursors.h > $@
rbgdkkeysyms.h:;	$(RUBY) makekeysyms.rb #{gdkincl}/gdkkeysyms.h > $@

allclean: realclean
	rm -rf rbgdkkeysyms* *.a rbgdkcursors*
"
  mfile.close
  Dir.chdir ".."

  mfile = File.open("Makefile", "w")
  if /mswin32/ =~ PLATFORM
    mfile.print "\

all:
		@cd src
		@nmake -nologo

install:
		@cd src
		@nmake -nologo install DESTDIR=$(DESTDIR)

clean:
		@cd src
		@nmake -nologo allclean
		@cd ..
		@-rm -f Makefile extconf.h conftest.*
		@-rm -f gtk.lib *~
"
  else
    mfile.print "\

all:
		@cd src; make all
		@if [ ! -r gtk.a ]; then ln -sf src/gtk.a gtk.a; fi 
	
install:;	@cd src; make install DESTDIR=$(DESTDIR)
clean:
		@cd src; make allclean
		@rm -f Makefile extconf.h conftest.*
		@rm -f core gtk.a *~
"
  end
  mfile.close

rescue Interrupt
#  if $DEBUG
    print "  [error] " + $!.to_s + "\n"
#  end
  Dir.chdir ".."
ensure
  $mdir = mdir
end
