// ---------------------------------------------------------------------------
// - t_cdl.cpp                                                               -
// - standard system library - dynamic library tester module                 -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cdl.hxx"

int main (int, char**) {
  using namespace aleph;

  // try to open our library
  void* handle = c_dlopen ("libasys");
  if (!handle) return 1;

  // try to query a symbol in the aleph namespace
  void* sym = c_dlsym ("cdl_test_symbol", handle);
  if (!sym) return 1;

  // close the library
  c_dlclose (handle);
  return 0;
}
