// POV file adapted from topo example by Russell Towle
// adapted from gforge for Terraform by Robert Gasch
//


// TF_HEIGHT_FIELD
//
// Declares the height field object that's positioned with one corner at
// the origin

#ifndef (TF_HEIGHT_FIELD)
#declare TF_HEIGHT_FIELD = height_field { tga "Untitled1.tga" smooth }
#end

// TF_Y_SCALE
//
// This parameter is a float between (0.0, 1.0].  Basically, it sets the
// height of the rendered terrain

#ifndef (TF_Y_SCALE)
#declare TF_Y_SCALE = 0.33;
#end



/////// End of User Definable Parameters ////////////////////////////////////

// Include files
#include "colors.inc"
#include "textures.inc"


camera
{
	location	<0,  1, -1.5>	// <X Y Z>
	direction	2*z            	// which way are we looking <X Y Z>
	up		y              	// which way is +up <X Y Z>
	right		1.33*x         	// which way is +right <X Y Z> and aspect ratio
	look_at		<0, -0.05, 0> 	// point center of view at this point <X Y Z>
}



light_source { <-300, 300, -10> color red 0.75 green 0.5 blue 0.3 }
light_source { <-300, 210, 5>   color red 0.25 green 0.1 blue 0.0 }


// The heightfield object is in the X-Z plane, centered on the origin, 
// and extends +/- 0.5 units in the X and Z directions
object
{
	TF_HEIGHT_FIELD
	scale < 1, TF_Y_SCALE, 1 >			// reduce height
	translate <-.5, 0, -.5>
	texture 
		{ 
		pigment { color White } 
		finish { phong 0.1 ambient 0.2 } 
		}
}


