/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef GUI_DIALOG_ABOUT_H_
#define GUI_DIALOG_ABOUT_H_

#include "GuiDialogOAC.h"				// include gtk, gtk--
#include <gdk/gdk.h>

#ifdef HAVE_IMLIB
#include <gdk_imlib.h>
#endif

/* 
 * GuiDialogAbout: provide an about dialog suitable for use with and 
 *		   without imlib. 
 */
class GuiDialogAbout : public Gtk_Window
	{
	public: 
				GuiDialogAbout (char *winTitle, char *imageFile, 
						char **msgPtrs, int nMesgs);
				~GuiDialogAbout (); 
		virtual void	buildDialogWindow ();

	protected:
		// other functions 
		virtual gint	handleButtonPressEvent (GdkEventButton *e);
		virtual gint	delete_event_impl (GdkEventAny *e);
		void 		buttonCallback ();
		void		addLabels (Gtk_VBox *vbox);
#ifdef HAVE_IMLIB
		int		loadLogo ();	
#endif

		Gtk_Preview		d_preview;
		Gtk_VBox		d_vBox;
		int			d_nMessage;
		char			*p_winTitle, 
					**p_msgPtrs;
		Gtk_Label		**p_lblPtrs;
#ifdef HAVE_IMLIB
		Gtk_Frame		d_frame;
		Gtk_VBox		d_vBoxFrame;
		GdkImlibImage		*p_image;
		char 			*p_imageFile;
#endif

	};


#endif // GUI_DIALOG_ABOUT_H_
