/***************************************************************************
                          rinfowidget.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rinfowidget.h 1998/09/23 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RINFOWIDGET_H
#define RINFOWIDGET_H

#include "rgraphic.h"
#include "rwidget.h"

class RLabel;

class RInfoWidget : public RWidget
{
  Q_OBJECT
public:
  RInfoWidget(QWidget* _parent=0, 
              const char* _name=0, 
              WFlags _f=0);
  ~RInfoWidget();

  void resizeChildren();

  void      setGraphic(RGraphic* _graphic);
  RGraphic* getGraphic() { return graphic; }

protected:
  virtual void resizeEvent(QResizeEvent* _ev);
  void updateInfo(bool _values);
    
public slots:
  virtual void show();
  void updateInfo() { updateInfo(true); }

private:
  bool      valid;        // is the info still valid?

  RGraphic* graphic;      // Pointer to graphic
  RLabel*   lPath;        // Label for path
  RLabel*   path;         // path
  RLabel*   lCreation;    // Label for creation date/time
  RLabel*   creation;     // creation date/time
  RLabel*   lSize;        // Label for size
  RLabel*   size;         // size
  RLabel*   lObjects;     // Label for number of Objects
  RLabel*   objects;      // objects
  RLabel*   lTotalWay;    // Label for total way
  RLabel*   totalWay;     // total way
  RLabel*   lCuttingWay;  // Label for cutting way
  RLabel*   cuttingWay;   // cutting way
  
};


#endif

// EOF


