#include "swserv.h"


/*
 *      Boot off a player.
 */
int CmdBoot(int condescriptor, char *arg)
{
        long i, object_num, con_object_num;
        char sndbuf[CS_DATA_MAX_LEN];
        char stringa[512];
	char name1[XSW_OBJ_NAME_MAX];
	char name2[XSW_OBJ_NAME_MAX];
        long object_con;
        
        
        /* Get con_object_num, assumed valid. */
        con_object_num = connection[condescriptor]->object_num;
        
        
        /* Check if object's permission allows boot. */
        if(xsw_object[con_object_num]->permission.uid > ACCESS_UID_BOOT)
        {
            sprintf(sndbuf,
                "set: Requires access level %i: Permission denied.",
                ACCESS_UID_BOOT
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            
            return(-1);
        }

        /* Print usage? */
        if(strlen(arg) < 1)
        {
            NetSendLiveMessage(condescriptor,
                "Usage: `boot <player>'"
            );
 
            return(-1);
        }
 
        
        /* Match the object_num to be booted. */
        if(!strcmp(arg, "me"))
        {
            object_num = connection[condescriptor]->object_num;
        }
        else
        {
            object_num = MatchObjectByName(arg, XSW_OBJ_TYPE_PLAYER);
        }
        
        
        /* Was a match found? */
        if(DBIsObjectGarbage(object_num))
        {
            sprintf(sndbuf,
                "boot: %s: No such player.",
                arg
            );
            NetSendLiveMessage(condescriptor, sndbuf);
         
            return(-1);
        }
        
        
        /* Is that object connected? */
        for(i = 0, object_con = -1; i < total_connections; i++)
        {
            if(!ConIsLoggedIn(i))
		continue;
 
            if(connection[i]->object_num == object_num)
            {
                object_con = i;
                break;
            }
        }
         
        
        /* Check if we found of a connection for the object. */
        if((object_con < 0) || (object_con >= total_connections))
        {
            sprintf(sndbuf,
                "boot: %s: Not connected.",
                arg
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }
            
                
        sprintf(sndbuf,
            "Booted: %s on connection %ld.",
            DBGetFormalNameStr(object_num),
            object_con
        );
        NetSendLiveMessage(condescriptor, sndbuf);


        /* Log boot. */
	strncpy(
	    name1,
	    DBGetFormalNameStr(connection[condescriptor]->object_num),
	    XSW_OBJ_NAME_MAX
	);
	name1[XSW_OBJ_NAME_MAX - 1] = '\0';

        strncpy(
            name2,
            DBGetFormalNameStr(object_num),
            XSW_OBJ_NAME_MAX
        );
        name2[XSW_OBJ_NAME_MAX - 1] = '\0';


        sprintf(stringa,
            "%s: Booted: %s on connection %ld.",
            name1, name2, object_con
        );   
        if(sysparm.log_general == 1)
            LogAppendLineFormatted(fname.primary_log, stringa);


        /* Boot connection object_con. */
        NetCloseConnection(object_con);


        return(0);
}
