/*
                  X S H I P W A R S   C L I E N T

            Copyright (C) 1997, 1998, 1999, 2000 WolfPack

 */

#ifndef XSW_H
#define XSW_H


#include <stdio.h>
#include <db.h>
#include <sys/types.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
extern int errno;
#include <errno.h>
#include <ctype.h>
#include <math.h>  
#include <fcntl.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

#ifdef JS_SUPPORT
# include <jsw.h>
#endif  /* JS_SUPPORT */

#include "../include/os.h" 	/* OS `safety net' definations. */
#include "../include/fio.h"
#include "../include/cfgfmt.h"		/* UNIX config format. */
#include "../include/graphics.h"
#include "../include/strexp.h"
#include "../include/string.h"
#include "../include/urlparse.h"
#include "../include/disk.h"
#include "../include/prochandle.h"

#include "../include/objects.h"	/* XSW Objects. */
#include "../include/mathutil.h"
#include "../include/dbmatch.h"
#include "../include/isrefs.h"	/* Image set referances. */
#include "../include/reality.h"

#include "../include/cs.h"		/* Cyberspace protocol. */
#include "../include/swnetcodes.h"	/* Extended Cyberspace protocols. */

#include "../include/swsoundcodes.h"	/* Default sound codes. */

#include "../include/osw-x.h"
#include "../include/widget.h"		/* Widget system and OSW. */


/*
 *	Program name and version:
 */
#define PROG_NAME	"XShipWars"
#define PROG_VERSION	"1.32"

#define PROG_VERSION_MAJOR	1
#define PROG_VERSION_MINOR	32


/*
 *	Usage information:
 */
#define PROG_USAGE_MESSAGE "\
Usage: xsw [url] [options] [GUI_options]\n\
\n\
    [url] is the URL to the universe that you want to connect to.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --rcfile <file>         Load configuration from <file>.\n\
        -f                      Same as --rcfile.\n\
        --control <type>        Specify which controller to use:\n\
                                   keyboard\n\
                                   joystick\n\
        -c                      Same as --control.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    Most customizations can be performed in the options menu.\n\
\n\
    Command line options override any options in the\n\
    configuration file.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult\n\
    your GUI's manual for available options.\n\
\n"

   
/*
 *	Copyright information:
 */
#define PROG_COPYRIGHT "\
Copyright (C) 1997, 1998, 1999, 2000 WolfPack Development Organization."


/*
 *	Debug message footer:
 */
#define XSW_DEBUG_FOOTER "\
\n\
*** If you recieved this message unexpectedly and/or the program has\n\
*** crashed, please e-mail the entire above debug message and steps\n\
*** that you can recall which resulted in this to:\n\
*** learfox@furry.ao.net\n\
***************************************************************************\n"



/*
 *	Default network interface maximum capacity (in bytes per second):
 */
#define DEF_NET_LOAD_MAX	1440


/*
 *   Prompt Limits:
 *
 *	Buffer and number of history buffers for initializing of
 *	general prompt widgets.  These values are not and may differ
 *	from the defaults for the prompt widget.
 */
#define DEF_PROMPT_BUF_LEN	256	/* In bytes. */
#define DEF_PROMPT_HIST_BUFS	30


/*
 *   Allowable color reduction for XPM images:
 *
 *	0     = 0% Reduction allowed (not recommended).
 *	40000 = (Default).
 *	60000 = 100% Reduction allowed.
 */
#define DEF_COLORCLOSENESS	40000


/*
 *	Default Program Directories:
 *
 *	These are directories used by XShipWars, make sure that they actually
 *	exist.  These are only default values, they can be changed in the
 *	XSW_RCFILE or XSW_RCFILE_GLOBAL.
 */
#ifdef __WIN32__
#define DEF_XSW_TOPLEVEL_DIR   CWD_STR
#define DEF_XSW_IMAGES_DIR         CWD_STR"images"
#define DEF_XSW_SOUNDS_DIR         CWD_STR"sounds"
#define DEF_XSW_ETC_DIR                    CWD_STR
#define DEF_ETC_DIR                    CWD_STR
#define DEF_SW_SERVER_DIR          CWD_STR
#else
#define DEF_XSW_TOPLEVEL_DIR	"/usr/share/games/xshipwars"
#define DEF_XSW_IMAGES_DIR	"/usr/share/games/xshipwars/images"
#define DEF_XSW_SOUNDS_DIR	"/usr/share/games/xshipwars/sounds"
#define DEF_XSW_ETC_DIR		"/usr/share/games/xshipwars/etc"
#define DEF_ETC_DIR		"/etc"
#define DEF_SW_SERVER_DIR	"/home/swserv"
#endif


/*
 *	File name extensions and masks:
 */
#define FN_ISREF_EXT		".isr"		/* Image set referances. */
#define FN_ISREF_EXT_MASK	"*.isr"

#define FN_OCSN_EXT		".ocsn"		/* Obj create script names. */
#define FN_OCSN_EXT_MASK	"*.ocsn"

#define FN_SS_EXT		".ss"		/* Sound scheme. */
#define FN_SS_EXT_MASK		"*.ss"


/*
 *	Default configuration file location:
 *
 *	Default parent for DEF_XSW_RCFILE is user's home directory.
 *	Default parent for DEF_XSW_RCFILE_GLOBAL is /usr/share/games/xshipwars/etc.
 */
#define DEF_XSW_RCFILE			".xshipwarsrc"
#define DEF_XSW_RCFILE_GLOBAL		"xshipwarsrc"

/*
 *	Default main menu file location:
 *
 *	Default parent is /usr/games/xshipwars/etc/.
 */
#define DEF_XSW_MAIN_MENU_CONF_FILE	"mainmenu.conf"

/*
 *	Default log file location:
 *
 *	Default parent is user's home directory.
 */
#define DEF_XSW_LOG_FILE		"xsw.log"

/*
 *	Default OCSNs file location:
 *
 *	Default parent is /usr/games/xshipwars/etc/.
 */
#define DEF_XSW_OCSN_FILE		"default.ocsn"

/*
 *	Default ISRefs file location:
 *
 *	Default parent is /usr/games/xshipwars/images/.
 */
#define DEF_XSW_ISREF_FILE		"default.isr"

/*
 *	Default sound scheme file location:
 *
 *	Default parent is /usr/games/xshipwars/sounds/.
 */
#define DEF_XSW_SOUND_SCHEME_FILE	"default.ss"


/*
 *	Joystick Default File Names:
 *
 *	Modify the appropriate section for your OS as needed.
 *	These must be defined here (globally) as many functions
 *	need to know these values.
 *
 *	The DEF_JS_CALIBRATION_FILE is searched for in the user's
 *	home dir.
 */
#ifdef JS_SUPPORT

# ifdef __linux__
#  define DEF_JS_CALIBRATION_FILE	".joystick"
#  define DEV_JOYSTICK1			"/dev/js0"
#  define DEV_JOYSTICK2			"/dev/js1"
#  define DEV_JOYSTICK3			"/dev/js2"
#  define DEV_JOYSTICK4			"/dev/js3"
# endif /* __linux__ */

# ifdef __HPUX__
# endif /* __HPUX__ */

#endif /* JS_SUPPORT */


/*
 *	Sound Server Defaults:
 */
#define DEF_SOUND_SERVER_START_CMD	"/usr/sbin/yiff"
#define DEF_SOUND_SERVER_CONNECT_ARG	"127.0.0.1:9433"

#define DEF_SOUND_SERVER_SAMPLE_SIZE		8
#define DEF_SOUND_SERVER_CHANNELS		1
#define DEF_SOUND_SERVER_SAMPLE_RATE		11025
#define DEF_SOUND_SERVER_BYTES_PER_SECOND	11025

#define DEF_SOUND_SERVER_CYCLE			80000	/* In microseconds. */
#define DEF_SOUND_SERVER_BYTES_PER_CYCLE	1024
#define DEF_SOUND_SERVER_DEF_FLIP_STEREO	0


#ifdef Y_H
# define DEF_YIFF_AUDIO_MODE_NAME	"Default"
#endif


/*
 *	Default Server Address:
 *
 *	This is the default server address and port to connect to when
 *	no address is given at the command line or in the configuration
 *	file.
 */
#define DEF_SWSERV_ADDRESS   "localhost"
#define DEF_SWSERV_PORT      1701


/*
 *	Default anonymous/guest/observer login values:
 */
#define DEF_GUEST_LOGIN_NAME		"Guest"
#define DEF_GUEST_LOGIN_PASSWORD	"guest"

/*
 *	Default URL used for a newly created universe entry:
 */
#define DEF_UNIV_URL	"swserv://Guest:guest@localhost:1701"


/*
 *	XSW Procedure Codes:
 *
 *	Numeric values to identify which major procedure functions
 *	to call. These codes are often reffered to as op_code or
 *	actions.
 *
 *	Ie: Used in the main menu's labels and the quick
 *	menu entries.
 */
#define XSW_ACTION_NONE			0

/* Load files and run server. */
#define XSW_ACTION_RUN_SERVER		10
#define XSW_ACTION_LOAD_OCSN		11
#define XSW_ACTION_LOAD_ISREF		12
#define XSW_ACTION_LOAD_SS		13
#define XSW_ACTION_SERVER_SCRIPT	14

/* Network actions. */
#define XSW_ACTION_CONNECT		100
#define XSW_ACTION_CONNECT_LAST		101
#define XSW_ACTION_REFRESH		102
#define XSW_ACTION_AINT			103	/* Auto interval toggle. */
#define XSW_ACTION_DISCONNECT		104

/* Game play controls. */
#define XSW_ACTION_SHIELDS		200
#define XSW_ACTION_CLOAK		201
#define XSW_ACTION_DMGCTL		202
#define XSW_ACTION_WLOCKNEXT		203
#define XSW_ACTION_WUNLOCK		204

/* Systems and display. */
#define XSW_ACTION_SYNCTIME		301
#define XSW_ACTION_DISPLABELS		302	/* Vs label cycle. */
#define XSW_ACTION_MEMORY		303
#define XSW_ACTION_OPTIONS		304	/* Map options win. */
#define XSW_ACTION_EDIT_KEYMAP		305	/* Map keymap win. */
#define XSW_ACTION_COMFERM_EXIT		306	/* Ask before exiting. */
#define XSW_ACTION_EXIT			307	/* Exit. */
#define XSW_ACTION_ECONOMY		308	/* Map economy win. */
#define XSW_ACTION_EDIT_JSMAP		309	/* Map jsmap win. */

/* To server commands. */
#define XSW_ACTION_WHO			401
#define XSW_ACTION_NETSTAT		402
#define XSW_ACTION_RMEMORY		403	/* Not XSW_ACTION_MEMORY. */



/*
 *	XSW Images Codes:
 *
 *	IMPORTANT: These codes are NOT Image Set Referance numbers!
 *
 *	These are base images codes used soly by the client for
 *	its various internal images.
 */
/* Desktop icons. */
#define IMG_CODE_XSW_ICON		1
#define IMG_CODE_ECONOMY_ICON		2
#define IMG_CODE_UNIV_ICON		3	/* Not the list item icons. */
#define IMG_CODE_OPTIONS_ICON		4

/* Cursors and marks. */
#define IMG_CODE_VSMARK_OBJECT		10
#define IMG_CODE_VSMARK_VESSEL		11
#define IMG_CODE_VSMARK_INCOMINGFIRE	12	/* Incomming fire. */

#define IMG_CODE_VS_WEP_PROJECTILE	13
#define IMG_CODE_VS_WEP_PULSE		14
#define IMG_CODE_VS_WEP_STREAM		15

#define IMG_CODE_SCMARK_UNKNOWN		16
#define IMG_CODE_SCMARK_LOCKED		17
#define IMG_CODE_SCMARK_WEAPON		18
#define IMG_CODE_SCMARK_HOME		19
#define IMG_CODE_SCMARK_AREA		20

/* Icons. */
#define IMG_CODE_UNIV_STD_ICON		30
#define IMG_CODE_UNIV_HASLOGIN_ICON	31
#define IMG_CODE_UNIV_OLD_ICON		32
#define IMG_CODE_UNIV_UNKNOWN_ICON	33
#define IMG_CODE_ERROR_ICON		34
#define IMG_CODE_INFO_ICON		35

/* Startup splash background. */
#define IMG_CODE_STARTUP_BKG		40
#define IMG_CODE_STARTUP_PB_L		41
#define IMG_CODE_STARTUP_PB_R		42
#define IMG_CODE_STARTUP_PB_T		43

/* Consoles. */
#define IMG_CODE_STATS_CON1		50	/* Bridge consoles. */
#define IMG_CODE_STATS_CON2		51
#define IMG_CODE_STATS_CON3		52
#define IMG_CODE_STATS_CON4		53
#define IMG_CODE_SCANNER		54	/* Scanner background. */
#define IMG_CODE_SRO_CON1		55
#define IMG_CODE_SRO_CON2		56
#define IMG_CODE_SRO_CON3		57
#define IMG_CODE_MESG_CON		58

/* Console decorations. */
#define IMG_CODE_BPANEL_OL_HULL		70
#define IMG_CODE_BPANEL_OL_POWER	71
#define IMG_CODE_BPANEL_OL_VIS		72
#define IMG_CODE_BPANEL_OL_SHIELDS	73
#define IMG_CODE_BPANEL_OL_DMGCTL	74

#define IMG_CODE_BPANEL_OL_LTHROTTLE	75
#define IMG_CODE_BPANEL_OL_RTHROTTLE 	76

#define IMG_CODE_BPANEL_OL_THRUSTVECTOR	77

/* Large message window background. */
#define IMG_CODE_MESG_SCR_BKG           90

/* Banners and labels. */
#define IMG_CODE_ENERGY_SAVER_MODE	100

/* Misc. */
#define IMG_CODE_LENSFLARE1		120
#define IMG_CODE_LENSFLARE2		121

#define IMG_CODE_STROBEGLOW1		122


/*      
 *   Server Object Update Send Interval:
 *
 *      In milliseconds. These are the minimum and maximum object updates
 *      intervals that we can request of the server to send us object
 *	updates.   The server code's minimum and maximum update intervals
 *	settings will override these minimum and maximum settings.
 *
 *	* These settings should match the server's default settings! *
 */
#define MIN_SERVER_UPDATE_INT	25
#define MAX_SERVER_UPDATE_INT	5000
#define SERVER_DEF_INT		1000


/*
 *   Auto Interval Update Interval:
 *
 *	When `auto interval tunning' is on, then it is performed
 *	every this many milliseconds.
 *
 *	The value should always be 1000 milliseconds (1 second).
 */
#define AINT_DEF_TUNE_INT	1000


/*
 *   Object Assume Outdated Timeout:
 *
 *	Objects that have not been updated by network data from the
 *	server for this many milliseconds will not be drawn.
 *
 *	However the object will not be recycled.
 */
#define OBJECT_OUTDATED_TIMEOUT		6000


/*
 *   Maximum object create script name entries:
 *
 *	Do not confuse this with object create scripts on the server.
 *
 *	See the ocs_struct farter below.
 */
#define OCSN_MAX	500




/* ******************************************************************** */

/*
 *   Timming Intervals:
 *
 *	In milliseconds. These are various intervals to perform
 *	certain routine procedures.
 */
#define MEMORY_CLEAN_INTERVAL		150000		/* 2.5 minutes. */
#define CONSOLES_UPDATE_INTERVAL	5000


/*
 *	Client command maximum length:
 */
#define CLIENT_CMD_MAX		256


/*
 *	Prompt Modes:
 *
 *	These are codes to indicate which prompt mode XSW is in.
 *	0 means no prompt mode and that keys should be handled
 *	normally.
 *	THe global variable prompt_mode holds one of these codes
 *	to indicate to the various functions which prompt mode
 *	we are in.
 */
#define PROMPT_CODE_NONE	0
#define PROMPT_CODE_CONNECT	1
#define PROMPT_CODE_CLIENT_CMD	2
#define PROMPT_CODE_SERVER_CMD	3
#define PROMPT_CODE_MESSAGE	4
#define PROMPT_CODE_WEAPONFREQ	5
#define PROMPT_CODE_SHIELDFREQ	6
#define PROMPT_CODE_INTERCEPT	7
#define PROMPT_CODE_COM_CHANNEL	8
#define PROMPT_CODE_EXIT	9


/*
 *	Message buffer maximums:
 */
#define MESG_BUF_MAX_MESG_LEN		111	/* Characters. */
#define MESG_WIN_TOTAL_MESSAGES		250	/* Lines. */
#define MESG_WIN_COL_WRAP		110	/* Characters. */

/*
 *	Universe entry maximums:
 */
#define MAX_UNIVERSES			300
#define UNIV_MAX_ALIAS_LEN		128
#define UNIV_MAX_URL_LEN		MAX_URL_LEN
#define UNIV_MAX_COMMENT_LEN		256


/*
 *    General animation timmers codes:
 */
#define ANIM_TIMMER_GENERAL	0
#define ANIM_TIMMER_SHORTGLOW	1
#define ANIM_TIMMER_MEDIUMGLOW	2	/* Cursors, arrows. */
#define ANIM_TIMMER_LONGGLOW	3
#define ANIM_TIMMER_SHORTBLINK	4
#define ANIM_TIMMER_LONGBLINK	5

#define MAX_ANIM_TIMMERS	6	/* Must be GREATER than the highest
					 * ANIM_TIMMER code.
					 */

/*
 *	Global Animation Timmer Values:
 *
 *	These values are for internal global animation timmers,
 *
 *	Note: Values here have no affect on ISRef animated
 *	image sets.
 */
#define ANIM_TIMMER_MAXCOUNT_GENERAL		6
#define ANIM_TIMMER_MAXCOUNT_SHORTGLOW		4
#define ANIM_TIMMER_MAXCOUNT_MEDIUMGLOW		8
#define ANIM_TIMMER_MAXCOUNT_LONGGLOW		12
#define ANIM_TIMMER_MAXCOUNT_SHORTBLINK		2
#define ANIM_TIMMER_MAXCOUNT_LONGBLINK		2


/*
 *	Scanner Orientations:
 *
 *	Set in bridge_win.scanner_orient.
 */
#define SCANNER_ORIENT_GC	0
#define SCANNER_ORIENT_LOCAL	1


/*
 *	Controller Types:
 *
 *	Set in options.controller.
 */
#define CONTROLLER_KEYBOARD             0
#define CONTROLLER_JOYSTICK		1
#define CONTROLLER_POINTER		2	/* Not supported yet. */


/*
 *	Throttle Scope Modes:
 *
 *	Used for interpriting the y axis of the joystick when
 *	the controller is a joystick.
 *
 *	Set in options.throttle_mode.
 */
#define THROTTLE_MODE_NORMAL		0
#define THROTTLE_MODE_BIDIRECTIONAL	1
#define THROTTLE_MODE_INCREMENTAL	2



/* ***************************************************************** */

/*
 *	Main parent process ID:
 */
extern pid_t root_pid;


/*
 *      Runlevel:
 *      
 *      The main while() loop in function main() checks to see if runlevel
 *      is 2 or greater.   If runlevel drops to 1 or less, then the loop
 *      breaks and the program should exit.
 *
 *      0 = Shutting down.
 *      1 = Starting up.
 *      2 = Normal running.
 */
extern int runlevel;


/*
 *	Current time since midnight in milliseconds:
 */
extern long cur_millitime;

/*
 *	Current systime seconds:
 */
extern time_t cur_systime;


/*
 *	Lapsed MilliTime:
 *
 *	In milliseconds, the time it took the previous loop to execute.
 *	This is compared to CYCLIC_MILLITIME_LAPSE (#defined in reality.h)
 *	to adjust for time lost in the last loop.
 */
extern long lapsed_millitime;


/*
 *	Time Compensation:
 *
 *	This value is always in the range of 1.0 to <big number>.
 *	It is used as the coefficent to various momentum and movement
 *	calculations to compensate for lost time in the previous
 *	loop.
 */
extern double time_compensation;


/*
 *	Prompt Mode:
 *
 *	Indicates which prompt mode we are in so key events are handled
 *	correctly.   0 means we are not in any prompt mode.
 */
extern int prompt_mode;


/*
 *	Global debug values:
 *
 *	Used for run time debugging.
 */
#define DEBUG_LEVEL_NONE	0
#define DEBUG_LEVEL_ALL		1
#define DEBUG_LEVEL_MEMORY	2
#define DEBUG_LEVEL_NETWORK	3

typedef struct {

	int level;	/* One of DEBUG_LEVEL_* */
	double val;

} xsw_debug_struct;
extern xsw_debug_struct debug;


/*
 *	Options:
 */
#define XSW_SOUNDS_NONE		0
#define XSW_SOUNDS_EVENTS	1
#define XSW_SOUNDS_ENGINE	2
#define XSW_SOUNDS_ALL		3

#define XSW_UNITS_XSW		0	/* XSW Internal units. */
#define XSW_UNITS_METRIC	1	/* AstroMetric. */
#define XSW_UNITS_ENGLISH	2	/* Universal English. */

typedef struct {

	/* RC file versions. */
	int	rc_version_major,
		rc_version_minor;

	/* Units, one of XSW_UNITS_*. */
	int units;

	/* Async (passive) image loading? */
	char async_image_loading;

	/* Max pixels to load per loop. */
	int async_image_pixels;


	/* Log options. */
	char	log_client,
		log_net,
		log_errors;

	/* Redraw viewscreen, scanner, etc asyncronusly? */
	char async_redraws;


	/* Show superimposed viewscreen markings. */
	char show_viewscreen_marks;

	/*   Amount of viewscreen labeling:
	 *
	 *   0 = nothing.
         *   1 = labels.
         *   2 = network stats.
         *   3 = labels and network stats.
         */
	char show_viewscreen_labels;

	/* Viewscreen effects graphics. */
	char show_lens_flares;
	char show_strobe_glow;
	char show_nebula_glow;

	/*   Show object labels in formal format:
	 *
	 *   0 = never.
	 *   1 = as needed.
	 *   2 = always.
	 */
	char show_formal_label;

	/* Show network errors (undicipherable network data)? */
	char show_net_errors;

	/* Show server error message dialogs? */
	char show_server_errors;


	/* Update objects locally by predicting movement patterns. */
	char local_updates;


	/* Auto viewscreen zoom. */
	char auto_zoom;


	/* Sound level, one of XSW_SOUNDS_*. */
	char sounds;
	char music;	/* 0 for off, 1 for on. */


	/* Print event messages? */
	char display_events;

	/* Controller type, one of CONTROLLER_*. */
	char controller;
	char cmd_line_set_controller;

	/* Normal or bi-directional throttle control. */
	char throttle_mode;

#ifdef JS_SUPPORT
	/* Close joystick when bridge is out of focus? */
	char focus_out_js_close;
#endif /* JS_SUPPORT */


	/* Reduces CPU usage, good for idling. */
	char energy_saver_mode;


	/* Scanner range affected by enviroment? (set true, no cheating!) */
	char scanner_limiting;

	/* Notify when objects come into or leave scanner range? */
	char notify_scanner_contacts;


	/* Automatically map eco window as needed. */
	char auto_map_eco_win;

	/* Automatically map universe list window at startup. */
	char auto_map_univ_list_win;

	/* Save configuration on exit. */
	char save_on_exit;

} xsw_option_struct;
extern xsw_option_struct option;


/*
 *	Sound server type codes:
 */
#define SNDSERV_TYPE_NONE	0
#define SNDSERV_TYPE_YIFF	1
#define SNDSERV_TYPE_ESOUND	2
#define SNDSERV_TYPE_MIKMOD	3	/* Obsolete. */

#define SNDSERV_AUDIO_MODE_NAME_MAX	256	/* Should be enough. */

/*
 *      Sound server connection info:
 */
typedef struct {

	/* One of SOUND_SERVER_TYPE_ * */
	int server_type;

	/* Script file that starts sound server. */
        char start_cmd[PATH_MAX + NAME_MAX];

	/* Connection argument to connect to sound server. */
	char con_arg[MAX_URL_LEN];


	/*   Pointer to connection data (do not free, belongs to sound
	 *   server).  This pointer also serves as a marker to denote
	 *   if sound is initialized or not (not initialized if NULL).
	 */
	void *con_data;


	/*   Name of Audio mode that the sound server is to be in when
	 *   using current sound scheme (may not be applicatable to all
	 *   sound servers).
	 */
	char audio_mode_name[SNDSERV_AUDIO_MODE_NAME_MAX];


	/* Background sound play ID (NULL if none is being played). */
	void *bkg_playid;

	/* Background mood code, one of SOUND_CODE_BKG_*. */
	int bkg_mood_code;

} xsw_sound_struct;
extern xsw_sound_struct sound;


/*
 *   Directory names:
 *
 *	All values MUST be complete absolute paths.
 */
typedef struct {

	char startup[PATH_MAX];		/* Startup dir. */
	char toplevel[PATH_MAX];	/* XSW's toplevel dir. */
	char etc[PATH_MAX];		/* Configuration dir. */
	char images[PATH_MAX];		/* Images dir. */
	char sounds[PATH_MAX];		/* Sounds dir. */
	char downloads[PATH_MAX];	/* Screen shot dir. */

} xsw_dname_struct;
extern xsw_dname_struct dname;


/*
 *   File names:
 *
 *	Must be a absolute full path to the file.
 */
typedef struct {

    char rc[NAME_MAX + PATH_MAX];		/* RC file. */

#ifdef JS_SUPPORT
    char js_calib[NAME_MAX + PATH_MAX];		/* Joystick caliberation file. */
#endif /* JS_SUPPORT */

    char sound_scheme[NAME_MAX + PATH_MAX];	/* Sound scheme. */

    char main_menu_conf[NAME_MAX + PATH_MAX];
    char ocsn[NAME_MAX + PATH_MAX];		/* Object create script names. */
    char isr[NAME_MAX + PATH_MAX];		/* Imageset referances file. */

    char log[NAME_MAX + PATH_MAX];		/* Log file. */

} xsw_fname_struct;
extern xsw_fname_struct fname;


/*
 *   Next event scheduals:
 *
 *	Marks the next time in milliseconds that something
 *	is to be performed.
 */
typedef struct {

    long	update_check,
		viewscreen,	/* Redraw viewscreen. */
		consoles,	/* Redraw some bridge panel consoles. */
		memory_clean,	/* Reclaim memory. */
		lplayer_pos_send;	/* Next send player position. */

} xsw_next_struct;
extern xsw_next_struct next;


/*
 *   FPS Counter:
 *
 *	Record for keeping track of the frames drawn per second
 *	on the viewscreen.
 */
typedef struct {

	int	fcount,		/* Frames drawn counter. */
		lfcount;	/* Frames drawn last time. */

	long interval;		/* Should always be 1000 milliseconds. */
	long next;		/* In milliseconds. */

} xsw_fps_counter_struct;
extern xsw_fps_counter_struct fps_counter;


/*
 *   Animation Timmer
 *
 *	Timming and frame records for various animation timmers.
 *	Each timmer has a code #defined above.   Each timmer will have
 *	a different number of frames and interval.
 */
typedef struct {

	int	count,
		count_max;

	long interval;		/* In milliseconds. */
	long next;		/* In milliseconds. */

} xsw_genanim_timmer_struct;
extern xsw_genanim_timmer_struct genanim_timmer[MAX_ANIM_TIMMERS];


/*
 *   Fonts:
 *
 *	Allocated GUI fonts.
 */
typedef struct {

	/* All purpose fonts. */
	font_t	*std,
		*std_bold;

	/* Bridge console panel fonts. */
	font_t  *console_heading,
		*console_standard,
		*console_message;

} xsw_font_struct;
extern xsw_font_struct xsw_font;


/*
 *   Colors:
 *
 *	Allocated GUI color pixels and their values.
 *
 *	RGB values are stored in WColorStruct structures, they
 *	are members denoted with _cv postpended to their name.
 */
typedef struct {

	/* Standard text colors. */
	pixel_t		standard_text,
			bold_text,
			withdrawn_text;

	WColorStruct	standard_text_cv,
			bold_text_cv,
			withdrawn_text_cv;


	/* Bridge console panel readout colors. */
	pixel_t		bp_standard_text,
			bp_bold_text,
			bp_withdrawn_text,	/* Disabled. */

			bp_light_outline,
			bp_normal_outline,
			bp_dark_outline;

        WColorStruct    bp_standard_text_cv,
                        bp_bold_text_cv,
                        bp_withdrawn_text_cv,

			bp_light_outline_cv,
			bp_normal_outline_cv,
			bp_dark_outline_cv;

	/* Warning, danger, and critical colors. */
	pixel_t		bp_warning,
			bp_danger,
			bp_critical;

	WColorStruct	bp_warning_cv,
			bp_danger_cv,
			bp_critical_cv;

	/* Bridge console panel readout outline colors. */
	pixel_t		bpol_hull,
			bpol_power,
			bpol_vis,
			bpol_shields,
			bpol_dmgctl,
			bpol_throttle,
			bpol_throttle_rev;

	WColorStruct	bpol_hull_cv,
			bpol_power_cv,
			bpol_vis_cv,
			bpol_shields_cv,
			bpol_dmgctl_cv,
			bpol_throttle_cv,
			bpol_throttle_rev_cv;

	/* Viewscreen labels (no corresponding pixel value). */
	WColorStruct	vs_label_bg_cv,
			vs_label_fg_cv;


	/* Scanner mark colors. */
	pixel_t		scmark_unknown,		/* Most objects. */
			scmark_locked,
			scmark_weapon,
			scmark_home,
			scmark_area;

	WColorStruct	scmark_unknown_cv,
			scmark_locked_cv,
			scmark_weapon_cv,
			scmark_home_cv,
			scmark_area_cv;

	/* Keymap edit window. */
	pixel_t		keymap_query_bg,
			keymap_query_fg;

	WColorStruct	keymap_query_bg_cv,
			keymap_query_fg_cv;


	/* Viewscreen graphics colors (no corresponding pixel value). */
	WColorStruct	heading_arrow,
                        lock_arrow,
                        lock_cursor,
                        stream_green,
                        stream_yellow,   
                        stream_purple,
                        stream_orange,
                        shield_blue,
			visibility_marker,
                        star_glow;

} xsw_color_struct;
extern xsw_color_struct xsw_color;


/*
 *    XSW Cursors:
 *
 *	Allocated GUI cursors.
 */
typedef struct {

	WCursor	*scanner_lock,
		*text,
		*wait;

} xsw_cursor_struct;
extern xsw_cursor_struct xsw_cursor;

/*
 *   XSW Image Label Type:
 *
 *	General purpose image label structure
 *	(used in the main menu, see xsw_main_menu_label_struct).
 */
typedef struct {

	char *filename;

	char pos_by_percent;	/*   If true, coordinates are calculated
                                 *   by percent.
                                 */
	char size_by_percent;	/*   If true, size is calculated by
                                 *   percent.
                                 */

	int x, y;		/*   If pos_by_percent is true, this is
                                 *   in percent.
                                 */
	image_t *image;

} xsw_imglabel_struct;


/* ********************************************************************* */

/*
 *	XSW Main Menu structure:
 */
#define MAIN_MENU_MAX_LABELS	3
typedef struct {

	char map_state;
	char allow_transparency;
	int op_code;			/* One of XSW_ACTION_* */

	xsw_imglabel_struct imglabel[MAIN_MENU_MAX_LABELS];

	char *hint_mesg;

} xsw_main_menu_label_struct;

typedef struct {

	char map_state;
	int x, y;
	unsigned int width, height;
	char is_in_focus;
	visibility_t visibility_state;

	/* Background image. */
	char *bg_filename;
	image_t *bg_image;
	int bg_image_draw_code;		/* One of MM_BKG_DRAW_* */

	/* Selected label information. */
	int sel_label;	/* -1 for none. */
	int sel_label_state;	/* One of MM_LABEL_STATE_* */

	/* Label and action codes. */
	xsw_main_menu_label_struct **label;
	int total_labels;

} xsw_main_menu_struct;



/*
 *	Bridge window button position structure.
 */
typedef struct {

	int x, y;
	unsigned int width, height;

} bpanel_btnpos_struct;

/* Button position codes. */
#define BPANEL_BTNPOS_PSHIELDFREQ_UP	1
#define BPANEL_BTNPOS_PSHIELDFREQ_DOWN	2
#define BPANEL_BTNPOS_PWEAPONFREQ_UP	3
#define BPANEL_BTNPOS_PWEAPONFREQ_DOWN	4
#define BPANEL_BTNPOS_PCOMCHANNEL_UP	5
#define BPANEL_BTNPOS_PCOMCHANNEL_DOWN	6

#define BPANEL_BTNPOS_PSHIELDS		7
#define BPANEL_BTNPOS_PCLOAK		8
#define BPANEL_BTNPOS_PDMGCTL		9

#define BPANEL_BTNPOS_PINTERCEPT	10
#define BPANEL_BTNPOS_PLOCK		11
#define BPANEL_BTNPOS_PLOCKNEXT		12

#define BPANEL_BTNPOS_PSELWEP1		13
#define BPANEL_BTNPOS_PSELWEP2		14
#define BPANEL_BTNPOS_PSELWEP3		15
#define BPANEL_BTNPOS_PSELWEP4		16

#define BPANEL_BTNPOS_PENGINESTATE	20


#define BPANEL_TOTAL_BTNPOS	21
bpanel_btnpos_struct **bpanel_btnpos;
int total_bpanel_btnpos;


/* Viewscreen zoom ranges. */
#define VS_ZOOM_MIN 0.3
#define VS_ZOOM_MAX 1.0		/* Must not be greater than 1. */
#define VS_ZOOM_INC 0.005


/* Bridge console panel codes. */
#define BPANEL_DETAIL_ALL		0

#define BPANEL_DETAIL_P1		1
#define BPANEL_DETAIL_P2		2
#define BPANEL_DETAIL_P3		3
#define BPANEL_DETAIL_P4		4

#define BPANEL_DETAIL_S1		5
#define BPANEL_DETAIL_S2		6
#define BPANEL_DETAIL_S3		7

#define BPANEL_DETAIL_PNAME		20
#define BPANEL_DETAIL_PSHIELDFREQ	21
#define BPANEL_DETAIL_PWEAPONFREQ	22
#define BPANEL_DETAIL_PCOMCHANNEL 	23

#define BPANEL_DETAIL_PHULL	30
#define BPANEL_DETAIL_PPOWER	31
#define BPANEL_DETAIL_PSHIELDS	32
#define BPANEL_DETAIL_PVIS	33
#define BPANEL_DETAIL_PDMGCTL	34

#define BPANEL_DETAIL_SNAME	40
#define BPANEL_DETAIL_SHULL	41
#define BPANEL_DETAIL_SPOWER  	42
#define BPANEL_DETAIL_SSHIELDS	43
#define BPANEL_DETAIL_SVIS	44
#define BPANEL_DETAIL_SBEARING	45
#define BPANEL_DETAIL_SDISTANCE	46
#define BPANEL_DETAIL_SDMGCTL	47

#define BPANEL_DETAIL_PINAME	50
#define BPANEL_DETAIL_PWLOCK	51
#define BPANEL_DETAIL_PWEAPONS	52

#define BPANEL_DETAIL_SINAME	60
#define BPANEL_DETAIL_SWLOCK	61
#define BPANEL_DETAIL_SWEAPONS	62

#define BPANEL_DETAIL_SANTIMATTER	63
#define BPANEL_DETAIL_SHEADING		64	/* And coordinates. */

#define BPANEL_DETAIL_PTHROTTLE		70
#define BPANEL_DETAIL_PVELOCITY		71
#define BPANEL_DETAIL_PANTIMATTER	72
#define BPANEL_DETAIL_PENGINESTATE	73
#define BPANEL_DETAIL_PHEADING		74	/* And coordinates. */
#define BPANEL_DETAIL_PTHRUSTVECTOR	75

/*
 *	Bridge window structure:
 */
typedef struct {

	char map_state;
	int x, y;
	unsigned int width, height;
	char is_in_focus;
	visibility_t visibility_state;

	int preset_zoom_code;	/* Current preset zoom code. */

	/* Toplevel. */
	win_t toplevel;

	/* Viewscreen. */
	char viewscreen_map_state;
        win_t viewscreen;
        shared_image_t *viewscreen_image;
        unsigned int viewscreen_width, viewscreen_height;
        visibility_t viewscreen_vis_state;      /* Visibility state. */
        double viewscreen_gamma;
        long viewscreen_int;	/* Redraw interval in milliseconds. */
        double viewscreen_zoom;	/* Zoom coeff. */

        /* Selected weapon on viewscreen image. */
        image_t *vs_weapon_image;   
        pixmap_t vs_weapon_buf;
        unsigned int vs_weapon_width, vs_weapon_height;

        /* Netstats label on viewscreen. */
        image_t *net_stats_image;
        pixmap_t net_stats_buf;
        unsigned int net_stats_width, net_stats_height;

        /* Main menu. */
        xsw_main_menu_struct mm;


        /*   Buffer for console panels.  Since all are of same
	 *   size we can just use one buffer.
         */
        pixmap_t pan_buf;

	/*   Tempory image for drawing background for stats_con2 and
         *   sro_con1 (since it involves blitting an object on it).
	 */
	shared_image_t	*pan_p2_img,
			*pan_p3_img,

			*pan_s1_img,
			*pan_s3_img;


        /* Player stats console panels. */
	win_t	pan_p1,
		pan_p2,
		pan_p3,
		pan_p4;

	unsigned int	pan_p1_width,
			pan_p1_height,
			pan_p2_width,
			pan_p2_height,
			pan_p3_width,
			pan_p3_height,
			pan_p4_width,
			pan_p4_height;

        /* Scanner. */
        char scanner_map_state;
        win_t scanner;
        shared_image_t *scanner_image;
        unsigned int scanner_width, scanner_height;
	visibility_t scanner_vis_state;
        double scanner_zoom;
        char scanner_orient;
        scale_bar_struct scanner_sb;         /* Scanner scale bar. */

	image_t	*scanner_range_label,
		*scanner_loc_label;

        /* Scanner readout console. */
	win_t	pan_s1,
		pan_s2,
		pan_s3;
	unsigned int	pan_s1_width,
			pan_s1_height,
			pan_s2_width,
			pan_s2_height,
			pan_s3_width,
			pan_s3_height;


        /* Message box. */
        win_t mesg_box;
        pixmap_t mesg_box_buf;
	int	mesg_box_x,
		mesg_box_y;
	unsigned int	mesg_box_width,
			mesg_box_height;
        int line_spacing;
        scroll_bar_struct mesg_box_sb;

        /* Prompt. */
        prompt_window_struct prompt;

} xsw_bridge_win_struct;
extern xsw_bridge_win_struct bridge_win;

/* Large message window. */
typedef struct {

	char map_state;
	int x, y;
	unsigned int width, height;
	char is_in_focus;
	visibility_t visibility_state;

	win_t toplevel;
	pixmap_t toplevel_buf;

	int line_spacing;

	scroll_bar_struct scroll_bar;

	prompt_window_struct prompt;

} xsw_lg_mesg_win_struct;
extern xsw_lg_mesg_win_struct lg_mesg_win;


/*
 *    Quick menu:
 *
 *	This should be moved to the bridge window structure.
 */
typedef struct {

	menu_struct menu;

} xsw_qmenu_struct;
extern xsw_qmenu_struct qmenu;

/* 
 *    Economy buy and sell window:
 */
typedef struct {

 	char map_state;
 	int x, y;
 	unsigned int width, height;
 	char is_in_focus;
 	visibility_t visibility_state;
 	bool_t disabled;


	long proprietor_obj;

	prompt_window_struct	proprietor_prompt;

        win_t toplevel;
        pixmap_t toplevel_buf;

	push_button_struct	refresh_btn;

	colum_list_struct	inventory;

	prompt_window_struct	amount_prompt;

	push_button_struct	buy_btn,
				sell_btn,
				close_btn;

} xsw_eco_win_struct;
extern xsw_eco_win_struct eco_win;


/* All purpose error dialog. */
extern dialog_win_struct err_dw;

/* All purpose info dialog. */
extern dialog_win_struct info_dw;


/*
 *   Primary file browser:
 */
extern fbrowser_struct pri_fbrowser;
extern int pri_fb_loadop;		/* Load operation. */

#define PRI_FB_LOADOP_NONE		0	/* Do nothing. */
#define PRI_FB_LOADOP_RUN_SERVER	1
#define PRI_FB_LOADOP_OCSN		2
#define PRI_FB_LOADOP_ISREF		3
#define PRI_FB_LOADOP_SS		4	/* Sound scheme. */
#define PRI_FB_LOADOP_SERVER_SCRIPT	10	/* Server commands script. */



/*
 *	XSW Images:
 *
 *	Images used internally by the program.
 *
 *	IMPORTANT: These are not Image Set Referance numbers.
 */
typedef struct {

	char load_state;	/* 0 = not loaded, 1 = loaded. */

	char *filename;
	image_t *image;

} xsw_image_struct;
extern xsw_image_struct **xsw_image;

extern int total_images;


/*
 *	Primary Message Buffer:
 *
 *	For server and local program output messages.
 *
 *	The messages here are displayed on the large message window
 *	and on the bridge window's message box.
 */
typedef struct {

	/* Message. */
	char message[MESG_BUF_MAX_MESG_LEN];

	/* Color of message. */
	pixel_t pixel;

	/* Selection mark positions, can be -1. */
	int	sel_start,
		sel_end;

} xsw_pri_mesg_buf_struct;
extern xsw_pri_mesg_buf_struct pri_mesg_buf[MESG_WIN_TOTAL_MESSAGES];


/*
 *   Quick Menu Items:
 *
 *	This is a list of entries loaded from the rc file to define
 *	the each quick menu item.
 *
 *	The menu items are listed in order from top (item #0) to
 *	bottom (last item).
 *
 *	If total_qmenu_entries is 0, then the quick menu will be
 *	defaulted.
 */
typedef struct {

	char *name;		/* Entry name. */
	int type;		/* Entry item type. */

	image_t *ximage;	/* No sharing! */
	int op_code;		/* One of XSW_ACTION_* */

} qmenu_entry_struct;
extern qmenu_entry_struct **qmenu_entry;

extern int total_qmenu_entries;


/*
 *    Program memory stat structure:
 */
typedef struct {

	/* Memory used. */
	long	total,
		gui,
		sound,
		images,		/* Not counting isrefs. */
		univ_entries,
		objects,
		isrefs,
		ocsns,
		vs_labels,	/* Viewscreen labels. */
		scanner_contacts;

} xsw_mem_stat_struct;


/*
 *    In range objects list:
 *
 *	Array containing pointers to objects that are in range
 *	of player.
 */
extern xsw_object_struct **inrange_xsw_object;
extern int total_inrange_objects;


/*
 *   Local Player Object Number:
 *
 *	Contains the number for the local player object.
 *	All local redraws and inputs are relative to this object.
 */
extern long lplayer_object;


/*
 *   Object label images:
 *
 *	These label images are displayed next to objects on
 *	the bridge window's viewscreen.
 */
typedef struct
{
	/* Label image. */
	image_t *image;

	/* Pointer to object (so we know which one this belongs to). */
	xsw_object_struct *obj_ptr;

} vs_object_label_struct;
extern vs_object_label_struct **vs_object_label;

extern int total_vs_object_labels;


#ifdef JS_SUPPORT
/*
 *	Joystick mapping configuration:
 *
 *	Not to be confused with the game controller state structure 
 *	gctl_struct.
 */
#define JSMAP_AXIS_OP_NONE		-1
#define JSMAP_AXIS_OP_TURN		0
#define JSMAP_AXIS_OP_THROTTLE		1
#define JSMAP_AXIS_OP_THRUST_DIR	2
#define JSMAP_AXIS_OP_SCANNER_ZOOM	10
#define JSMAP_AXIS_OP_VS_ZOOM		11

typedef struct {

	int op_code;	/* Specifies what this axis controls. */

} jsmap_axis_struct;

typedef struct {

	keycode_t keycode;	/* Specfies the keycode generated by button. */
	bool_t state;

} jsmap_button_struct;

typedef struct
{
	char			*device_name;

#ifdef JSW_H
	js_data_struct		jsd;
#endif

	jsmap_axis_struct	**axis;
	int 			total_axises;

	jsmap_button_struct	**button;
	int 			total_buttons;

} jsmap_struct;

extern jsmap_struct **jsmap;
extern int total_jsmaps;	/* Also specifies total number of joysticks. */

#endif /* JS_SUPPORT */



/*
 *   Game controller values:
 *
 *	A wrapper for information about the game controller's current.
 *	states (such as joystick position, button states, etc).
 *
 *	The information here is fetched once per loop and functions
 *	use the information herein to tell what state the game controller
 *	is in regardless of what game controller is being used (keyboard,
 *	joystick, pointer, etc).
 */
typedef struct {

	double	turn,
		throttle,
		thrust_dir,	/* 0 is backwards. */
		vs_zoom,
		scanner_zoom;

	u_int8_t	fire_weapon,
			omni_dir_thrust,
			external_dampers;	/* Brakes. */

} xsw_gctl_struct;
extern xsw_gctl_struct gctl[1];


/*
 *   Local control settings:
 *
 *	Client emulated simulation values to enhance realism.
 *	This has no affect on what happens on the server.
 *
 *	Do not confuse this with the gctl_struct.
 */
typedef struct {

	char weapons_online;	/*   Acts as a safety trigger padlock,
                                 *   weapons won't fire if this is 0.
				 */
	double weapon_freq;

} xsw_local_control_struct;
extern xsw_local_control_struct local_control;

/*
 *   Warnings:
 *
 *	Warning markers for the player object.
 */
typedef struct {

        char weapons_lock;	/* Someone locked on us. */
        char incoming_fire;	/* Weapons fired at us. */

} xsw_warning_struct;
extern xsw_warning_struct warning;


/*
 *    Message Squelch:
 *
 *	In communication messages, any ship with the name
 *	matching any name in this list will not have its
 *	message displayed.
 */
extern char **message_squelch;
extern int total_message_squelches;


/*
 *   Sector legend:
 *
 *	Defines the sizes and bounds of each sector.
 *	All units are in XSW real units unless otherwise noted.
 */
typedef struct {

	double x_len, y_len, z_len;

        double x_min, x_max;
	double y_min, y_max;
	double z_min, z_max;

} xsw_sector_legend_struct;
extern xsw_sector_legend_struct sector_legend;

/*
 *   Scanner contacts:
 *
 *	List record of objects in scanner range.
 *
 *	Used to keep track of which objects have just entered
 *	or left sensor range.
 */
typedef struct {

	long object_num; 

} scanner_contacts_struct;
extern scanner_contacts_struct **scanner_contact;

extern int total_scanner_contacts;



/*
 *   Object Create Script Names:
 *
 *	For referancing an OCS type to a name. Purpose for these is
 *	only to provide a name for a type of OCS.
 *
 *	NOTE: This OCS structure differs with the OCS structure for
 *	the server is different!
 */
#define OCS_TYPE_GARBAGE	0
typedef struct
{
	int type;

	char name[XSW_OBJ_NAME_MAX];
	image_t *icon;

} ocsn_struct;
extern ocsn_struct **ocsn;

extern int total_ocsns;


/*
 *   Network Parameter Variables:
 */
#define CON_STATE_NOT_CONNECTED		0	/* Not connected. */
#define CON_STATE_NEGOTIATING		1	/* Logging in. */
#define CON_STATE_CONNECTED		2	/* Logged in. */

typedef struct {

	/* Connection state, one of CON_STATE_*. */
	char connection_state;

	/* Socket to server, -1 implies no socket and not connected. */
	int socket;

	/* Referances to player object, can be NULL. */
	long player_obj_num;
	xsw_object_struct *player_obj_ptr;

	/* Login name and password. */
	char login_name[XSW_OBJ_NAME_MAX];
	char login_password[XSW_OBJ_PASSWORD_MAX];

	/*   Address set level:
	 *
	 *   0 = not set.
         *   1 = set in config file.
	 *   2 = set at command line.
	 */
	int is_address_set;

	/* When connection was first established in systime seconds. */
	time_t con_start;

	/* Login delay warning records. */
	char	warn15,
		warn30,
		warn45;

	/* Login information reception check list. */
	char	login_got_lplayer,
		login_got_position,
		login_got_sector;

	/* Address and port number of connection to server. */
	char address[MAX_URL_LEN];
	int port;

	/*   Network stream sync refresh interval, in milliseconds.
	 *   Interval in which client data (such as local player
	 *   object positions) are sent to the server.
	 */
	long net_int;

	/* Times disconnect was sent. */
	int disconnect_send_count;

	/* Bad send() counter. */
	int bad_send_count;

	/*   Carry over data, data that is left over from
	 *   one recv() without a segment delimiter character
	 *   that is then put at the beginning of the next recv().
	 */
	char co_data[CS_DATA_MAX_LEN];
	int co_data_len;

} xsw_net_parms_struct;
extern xsw_net_parms_struct net_parms;


/*
 *   Load Monitoring:
 *
 *	The members in the struct loadstat and struct auto_interval_tune
 *	contain various network statistics in order for Auto Interval Tuning
 *	to work properly.
 */
typedef struct {

    long net_load_max;	/* Maximum bytes per 1000 milliseconds of 
			 * network connection.
			 * A 28.8k modem would have 3600. */
    long rx_interval;	/* Bytes recieved per 1000 milliseconds. */
    long sx_interval;	/* Bytes sent per 1000 milliseconds. */
    long rx_ilast;	/* Last bytes recieved per 1000 milliseconds. */
    long sx_ilast;      /* Last bytes sent per 1000 milliseconds. */

} xsw_loadstat_struct;
extern xsw_loadstat_struct loadstat;

/*
 *   Auto interval tuning:
 *
 *	Relies on information in loadstat.
 */
typedef struct {

    char state;		/* 0 = off, 1 = on. */

    long interval;	/* In milliseconds, should be exactly 1000. */

    long next;		/* Next update in milliseconds. */

} xsw_auto_interval_tune_struct;
extern xsw_auto_interval_tune_struct auto_interval_tune;


/*
 *	Server script upload structure:
 */
typedef struct {

	char *filename;
	FILE *fp;

	off_t filepos;
	off_t filesize;

	/* Arguments to substitute. */
	char **argv;
	int argc;

} serv_script_struct;
extern serv_script_struct **serv_script;
extern int total_serv_scripts;


/*
 *	Sound scheme item structure:
 */
typedef struct {

	char *path;

} ss_item_struct;
extern ss_item_struct **ss_item;
extern int total_ss_items;



/* ******************************************************************* */

/* In autointerval.c */
extern int AIntvTuneHandleAdjust(void);


/* In bridgedraw.c */
extern void BridgeWinDrawPanel(
        long obj_num,           /* Subject object. */
        int panel_detail        /* One of BPANEL_DETAIL_* */
);
extern void BridgeWinDrawAll(void);
extern int BridgeDrawMessages(void);

/* In bridgegui.c */
extern int BridgeWinInit(int argc, char *argv[]);
extern void BridgeWinResize(void);
extern void BridgeWinResizePreset(int step);
extern void BridgeWinMap(void);
extern void BridgeWinUnmap(void);
extern void BridgeWinDestroy(void);

/* In bridgemanage.c */
extern void BridgeMessagesMark(
        int start_x, int start_y,
        int end_x, int end_y
);
extern void BridgePrintSubjectStats(long object_num);
extern int BridgeManagePromptExec(event_t *event);
extern int BridgeManage(event_t *event);


/* In bridgescrshot.c */
extern int BridgeDoScreenShot(
	char *save_dir,
	int start_x, int start_y,
	int end_x, int end_y
);


/* In cmd*.c */
extern int CmdHandleInput(char *input);

extern int CmdAutoInterval(char *arg);
extern int CmdConnect(char *arg);
extern int CmdDebug(char *arg);
extern int CmdDisconnect(char *arg);
extern int CmdExit(char *arg);
extern int CmdHelp(char *arg);
extern int CmdLog(char *arg);
extern int CmdLoginName(char *arg);
extern int CmdLoginPassword(char *arg);
extern int CmdMemory(char *arg);
extern int CmdNetInterval(char *arg);
extern int CmdRefresh(char *arg);
extern int CmdServScript(char *arg);
extern int CmdSet(char *arg);
extern int CmdSynctime(char *arg);
extern int CmdTest(char *arg);
extern int CmdVersion(char *arg);


/* In db.c */
extern int DBIsObjectAllocated(long object_num);
extern int DBIsObjectGarbage(long object_num);

extern xsw_object_struct **DBAllocObjectPointers(
	xsw_object_struct **cur_obj_ptrs,
	long num_objects
);
extern xsw_object_struct *DBAllocObject(void);

extern long DBCreateObject(
            long imageset,
            long type,
            long owner,
            double x,
            double y,
            double z,
            double heading,
            double pitch,
            double bank
);
extern int DBCreateExplicitObject(
            long object_num,
            long imageset,
            long type,
            long owner,
            double x,
            double y,
            double z,
            double heading,
            double pitch,
            double bank
);
extern void DBDeleteObject(xsw_object_struct *obj_ptr);
extern void DBDeleteAllObjects(void);
extern void DBRecycleObject(long object_num);

extern void DBReclaim(void);


/* In dbinrange.c */
extern void DBInRangeUpdate(long object_num);
extern int DBInRangeAdd(long ref_obj, long tar_obj, char check_range);
extern void DBInRangeDelete(xsw_object_struct *obj_ptr);
extern void DBInRangeDeleteAll(void);


/* In dbmatch.c */
extern long MatchWeaponsLock(long ref_object, long start_object, double range);
extern long MatchInterceptByNumber(long ref_obj, long tar_obj);
extern long MatchIntercept(long object_num, char *arg);
extern long MatchObjectByName(char *name, int type);


/* In dbutil.c */
extern int DBCreateObjectWeapons(long object_num, int total_weapons);
extern int DBCreateObjectScores(long object_num);
extern int DBCreateObjectEconomy(long object_num);
extern int DBCreateObjectEconomyProduct(
	long object_num,
	char *product_name,
	xswo_credits_t sell_price,
	xswo_credits_t buy_price,
	double product_amount,
	double product_max
);

extern int DBObjectTractor(long src_obj, long tar_obj);
extern void DBObjectUntractor(long src_obj, long tar_obj);

extern int DBValidateObjectName(char *name);
extern int DBValidateObjectPassword(char *password);

extern long DBGetTopObjectNumber(void);
extern long DBGetObjectNumByPtr(xsw_object_struct *obj_ptr);
extern char *DBGetFormalNameStr(long object_num);
extern char *DBGetObjectVectorName(double theta);
extern double DBGetObjectVisibility(long object_num);
extern double DBGetObjectVisibilityPtr(xsw_object_struct *obj_ptr);

extern void DBSetPlayerObject(long object_num);


/* In dbobjgarbage.c */
extern void DBSetupGarbageObject(void);


/* In ecowin.c */
extern void EcoWinUnfocusPrompts(void);
extern int EcoWinDoAddInventory(
	long src_obj,
	long tar_obj,
	xsw_ecoproduct_struct product
);
extern void EcoWinDoDeleteInventory(void);

extern int EcoWinRefreshPBCB(void *ptr);
extern int EcoWinBuyPBCB(void *ptr);
extern int EcoWinSellPBCB(void *ptr);
extern int EcoWinClosePBCB(void *ptr);

extern int EcoWinInit(void);
extern int EcoWinResize(void);
extern int EcoWinDraw(void);
extern int EcoWinManage(event_t *event);
extern void EcoWinMap(void);
extern void EcoWinUnmap(void);
extern void EcoWinDestroy(void);


/* In images.c */
extern int IMGIsImageNumAllocated(int image_num);
extern int IMGIsImageNumLoaded(int image_num);

extern int IMGResize(
	int image_num,
	unsigned int width,
	unsigned int height
);
extern int IMGAllocateExplicit(int image_num);
extern int IMGLoadImage(int image_num, char *filename);
extern int IMGLoadImageData(int image_num, unsigned char *data);
extern void IMGUnload(int image_num);

extern int IMGDoLoadAll(void);
extern void IMGDoUnloadAll(void);


/* In imglabels.c */
extern int ImgLabelIsAllocated(xsw_imglabel_struct *label);
extern int ImgLabelIsLoaded(xsw_imglabel_struct *label);

extern xsw_imglabel_struct *ImgLabelAllocate(void);
extern void ImgLabelReset(xsw_imglabel_struct *label);
extern void ImgLabelDestroy(xsw_imglabel_struct *label);


/* In gctl.c */
extern int GCtlInit(int controller);
extern void GCtlUpdate(int controller_type);
extern void GCtlShutdown(void);


#ifdef JS_SUPPORT
/* In jsmap.c */
extern int JSMapIsAllocated(int n);
extern int JSMapAllocate();
extern void JSMapSyncWithData(jsmap_struct *jsm);
extern void JSMapDelete(int n);
extern void JSMapDeleteAll();
#endif /* JS_SUPPORT */


/* In isrefs.c */
extern int ISRefIsAllocated(int isref_num);
extern int ISRefIsLoaded(int isref_num);
extern void ISRefReset(int isref_num);
extern int ISRefCreateExplicit(int isref_num);
extern int ISRefLoadAsDefault(int isref_num);
extern int ISRefLoad(int isref_num);
extern void ISRefUnload(int isref_num);
extern void ISRefDelete(int isref_num);
extern void ISRefDeleteAll(void);
extern void ISRefReclaimMemory(void);
extern void ISRefManage(void);


/* In isrefsfile.c */
extern int ISRefLoadFromFile(char *filename);


/* In log.c */
extern int LogAppendLineFormatted(char *filename, char *str);


/* In main.c */
extern void XSWDoPrintDebug(void);
extern void XSWDoHelp(void);
extern void XSWDoVersion(void);
extern void XSWDoHelpMesgWin(void);
extern int XSWIsDescriptorValid(int s);
extern int XSWStartServer(char *cmd);
extern int XSWLoadOCSN(char *path);
extern int XSWLoadIsrefs(char *path);
extern int XSWLoadSS(char *path);
extern int XSWLoadColors(void);
extern void XSWFreeColors(void);
extern void XSWGetProgMemory(xsw_mem_stat_struct *buf);
extern void XSWReclaimGlobalMemory(bool_t verbose);
extern void XSWDoUnfocusAllWindows(void);
extern void XSWDoRestackWindows(void);
extern void XSWManageGUI(void);
extern void XSWManageSound(void);
extern void XSWDoChangeBackgroundMusic();
extern int XSWDoConnect(char *url);
extern void XSWDoDisconnect(void);
extern void XSWDoRefresh(void);
extern int XSWScrollBarCB(scroll_bar_struct *ptr);
extern void XSWHandleSignal(int s);
extern void XSWDoResetTimmers(void);
extern int XSWInit(int argc, char *argv[]);
extern void XSWManage(void);
extern void XSWShutdown(void);


/* In mainmenu.c */
extern int XSWMainMenuIsLabelAllocated(
	xsw_main_menu_struct *mm,
	int n
);
extern int XSWMainMenuCreateLabel(
	xsw_main_menu_struct *mm
);

extern void XSWMainMenuResize( 
        xsw_main_menu_struct *mm,
        win_t w, shared_image_t *image
);
extern void XSWMainMenuDrawLabel(
	xsw_main_menu_struct *mm,
	win_t w, shared_image_t *image, int mm_label_num,
	bool_t put_to_window
);
extern void XSWMainMenuDraw(
        xsw_main_menu_struct *mm,
        win_t w, shared_image_t *image,
	int amount, bool_t put_to_window
);
extern int XSWMainMenuManage(
        xsw_main_menu_struct *mm,
        win_t w, shared_image_t *image, event_t *event
);
extern void XSWMainMenuMap(
        xsw_main_menu_struct *mm,
        win_t w, shared_image_t *image
);      
extern void XSWMainMenuUnmap(
        xsw_main_menu_struct *mm,
        win_t w, shared_image_t *image
);
extern void XSWMainMenuDestroy(
        xsw_main_menu_struct *mm,
        win_t w, shared_image_t *image
);

extern int XSWMainMenuDoAction(int op_code);


/* In mainmenufile.c */
extern int XSWMainMenuLoadFromFile(
	xsw_main_menu_struct *mm,
	win_t w, shared_image_t *image,
	char *filename
);


/* In mesgwin.c */
extern int MesgAdd(char *new_mesg, pixel_t mesg_color);
extern int MesgReplace(
	char *new_mesg,
	pixel_t mesg_color,
	int mesg_num
);

extern void MesgWinUnmarkAll(void);
extern void MesgWinUpdateMark(
        int start_x, int start_y,
        int end_x, int end_y
);
extern int MesgPutDDE(void);

extern void MesgDrawAll(void);

extern int LMesgWinInit(void);
extern int LMesgWinResize(void);
extern int LMesgWinDraw(void);
extern int LMesgWinManage(event_t *event);
extern void LMesgWinMap(void);
extern void LMesgWinUnmap(void);
extern void LMesgWinDestroy(void);


/* In net.c */
extern int NetIsSocketWritable(int s, int *error_level);
extern int NetIsSocketReadable(int s, int *error_level);
extern int NetOpenConnection(char *host, int port);
extern void NetResetParms(void);


/* In netrecv.c */ 
extern int NetHandleRecv(void);


/* In netsend.c */
extern int NetSendData(char *outbounddata);
extern int NetSendGlobalMessage(char *message);
extern int NetSendDisconnect(void);
extern int NetSendRefresh(void);
extern int NetSendSetInterval(void);
extern int NetSendExec(char *arg);
extern int NetSendSetImageSet(char *arg);
extern int NetSendSetSoundSet(char *arg);
extern int NetSendSetOCSN(char *arg);
extern int NetSendPoseObj(long object_num);
extern int NetSendObjectSect(long object_num);
extern int NetSendObjectThrottle(long object_num);
extern int NetSendObjectValues(long object_num);
extern int NetSendSetLighting(long object_num, xswo_lighting_t lighting);
extern int NetSendSetChannel(long object_num, int channel);
extern int NetSendSelectWeapon(long object_num, int selected_weapon);
extern int NetSendSetShields(
	long object_num, int shield_state, double shield_frequency
);
extern int NetSendSetDmgCtl(long object_num, char damage_control);
extern int NetSendSetCloak(long object_num, char cloak_state);
extern int NetSendWeaponsLock(long object_num, long tar_object_num);
extern int NetSendWeaponsUnlock(long object_num);
extern int NetSendIntercept(long object_num, char *arg);
extern int NetSendSetEngine(long object_num, int engine_state);
extern int NetSendReqName(long object_num);
extern int NetSendFireWeapon(long object_num, double freq);
extern int NetSendTractorBeamLock(long src_obj, long tar_obj);
extern int NetSendHail(long src_obj, long tar_obj, int channel);
extern int NetSendComMessage(
	long src_obj, long tar_obj,
	int channel, char *message
);
extern int NetSendEcoReqValues(long src_obj, long tar_obj);
extern int NetSendEcoBuy(
        long customer_obj,
        long proprietor_obj,
        xsw_ecoproduct_struct product
);
extern int NetSendEcoSell(
        long customer_obj,
        long proprietor_obj,
        xsw_ecoproduct_struct product
);


/* In ocsnames.c */
extern void OCSReclaimMemory(void);
extern void OCSReset(int ocsn_num);
extern void OCSDeleteAll(void);
extern int OCSIsGarbage(int ocsn_num);
extern int OCSCreate(int type);
extern int OCSCreateExplicit(int ocsn_num, int type);
extern void OCSRecycle(int ocsn_num);
extern int OCSGetTop(void);
extern int OCSGetByCode(int code);

/* In ocsnamesfile.c */
extern int OCSLoadFromFile(char *filename);


/* In optwingui.c */
extern int OptWinInit(void);
extern int OptWinTabRemap(int tab);
extern int OptWinDraw(void);
extern int OptWinManage(event_t *event);
extern void OptWinMap(void);
extern void OptWinDoMapValues(void);
extern void OptWinUnmap(void);
extern void OptWinDestroy(void);

/* In optwinop.c */
extern void OptWinFetchGlobals(void);
extern int OptWinApplyChanges(void);
extern int OptWinLoadDefaults(void);
extern int OptWinSaveChanges(void);

extern int OptWinTestSoundPBCB(void *ptr);
extern int OptWinFBCB(char *path);
extern int OptWinBrowseISRefsPBCB(void *ptr);
extern int OptWinBrowseOCSNsPBCB(void *ptr);
extern int OptWinBrowseSSPBCB(void *ptr);
extern int OptWinBrowseJSCalPBCB(void *ptr);
extern int OptWinKeymapPBCB(void *ptr);
extern int OptWinJSMapPBCB(void *ptr);
extern int OptWinRefreshMemoryPBCB(void *ptr);

/* In qmenu.c */
extern int QMenuInit(void);
extern int QMenuDraw(void);
extern int QMenuManage(event_t *xevent);
extern int QMenuHandleCB(void *client_data, int op_code);
extern void QMenuMap(void);
extern void QMenuUnmap(void);
extern void QMenuFreeAllEntries(void);
extern void QMenuDestroy(void);


/* In rcfile.c */
extern int RCLoadFromFile(char *filename);
extern int RCSaveToFile(char *filename);


/* In rengine.c */
extern int REngInit(void);
extern void REngManage(void);
extern void REngShutdown(void);


/* In scanner.c */
extern int ScIsAllocated(int entry_num);

extern int ScAddObjectInContact(xsw_object_struct *obj_ptr);
extern void ScRemoveObjectFromContact(xsw_object_struct *obj_ptr);

extern int ScIsObjectInContact(xsw_object_struct *obj_ptr);

extern void ScDelete(long entry_num);
extern void ScDeleteAll(void);

extern void ScReclaim(void);

extern int ScHandleContacts(long object_num);


/* In serverscript.c */
extern int ServScriptIsAllocated(int n);

extern int ServScriptStart(
	char *filename,
	char **argv,
	int argc
);
extern void ServScriptDelete(int n);
extern void ServScriptDeleteAll(void);
extern void ServScriptReclaim(void);

extern void ServScriptDoSend(serv_script_struct *ss);
extern void ServScriptManage(void);

extern int ServScriptDoMapPrompt(char *filename);


/* In sound.c */
extern int SoundInit(void);
extern int SoundChangeMode(char *arg);
extern int SoundPlay(
	int code,
        double left_volume,
        double right_volume,
	int effects,
	int priority
);
extern int SoundChangeBackgroundMusic(
        int code,
        int effects,
        int priority            /* 0 or 1. */
);
extern int SoundStopBackgroundMusic();
extern int SoundManageEvents(void);
extern void SoundShutdown(void);


/* In ss.c */
extern int SSIsAllocated(int n);
extern ss_item_struct *SSGetPtr(int n);

extern int SSAllocate(char *path);
extern int SSAllocateExplicit(int n);
extern void SSDelete(int n);
extern void SSDeleteAll(void);


/* In ssfile.c */
extern int SSLoadFromFile(char *filename);


/* In timming.c */
extern long MilliTime(void);


/* In unitconv.c */
extern double ConvertRUToAU(double x);
extern double ConvertRUToSU(double x);

extern double ConvertVelocityRUPCToRUPS(double x);
extern double ConvertVelocityRUPCToAUPS(double x);



/* In vsdraw.c */
extern void ScannerDraw(
        long object_num,
        win_t w,
        shared_image_t *image,
        int win_x, int win_y,
        double scan_scale
);
extern void ScannerUpdateLabels(long object_num);

extern void VSDrawViewScreen(
	long camera_obj_num,
        win_t w,
        shared_image_t *image,
	double zoom
);
extern void VSDrawUpdateWeaponLabel(
        image_t **image,
        pixmap_t pixmap
);
extern void VSDrawUpdateNetstatsLabel(
        image_t **image,
        pixmap_t pixmap
);


/* In vsevent.c */
extern long ScannerButtonMatch(event_t *event);
extern int ScannerSBCB(void *ptr);

extern long VSButtonMatch(event_t *event);
extern int VSManage(event_t *event);
extern void VSMap(void);
extern void VSUnmap(void);
extern void VSDestroy(void);


/* In vslabels.c */
extern int VSLabelIsAllocated(long label_num);
extern int VSLabelIsLoaded(long label_num);
extern int VSLabelGetByPointer(xsw_object_struct *obj_ptr);

extern int VSLabelGetHighest(void);

extern int VSLabelAdd(
        char *text,
        WColorStruct fg_color,
        WColorStruct bg_color,
	font_t *font,
        xsw_object_struct *obj_ptr
);
extern void VSLabelDelete(long label_num);
extern void VSLabelDeleteByObjectPtr(xsw_object_struct *obj_ptr);
extern void VSLabelDeleteAll(void);
extern void VSLabelReclaimMemory(void);


/* In xswerror.c */
#ifdef X_H
extern int XSWErrorHandlerGUI(
	Display *da_display,
	XErrorEvent *da_error_event
);
#endif /* X_H */


/* In xswfbcb.c */
extern void XSWMapFB(char *path, int mode);
extern int XSWFBCBOk(char *path);
extern int XSWFBCBCancel(char *path);




#endif /* XSW_H */
