//
// first of all the textures
//
//
// Program XBLAST V2.6 or higher
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//

#declare ambientLow  = 0.10
#declare ambientHigh = 0.15

// Dull creates a large, soft highlight on the object's surface
#declare myDull = finish {ambient ambientLow specular 0.25 roughness 0.40}

// Shiny creates a small, tight highlig
#declare myShiny = finish {ambient ambientLow specular 0.75 roughness 0.0125}


#ifndef (useOverrideTexture)
#declare useOverrideTexture = 0
#end
#ifndef (overrideTexture)
#declare useOverrideTexture = 0
#end

#if (useOverrideTexture)
 #declare useOverrideTexture = 0
 #declare myGlass          = texture{overrideTexture}
 #declare helmetTexture    = texture{overrideTexture}
 #declare faceTexture      = texture{overrideTexture}
 #declare bodyTexture      = texture{overrideTexture}
 #declare armsLegsTexture  = texture{overrideTexture}
 #declare handsFeetTexture = texture{overrideTexture}
 #declare backpackTexture  = texture{overrideTexture}
#else

// Glass for Helmet
#declare myGlass =
  texture {
  pigment { color rgbf<1.0, 1.0, 1.0, 0.85> }
  finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1
    refraction 1
    ior 1.5
  }
#if (playerDamaged != 0)
  normal {
    crackle
    slope_map {
      [0.0 0.0] [0.1 1.0] [1.0 1.0]
    }
    scale 0.5
  }
#end
}

#ifndef (stripeColor) 
  #declare helmetTexture =
  texture {
    pigment {color helmetColor}
    finish {myShiny ambient ambientHigh}
    #if (playerDamaged != 0)
      normal {dents 1.0 scale 0.25}
    #end
  }
#else
  #declare helmetTexture =
  texture {
    pigment {
      gradient x
      color_map {
        [0.0 color stripeColor]
        [0.2 color stripeColor]
        [0.2 color helmetColor]
        [1.0 color helmetColor]
      }
      scale 2.5
    }
    finish {myShiny ambient ambientHigh}
    #if (playerDamaged != 0)
      normal {dents 1.0 scale 0.25}
    #end
  }
#end
#declare faceTexture =
texture {
  pigment {faceColor}
  finish {Dull ambient ambientHigh}
}
#declare bodyTexture =
texture {
  pigment {color bodyColor}
  finish {myShiny ambient ambientHigh}
  #if (playerDamaged != 0)
    normal {dents 1.0 scale 0.25}
  #end
}
#declare armsLegsTexture =
texture {
  #if (playerDamaged = 0)
    pigment {armsLegsColor}
    finish {myDull  ambient ambientHigh}
  #else
    bozo
    texture_map {
      [0.0 pigment {armsLegsColor} finish {myDull ambient ambientHigh} ]
      [0.6 pigment {armsLegsColor} finish {myDull ambient ambientHigh} ]
      [0.7 pigment {Gray25} ]
      [0.7 pigment {faceColor} finish {Dull ambient ambientHigh}]
      [1.0 pigment {faceColor} finish {Dull ambient ambientHigh}]
    }
  scale 0.33
  #end
}
#declare handsFeetTexture =
texture {
  pigment {color handsFeetColor}
  finish {myShiny ambient ambientHigh}
}
#declare backpackTexture =
texture {
  pigment {color backpackColor}
  finish {myShiny ambient ambientHigh}
}

#declare eyeTexture =
#if (playerIsSick)
texture {
  spiral1 2
  texture_map {
    [0.0 pigment {color Gray15} finish {Glossy} ]
    [0.5 pigment {color Gray15} finish {Glossy} ]
    [0.5 pigment {color rgbt <0,0,0,1>} ]
    [1.0 pigment {color rgbt <0,0,0,1>} ]
  }
  rotate x*90
  scale <0.1,0.15,0.5>
  translate <-0.3,0,0>
}
#else
  texture {
    pigment {
#if (1)
      color Gray15
#else
      wood
      color_map {
	[0.00 color Black]
	[0.25 color Black]
	[0.25 color White]
	[1.00 color White]
      }
      translate <0,-0.1,0>
#end
    }
    finish {Glossy }
  }
#end

#end
