#include "xev.h"
#include "back.h"
#include <math.h>

#define PI 3.14159265638979/128

PRIVATE char img[CSIZE*CSIZE];
PRIVATE Pixmap pixmap_back,pixmap_window,pixmap_chijo[CHIJOU];
PRIVATE int pixmap_ptrY , msg_flag = 0;
PRIVATE Pixmap face;
PRIVATE GC gc[CHIJOU],fgc;
PRIVATE char *ffn[] = {
      "au1.img",
      "au2.img",
      "au3.img",
      "au4.img",
      "au5.img",
      "au6.img"    
};


void StartScroll()
{
     pixmap_ptrY = YSIZE;
     scrl_cntr1 = CSIZE;
}

void PrintString(x,y,str,f,b)
     char *str;
     int f,b;
{
      XSetForeground(d,font_gc,pixel[b]);
      XDrawString(d,pixmap_window,font_gc,x+2,y+2,
                  str,strlen(str));
      XSetForeground(d,font_gc,pixel[f]);
      XDrawString(d,pixmap_window,font_gc,x,y,
                  str,strlen(str));
}

void PrintStringW(x,y,str,f,b)
     char *str;
     int f,b;
{
      XSetForeground(d,font_gc,pixel[b]);
      XDrawString(d,w,font_gc,x+2,y+2,
                  str,strlen(str));
      XSetForeground(d,font_gc,pixel[f]);
      XDrawString(d,w,font_gc,x,y,
                  str,strlen(str));
}

void Title2()
{
      PrintString(160,400,"Press [s] key to start",32,0);
      PrintString(180,440,"Programed by Yuuji Waizumi",32,0);
      PrintString(180,200,"Xbat version 1.1",32,0);
}

void Scroll(t_flag) 
     int t_flag;
{
      int i;
      int red[32] = {
	    0,0,0,0,
	    17,17,17,17,
	    18,18,18,18,
	    19,19,19,19,
	    20,20,20,20,
	    19,19,19,19,
	    18,18,18,18,
	    17,17,17,17
      };
      static int cntr = 0;
      static int red_cntr = 0;
      XColor col;

      cntr++;
      cntr %= DRAWSTEP;
      red_cntr++;
      red_cntr %= 32;

      pixmap_ptrY-=STPF;
      
      scrl_cntr1-=STPF;
      
      if(ch_color) {
	    col.red = rgb[red[red_cntr]][0]*256;
	    col.green = rgb[red[red_cntr]][1]*256;
	    col.blue = rgb[red[red_cntr]][2]*256;
	    col.flags = DoRed|DoGreen|DoBlue;
	    col.pixel = cr_pixel;
	    
	    XStoreColor(d,cmap,&col);
      }

      if(!cntr) {
	    XCopyArea(d,pixmap_back,pixmap_window,back_gc,0,pixmap_ptrY,
		      XSIZE,YSIZE,0,CSIZE);
	    XSync(d,False);

	    if(pixmap_ptrY <= 0){
		  pixmap_ptrY = YSIZE;
		  
		  XCopyArea(d,pixmap_back,
			    pixmap_back,back_gc,0,0,
			    XSIZE,YSIZE,
			    0,YSIZE);
		  
		  XSync(d,False);
	    }
	    
	    if(scrl_cntr1 <= 0) {
		  int x;
		  
		  scrl_cntr1 = CSIZE;
		  scrl_ptr--;
		  
		  for(x = 0 ; x < 15 ; x++) {
			XCopyArea(d,pixmap_chijo[map[scrl_ptr][x]],
				  pixmap_back,gc[map[scrl_ptr][x]],0,0,
				  CSIZE,CSIZE,x*CSIZE,
				  pixmap_ptrY-CSIZE);

		  }
		  
		  ChijouInit(scrl_ptr);
		  EnemyInit(scrl_ptr);
	    }
	    
	    for(i = 0 ; i < char_set_no ; i++) {

		  XSetClipOrigin(d,char_set[i].gc,
				 char_set[i].x,char_set[i].y+CSIZE);
		  XCopyArea(d,char_set[i].pixmap,pixmap_window,
			    char_set[i].gc,
			    0,0,
			    char_set[i].size_x,char_set[i].size_y,
			    char_set[i].x,char_set[i].y+CSIZE);

		  
	    }

	    char_set_no = 0;
	    if(msg_flag) {
		  PrintString(150,400,"nemoto Not ORIGINAL",32,26);
		  PrintString(180,420,
			      "Programed by Yuuji \"Pretty\" Waizumi",32,26);
	    }
	   
	    if(t_flag)
	      Title2();
	    XCopyArea(d,pixmap_window,w,back_gc,0,CSIZE,
		      XSIZE,YSIZE,0,0);
	    XSync(d,False);
      }
      char_set_no = 0;
      XSync(d,False);
}

void GameOver()
{
      XSetForeground(d,font_gc,pixel[20]);
      XDrawString(d,w,font_gc,180,200,"Game Over",9);
      XSync(d,False);
}

void InputImage() 
{
      int c_no;
      FILE *fp;
      XGCValues gcv;

      gcv.graphics_exposures = False;
      
      for(c_no = 0 ; c_no < CHIJOU ; c_no++) {
	    int x,y;

	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
	    LoadChar(tpath,img , sizeof(img));
	    
	    /*if((fp = fopen(tpath,"rb")) == NULL) {
		  perror("Setchar : ");
		  exit(errno);
	    }

	    if(fread(img , sizeof(img) , 1 , fp) != 1) {
		  perror("SetChar : ");
		  fclose(fp);
		  exit(errno);
	    }
	    
	    if(fclose(fp) == EOF) {
		  perror("fclose in InputData ");
		  exit(errno);
	    }
	    */
	    pixmap_chijo[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);
	    for(y = 0 ; y < CSIZE ; y++)
	      for(x = 0 ; x < CSIZE ; x++) {
		    if(img[y*CSIZE+x] != 100) {
			  XSetForeground(d,gc[c_no],
					 pixel[img[y*CSIZE+x]]);
			  XDrawPoint(d,pixmap_chijo[c_no],gc[c_no],
				     x,y);
		    }else{
			  XSetForeground(d,gc[c_no],pixel[0]);
			  XDrawPoint(d,pixmap_chijo[c_no],gc[c_no],
				     x,y);
		    }
	      }
      }
      pixmap_window = XCreatePixmap(d,w,XSIZE,YSIZE+CSIZE,depth);
      pixmap_back = XCreatePixmap(d,w,XSIZE,YSIZE*2,depth);
      

}

void BackFree()
{
      int i;

      for(i = 0; i < CHIJOU ; i++) {
	    XFreePixmap(d,pixmap_chijo[i]);
      }
      XFreeGC(d,back_gc);
      XFreePixmap(d,pixmap_back);
      XFreePixmap(d,pixmap_window);
}

void MakeMap(stage)
     int stage;
{
      int x,y,py=YSIZE-CSIZE;
      int r;
      char fn[256];
      FILE *fp;
      
      sprintf(fn,"%s/bmap%d.dat",MAP_DIR,stage);
      if( (fp = fopen(fn,"rb")) == NULL) {
	    perror("In MakeMap ");
	    exit(errno);
      }
      
      if(fread(map,sizeof(map),1,fp) != 1) {
	    perror("In MakeMap ");
            exit(errno);
      }

      fclose(fp);

      for(y = YMAP - 19 ; y < YMAP ; y++) {
	    for(x = 0 ; x < XMAP ; x++) {
		  XCopyArea(d,pixmap_chijo[map[y][x]],
			    pixmap_back,back_gc,0,0, 
			    CSIZE,CSIZE,x*CSIZE,py);
	    }	      
	    py += CSIZE;
      }
}

void Redraw()
{
      int py = YSIZE-CSIZE,x,y;
      StartScroll();
      for(y = scrl_ptr ; y < scrl_ptr+19 ; y++) {
	    for(x = 0 ; x < XMAP ; x++) {
                  XCopyArea(d,pixmap_chijo[map[y][x]],
                            pixmap_back,back_gc,0,0,
                            CSIZE,CSIZE,x*CSIZE,py);
            }
            py += CSIZE;
      }
      Scroll(0);
      XFlush(d);
}

void SetSprite(x,y,pixmap,gc,size_x,size_y)
     short x,y;
     Pixmap pixmap;
     GC gc;
     int size_x,size_y;
{
      char_set[char_set_no].x = x;
      char_set[char_set_no].y = y;
      char_set[char_set_no].pixmap = pixmap;
      char_set[char_set_no].gc = gc;
      char_set[char_set_no].size_x = size_x;
      char_set[char_set_no++].size_y = size_y;
}

void AuthorSetChar()
{
      int cx,cy;
      char img[CSIZE*CSIZE];
      XGCValues gcv;
      int x,y;
      
      gcv.graphics_exposures = False;
      
      face = XCreatePixmap(d,w,128,96,depth);
      fgc = XCreateGC(d,w,GCGraphicsExposures,&gcv);
      
      XSetForeground(d,fgc,pixel[0]);
      
      XFillRectangle(d,face,fgc,0,0,128,96);
      
      for(cy = 0 ; cy < 3 ; cy++)
	for(cx = 0 ; cx < 2 ; cx++) {
	      sprintf(tpath , "%s/%s",IMAGE_DIR,ffn[cx+cy*2]);
	      LoadChar(tpath,img , sizeof(img));
	      
	      for(y = 0 ; y < CSIZE ; y++)
		for(x = 0 ; x < CSIZE ; x++) {
		      XSetForeground(d,fgc,
				     pixel[img[y*CSIZE+x]]);
		      XDrawPoint(d,face,fgc,CSIZE+cx*CSIZE+x,cy*CSIZE+y);
		}
	}
}

void AuthorFree()
{
      XFreePixmap(d,face);
      XFreeGC(d,fgc);
}

void Rast()
{
      int x,y,i;
      static int th=0;
      char str[128];
      
      for(y = 0 ; y < 96  ; y++) {
            x = (int)(32.0*cos(2*PI*y+th));
            XCopyArea(d,face,pixmap_window,fgc,
		       32+x,y,96,1,190,150+y);
      }
      th++ ; th &= 255;

      XSetForeground(d,font_gc,pixel[16]);
      sprintf(str,"Author !!");
      XDrawString(d,pixmap_window,font_gc,210,160,str,strlen(str));

      XCopyArea(d,pixmap_window,w,back_gc,0,CSIZE,
		XSIZE,YSIZE,0,0);
      XFlush(d);
      
      u_sleep(50000);
}

void ConfigMSG(df,s,j,y,rsha)
     int df,j,s,y,rsha;
{	
      int i;
      char msg[6][11][16] = 
	{
	      {
		    "           easy",
		    "          nomal",
		    "      difficult",
		    " more difficult",
		    "       abnormal"
	      }
	      ,
	      {
		    "              3",
		    "              5",
		    "              7"
	      }
	      ,
	      {
		    "          nomal",
		    "     high speed"
	      }
	      ,
	      { 
		    "             no",
		    "            yes"
	      }
	      ,
	      { 
                    "             no",
                    "            yes"
              }
	      ,
	      {
		    "        no wait",
		    "              1",
		    "              2",
		    "              3",
		    "              4",
		    "              5",
		    "              6",
		    "              7",
		    "              8",
		    "              9",
		    "             10"
	      }
	};
      
      XSetForeground(d,back_gc,pixel[0]);
      XFillRectangle(d,w,back_gc,103,103,320,165);
      XSetForeground(d,back_gc,pixel[5]);
      XFillRectangle(d,w,back_gc,100,100,320,165);

      XSetForeground(d,font_gc,pixel[0]);
      XDrawString(d,w,font_gc,102,y*20+142,"->",2);
      XSetForeground(d,font_gc,pixel[20]);
      XDrawString(d,w,font_gc,100,y*20+140,"->",2);
      
      
      PrintStringW(120,120," -- SET UP --",16,0);
      PrintStringW(120,260," EXIT ",16,0);
      PrintStringW(120,140,"difficulty",16,0);
      PrintStringW(120,160,"     ships",16,0);
      PrintStringW(120,180,"game speed",16,0);
      PrintStringW(120,200,"exg.[z][x]?",16,0);
      PrintStringW(120,220,"rapid fire?",16,0);
      PrintStringW(120,240,"wait       ",16,0);
      
      PrintStringW(220,140,msg[0][df],32,0);
      PrintStringW(220,160,msg[1][j],32,0);
      PrintStringW(220,180,msg[2][s],32,0);
      PrintStringW(220,200,msg[3][rev_key],32,0);
      PrintStringW(220,220,msg[4][rsha],32,0);
      PrintStringW(220,240,msg[5][wait_val],32,0);
      XFlush(d);
}
      
int Config(muteki , start_stage , rs)
     int *muteki , *start_stage , rs;
{
      int x ,y=0;
      int msg_num[5] = {5,3,2,2,2} , ren[2] = {15,3};
      static int nokori_no = 1;
      int rensha_no = (rs > 3) ? 0 : 1;
      
      ConfigMSG(game_level,DRAWSTEP-1,nokori_no,y,rensha_no);

      while(1) {
	    while(XPending(d)> 0) {
		  XNextEvent(d, &e);
		  switch (e.type){
		      case KeyPress:
			switch (XKeycodeToKeysym(d, e.xkey.keycode, 0)){
			    case XK_t:
			      *muteki = 1 - *muteki;
			      break;
			    case XK_y:
			      *start_stage += (*start_stage<16);
			      break;
			    case XK_u:
			      *start_stage -= (*start_stage>1);
			      break;
			    case XK_Up:
			    case XK_KP_8:
			    case XK_i:
			      if(y > 0)
				y--;
			      break;
			    case XK_Down:
			    case XK_KP_2:
			    case XK_KP_5:
			    case XK_k:
			    case XK_m:
			      if(y < 6)
				y++;
			      break;
			      
			    case XK_Left:
			    case XK_KP_4:
			    case XK_j:
			      switch(y) {
				  case 0:
				    if(game_level > 0)
				      game_level--;
				    break;
				  case 2:
				    DRAWSTEP = 1;
				    break;
				  case 1:
				    if(nokori_no> 0) {
					  nokori_no--;
				    }
				    break;
				  case 5:
				    if(wait_val > 0)
				      wait_val--;
				    break;
				  case 6:
				    goto quit_conf;
				    break;
				  case 3:
				    rev_key = 1 - rev_key;
				    break;
				  case 4:
				    rensha_no = 1 - rensha_no;
				    rensha = ren[rensha_no];
				    
				    break;
				    
			      }
			      break;
			      
			    case XK_Right:
			    case XK_KP_6:
			    case XK_l:
			      switch(y) {
				  case 0:
				    if(game_level < 4)
				      game_level++;
				    break;
				  case 2:
				    DRAWSTEP = 2;
				    break;
				  case 1:
				    if(nokori_no < 2) {
					  nokori_no++;
				    }
				    break;
				  case 5:
				    if(wait_val < 10)
				      wait_val++;
				    break;
				  case 6:
				    goto quit_conf;
				    break;
				  case 3:
				    rev_key = 1 - rev_key;
				    break;
				  case 4:
				    rensha_no = 1 - rensha_no;
				    rensha = ren[rensha_no];
				    break;
				    
			      }
			      break;
			}
			ConfigMSG(game_level,DRAWSTEP-1,nokori_no,y,rensha_no);
			break;
		      case Expose:
			Title(0);
			ConfigMSG(game_level,DRAWSTEP-1,nokori_no,y,rensha_no);
			break;
		  }
	    }
      }
    quit_conf:
      return nokori_no;
}

int Msg(enemy_no)
     int enemy_no;
{
      int sx,sy;

      enemy_chijou[enemy_no].y.dummy += enemy_chijou[enemy_no].vy;
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];
      
      if(sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
	    msg_flag = 0;
      } 
      
      if((shot_chi.x.sht[UNION] - sx) > -10 &&
         (shot_chi.x.sht[UNION] - sx) < 32 && 
         (shot_chi.y.sht[UNION] - sy) > -10 && 
         (shot_chi.y.sht[UNION] - sy) < 42 &&
         shot_chi.z  == 1 && !msg_flag) {
	     score += 10;
	     msg_flag = 1;
	     return 1;
       }
      return 0;
}
