## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import os, sys
from gtk import *

# PySol imports
from mfxutil import destruct                                        #bundle#


# /***********************************************************************
# //
# ************************************************************************/

class PysolStatusbar:
    def __init__(self, top):
        self.top = top
        self.side = '#init#'

    def hide(self, resize=0):
        self.show(None, resize)

    def getSide(self):
        return self.side

    def show(self, side='bottom', resize=0):
        pass

    def updateText(self, **kw):
        pass


# /***********************************************************************
# //
# ************************************************************************/

#%ifndef BUNDLE

class TestStatusbar(PysolStatusbar):
    def __init__(self, top, args):
        PysolStatusbar.__init__(self, top)
        # test some settings
        self.updateText(moves=999, gameid="#1234-5678-9ABC-0000")
        self.updateText(dummy="a text")

def statusbar_main(args):
    root = GtkWindow()
    root.connect("destroy", mainquit)
    root.connect("delete_event", mainquit)
    statusbar = TestStatusbar(root, args)
    root.show_all()
    mainloop()
    return 0

if __name__ == '__main__':                                          #bundle#
    sys.exit(statusbar_main(sys.argv))                              #bundle#

#%endif

