#ifndef __COORDINATE_H_
#define __COORDINATE_H_

#define ARRAY_COOR(array, coor)		((array)[(coor).xy[0]][(coor).xy[1]])

typedef struct {
	int xy[2];
} Coordinate;

typedef int (*CoordinateFunc)(Coordinate *, void *);

Coordinate *coordinate_copy(Coordinate *dest, Coordinate *src);
inline int coordinate_clip_x(Coordinate *coor);
inline int coordinate_clip_y(Coordinate *coor);
int coordinate_clip(Coordinate *coor);
inline Coordinate *coordinate_add(Coordinate *dest, Coordinate *addition);
int coordinate_add_with_clip(Coordinate *dest, Coordinate *addition);
inline int coordinate_valid_x(Coordinate *coor, int xmax);
inline int coordinate_valid_y(Coordinate *coor, int ymax);
int coordinate_valid(Coordinate *coor, int xmax, int ymax);
int coordinate_foreach(Coordinate *coor, int left, int top, int right, int bottom, CoordinateFunc f, void *data);
int coordinate_compare(Coordinate *coor, Coordinate *coor2);
void coordinate_print(Coordinate *coor);

#endif
