// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
 
//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SignalDeclaration.cc,v 1.3 1999/06/09 00:45:52 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_SignalDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_ConcurrentStatement.hh"
#include "IIR_TextLiteral.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "error_func.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_SignalDeclaration::IIRScram_SignalDeclaration() {
  register int i;
  implemented_attributes_in_constructor = new IIR_Boolean[numSignalAttributes];
  implemented_attributes_in_state = new IIR_Boolean[numSignalAttributes];
  implemented_attributes_in_initstate = new IIR_Boolean[numSignalAttributes];
  for(i = 0; i < numSignalAttributes; i++) {
    implemented_attributes_in_constructor[i] = FALSE;
    implemented_attributes_in_state[i] = FALSE;
    implemented_attributes_in_initstate[i] = FALSE;
  }
  _my_clone = NULL;
  _driver_addition_flag = FALSE;
  _passed_through_out_port = FALSE;
}


IIRScram_SignalDeclaration::~IIRScram_SignalDeclaration() { 
  delete [] implemented_attributes_in_constructor;
  delete [] implemented_attributes_in_state;
  delete [] implemented_attributes_in_initstate;
}


void 
IIRScram_SignalDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {

  ASSERT ( _get_declarative_region() != NULL );
  
  _vhdl_out << "signal ";
  IIRScram_ObjectDeclaration::_publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);
  _publish_vhdl_signal_kind(_vhdl_out);
  _publish_vhdl_expression(_vhdl_out);
  _vhdl_out << ";\n";
}

void 
IIRScram_SignalDeclaration::_publish_cc() {
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );

  // cgen_sym_tab_ptr will be NULL during elaboration, hence this check.
  if (cgen_sym_tab_ptr != NULL) {
    if (get_value() != NULL) {
      get_value()->_add_decl_into_cgen_symbol_table();
    }
    if (!cgen_sym_tab_ptr->in_scope(this)) {
      cgen_sym_tab_ptr->add_declaration(this);
    }
  }
  if(_is_implicit_declaration() == true) {
    if(_get_attribute_name() != NULL) {
      _get_attribute_name()->_publish_cc();
      return;
    } 
  }
  IIRScram_Declaration::_set_scoping_prefix();
  IIRScram::_publish_cc_prefix_string();
  _get_declarator()->_publish_cc();
  IIRScram_Declaration::_reset_scoping_prefix();
}


void
IIRScram_SignalDeclaration::_publish_cc_sigdest() {
  ASSERT(cgen_sym_tab_ptr != NULL);
  ASSERT(get_declarator()->get_kind() == IIR_IDENTIFIER);

  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "state->current->";
  _get_declarator()->_publish_cc();
}


void 
IIRScram_SignalDeclaration::_publish_cc_decl() {
  if( _get_attribute_name() != NULL ) {
    // Publish the implict declaration and also other declarations needed
    // for this
    _get_attribute_name()->_publish_cc_necessary_decl_in_state();
  }
  else {
    if (get_subtype()->_is_scalar_type() == TRUE) {
      get_subtype()->_publish_cc_kernel_type();
    }
    else {
      get_subtype()->_publish_cc();
    }
    _cc_out << " ";
    _get_declarator()->_publish_cc();
    _cc_out << ";" << endl;
  }
}

void
IIRScram_SignalDeclaration::_publish_cc_init() {
  //Reset the index counter since, a new signal interface declaration
  //is initialized
  _index_level = 0;

  ASSERT(_is_implicit_declaration() == FALSE);
  _publish_cc_init_signal();
}


void
IIRScram_SignalDeclaration::_publish_cc_init_signal() {
  //#### yet to handle composite types.  Will be solved eventually
  char *procname;
  char* anothername = _current_another_name;
  IIR* temporaryNode = _current_publish_node;
  IIR_ConcurrentStatement* tempConcStmt;
  IIR_Declaration* tempDecl = NULL;
  int index = 0;
  IIR_Boolean last_activeAttribRequired = false;
  IIR_Boolean last_eventAttribRequired = false;
  IIR_Boolean last_activeAttribPresent = false;
  IIR_Boolean last_eventAttribPresent = false;
  IIR_Declaration* implied_declarations = NULL;

  // since c_p_n is changed here, it must be reset before returning
  procname = _current_publish_name;
  //### Yet to check for signal declarations in implicit declarations
  if( _get_implicit_declarations() != NULL ){
    implied_declarations = _get_implicit_declarations()->get_element();
    while(implied_declarations != NULL) {
      if(cgen_sym_tab_ptr->in_scope(implied_declarations)) {
	switch(implied_declarations->get_kind()) {
	case IIR_SIGNAL_DECLARATION:
	case IIR_SIGNAL_INTERFACE_DECLARATION:
	  implied_declarations->_set_declarative_region(_get_declarative_region());
	  implied_declarations->_publish_cc_init_signal(); 
	  break;
	case IIR_FUNCTION_DECLARATION:
	  //	  implied_declarations->_publish_cc_init_function(); 
	  break;
	default:
	  cerr << "Unknown declaration initialization: "
	       << implied_declarations->get_kind_text() << endl;
	  break;
	}
      
	// Count the number of attributes of this signal
	index++;

	switch(implied_declarations->_get_attribute_name()->get_kind()) {
	case IIR_QUIET_ATTRIBUTE:
	case IIR_ACTIVE_ATTRIBUTE:
	  last_activeAttribRequired = true;
	  break;
	case IIR_STABLE_ATTRIBUTE:
	case IIR_EVENT_ATTRIBUTE:
	  last_eventAttribRequired = true;
	  break;
	case IIR_LAST_ACTIVE_ATTRIBUTE:
	    last_activeAttribPresent = true;
	    break;
	case IIR_LAST_EVENT_ATTRIBUTE:
	  last_eventAttribPresent = true;
	}
      }
      implied_declarations = _get_implicit_declarations()->get_next_element();
    }
  }

  // Implementation of the QIUET, STABLE, ACTIVE and EVENT attributes
  // require last_active or last_event attribute.  This will be declared
  // transparent to the user.  This is why index is incremented by one here.
  // CAUTION: However, this must not be done if last_active or last_event is
  // already declared in the process.
  if(last_activeAttribRequired == TRUE &&
     last_activeAttribPresent == FALSE) {
    index++;
  }
  if(last_eventAttribRequired == TRUE &&
     last_eventAttribPresent == FALSE) {
    index++;
  }

  ostrstream labelstr;
  ostrstream signalNetinfostr;
  _get_declarator()->_print(labelstr);
  labelstr << ends;
  _current_publish_name = labelstr.str();

  if ( _is_implicit_declaration() != TRUE ) {
    ASSERT ( _get_declarative_region() != NULL );
    
    if ((_current_publish_node != NULL) && ( _current_publish_node->_is_concurrent_statement() == TRUE )) {
      tempConcStmt = (IIR_ConcurrentStatement *) _current_publish_node;
      ASSERT ( tempConcStmt->_is_concurrent_statement() == TRUE );
      
      tempConcStmt->_publish_cc_scoping_prefix(_get_declarative_region(), _current_publish_node, signalNetinfostr);
    }
  }
  else {
    ASSERT ( _get_signal_decl()->_is_iir_declaration() == TRUE );
    tempDecl = (IIR_Declaration *) _get_signal_decl();
    ASSERT ( tempDecl->_is_iir_declaration() == TRUE );
    
    if ((_current_publish_node != NULL) && ( _current_publish_node->_is_concurrent_statement() == TRUE )) {
      tempConcStmt = (IIR_ConcurrentStatement *) _current_publish_node;
      ASSERT ( tempConcStmt->_is_concurrent_statement() == TRUE );
      
      tempConcStmt->_publish_cc_scoping_prefix(tempDecl->_get_declarative_region(), tempConcStmt, signalNetinfostr);
    }
  }
  
  _current_publish_node = this;
  _get_declarator()->_print(signalNetinfostr);
  signalNetinfostr << "_info" << ends;
  
  // IIRScalarTypeDefinition::_publish_cc_init_implicit_signal() expects
  // _current_another_name to be set to the string representation of the
  // signal's netinfo structure.
  _current_another_name = signalNetinfostr.str();
  _cc_out << "{" << endl;	//begin dummy block for scoping
  _cc_out << "  " << _current_publish_name << ".setElaborationInfo(";
  if((_get_declarative_region()->_is_iir_package_declaration() == FALSE) &&
     (_get_declarative_region()->get_kind() != IIR_PACKAGE_BODY_DECLARATION)) {
    _cc_out << "proc->" ;
  }
  _cc_out  << _current_another_name << ");\n";

  // publish attributes for this signal

  if(index > 0) {
    ASSERT( _get_implicit_declarations() != NULL );
    
    _cc_out << "  " << _current_publish_name <<".setNumAttributes("
	    << index << ");\n";

    implied_declarations = _get_implicit_declarations()->get_element();

    while(implied_declarations != NULL) {
      if(cgen_sym_tab_ptr->in_scope(implied_declarations)) {
	_cc_out << "  " << _current_publish_name <<".setAttrib" << "(";
	implied_declarations->_get_attribute_name()->_publish_cc_name_in_caps();
	_cc_out << ", ";
	
	if (implied_declarations->_get_attribute_name() != NULL) {
	  implied_declarations->_get_attribute_name()->_publish_cc_declarator();
	}
	else {
	  implied_declarations->_get_declarator()->_publish_cc();
	}
	_cc_out << ");\n";
      }
      implied_declarations = _get_implicit_declarations()->get_next_element();
    }

    if(last_activeAttribRequired == TRUE && 
       last_activeAttribPresent == FALSE) {
      _cc_out << "  " << _current_publish_name <<".setAttrib" << "(";
      _cc_out << "LAST_ACTIVE, ";
      ASSERT(_current_publish_node->_is_signal() == true);
      _current_publish_node->_get_declarator()->_publish_cc();
      _cc_out << "_last_active);\n";
      
      last_activeAttribPresent = TRUE;
    }
    
    if(last_eventAttribRequired == TRUE && 
       last_eventAttribPresent == FALSE) {
      _cc_out << "  " << _current_publish_name <<".setAttrib" << "(";
      _cc_out << "LAST_EVENT, ";
      
      ASSERT(_current_publish_node->_is_signal() == true);
      
      // This function takes care of publishing last events
      // properly for the corresponding types

      _current_publish_node->_get_declarator()->_publish_cc();
      _cc_out << "_last_event);\n";

      last_eventAttribPresent = TRUE;
    }
  }

//   if(_is_implicit_declaration() == TRUE) {
//     ASSERT(this->_get_attribute_name()->_is_attribute() == TRUE);
//     IIR_Attribute* sig_attribute = this->_get_attribute_name();
//     IIR_TypeDefinition* type_def = sig_attribute->_get_explicit_signal_type();
//     type_def->_publish_cc_init_signal();
//   }
//   else {
//     get_subtype()->_publish_cc_init_signal();
//   }

  if ( _is_implicit_declaration() == FALSE ){
    _cc_out << "  " << _current_publish_name
	    << ".resolveAndUpdate(processPointer);\n";
  }

  _cc_out << "};" << endl;	//end dummy block
  _current_publish_name = procname;
  _current_publish_node = temporaryNode;
  _current_another_name = anothername;
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_necessary_decl_init();
  }
}


void
IIRScram_SignalDeclaration::_publish_cc_data() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "state->current->"; 
  _get_declarator()->_publish_cc();
}


IIRScram_Declaration::declaration_type 
IIRScram_SignalDeclaration::_get_type(){
  return SIGNAL;
}

void
IIRScram_SignalDeclaration::_publish_cc_elaborate() {
  _get_declarator()->_publish_cc();
  _cc_out << "_info";
}


IIR_Declaration*
IIRScram_SignalDeclaration::_get_signal_decl() {
  IIR_Attribute* attached_attribute;
  attached_attribute = _get_attribute_name();
  set<IIR_Declaration> *attached_to = attached_attribute->get_prefix()->_symbol_lookup();

  if( attached_to == NULL ){
    ostrstream err;
    err << *(attached_attribute->get_prefix()) << " undefined" << endl;
    report_error( this, err );
  }

  IIR_Declaration *current_decl = attached_to->get_element();
  while( current_decl != NULL ){
    if( current_decl->_is_signal() == false ){
      attached_to->remove( current_decl );
    }
    current_decl = attached_to->get_next_element();
  }

  IIR_Declaration *signal_decl = NULL;
  switch( attached_to->num_elements() ){
  case 1:{
    signal_decl = attached_to->get_element();
    break;
  }
  case 0:
  default:
    cerr << "Internal error in overload resolution in "
	 << "IIRScram_Attribute::_symbol_lookup() - got "
	 << attached_to->num_elements() << " possibilities." << endl;
    abort();
  }
  return signal_decl;
}


void
IIRScram_SignalDeclaration::_publish_cc_wait_data() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "s->"; 
  _get_declarator()->_publish_cc();
}


// This function publishes the constructor of signals in the constructor
// of the state.
void
IIRScram_SignalDeclaration::_publish_cc_state_object_init() {
  //   _cc_out << "(ObjectBase::";
  //   if(_is_implicit_declaration() == TRUE) {
  //     _cc_out << "IMPLICIT_SIGNAL";
    
  //   } else {
  //     _cc_out << "SIGNAL";
  //   }
  //   if(get_subtype()->_is_array_type() == TRUE) {
  //     _cc_out << ", ";
  //     get_subtype()->_publish_cc_range();
  //   }


  // If this is an implicit signal and it is QUIET attribute, we have to
  // add initialization for LAST_ACTIVE attribute.  Similarly for ACTIVE,
  // STABLE and EVENT attributes.  Before we add, we have to check if
  // LAST_ACTIVE (or LAST_EVENT) attribute is already initialized.  To do
  // this we maintain a boolean array
  // "implemented_attributes_in_constructor" which is set using the method
  // _add_published_attribute_in_constructor(SignalAttribute) and checked
  // using the method
  // _is_published_attribute_in_constructor(SignalAttribute).  The enum
  // SignalAttribute is defined in IIRScram_Declaration.hh

  if(_is_implicit_declaration()) {
    _get_attribute_name()->_publish_cc_state_object_init();
  }
  else {
    _get_declarator()->_publish_cc();
    _publish_cc_constructor_args();
    _cc_out << ", " << endl;
  }
}


void
IIRScram_SignalDeclaration::_publish_cc_object_type() {
  if(_is_implicit_declaration() == TRUE) {
    _cc_out << "IMPLICIT_SIGNAL";
  } else {
    _cc_out << "SIGNAL";
  }
}

IIR_Boolean
IIRScram_SignalDeclaration::_is_guard_signal() {
  ASSERT ( get_declarator() != NULL );
  if (IIR_TextLiteral::_cmp( get_declarator(), "guard") == 0) {
    return TRUE;
  }

  return FALSE;
}

void
IIRScram_SignalDeclaration::_publish_cc_necessary_copying() {
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_necessary_copying();
  }
  else {
    _cc_out << "  this->";
    _get_declarator()->_publish_cc();
    _cc_out << " = s.";
    _get_declarator()->_publish_cc();    
    _cc_out << ";\n";
  }
}

void
IIRScram_SignalDeclaration::_publish_cc_read_or_write(const char *fName, const char *sName) {
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_read_or_write(fName, sName);
  }
  else {
    _cc_out << fName << "(NULL, " << sName << ", ";
    _get_declarator()->_publish_cc();
    _cc_out << ");\n";
  }
}

IIR_SignalKind
IIRScram_SignalDeclaration::_get_signal_kind(){
  return get_signal_kind();
}

IIR*
IIRScram_SignalDeclaration::_clone() {
  if (_my_clone == NULL) {
    _my_clone = new IIR_SignalDeclaration();
    IIRScram_ObjectDeclaration::_clone(_my_clone);

    _my_clone->_set_driver_addition_flag( _driver_addition_flag );
    _my_clone->_set_passed_through_out_port( _passed_through_out_port );
    _my_clone->set_value(get_value());
    _my_clone->set_signal_kind(get_signal_kind());
  }
  return _my_clone;
}
