// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_MultiplicationOperator.cc,v 1.2 1999/03/09 20:55:31 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_MultiplicationOperator.hh"
#include "set.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "IIR_TypeDefinition.hh"
#include <strstream.h>

IIRScram_MultiplicationOperator::~IIRScram_MultiplicationOperator() {}

void 
IIRScram_MultiplicationOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " * ";
}

void 
IIRScram_MultiplicationOperator::_publish_cc_operator_name() {
  _cc_out << "savantMultiply";
}

IIR*
IIRScram_MultiplicationOperator::_clone() {
  IIR_MultiplicationOperator *clone = new IIR_MultiplicationOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_MultiplicationOperator::_get_operator_precedence(){
  return IIRScram::MULTIPLYING_OPERATOR;
}

bool
IIRScram_MultiplicationOperator::_is_associative(IIR_Kind oper_kind){
  switch(oper_kind) {                         
  case IIR_REMAINDER_OPERATOR:                
  case IIR_MODULUS_OPERATOR:                
    return FALSE;                             
  default:
    return TRUE;                                                             
  }

}
