// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_CaseStatementAlternativeList.cc,v 1.2 1999/03/09 20:53:18 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_CaseStatementAlternativeList.hh"
#include "IIR_CaseStatementAlternative.hh"

IIRScram_CaseStatementAlternativeList::~IIRScram_CaseStatementAlternativeList() {}

void 
IIRScram_CaseStatementAlternativeList::_publish_cc() {
  IIR_CaseStatementAlternative *node;

  for (node = first(); node != NULL; node = successor(node)) {
    node->_publish_cc();
  }
}

void
IIRScram_CaseStatementAlternativeList::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  IIR_CaseStatementAlternative *node = first();
  for(; node != NULL; ) {
    node->_get_list_of_input_signals(list);
    node = successor(node);
  }
}


void
IIRScram_CaseStatementAlternativeList::_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  IIR_CaseStatementAlternative *stmt = first();

  while (stmt != NULL) {
    stmt->_build_wait_list(list);
    stmt = successor(stmt);
  }
}

void
IIRScram_CaseStatementAlternativeList::_get_signal_source_info(set<IIR_Declaration>* siginfo) {
  IIR_CaseStatementAlternative* stmt = first();
  for(; stmt != NULL; ) {
    stmt->_get_signal_source_info(siginfo);
    stmt = successor(stmt);
  }
}
