/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 * Preset code donated by Gregory Gulik (greg@gagme.com)
 */

#include <stdio.h>
#include <ctype.h>
#include "x10.h"
#include <string.h>
#include <stdlib.h>
#include <unistd.h>


extern int tty;
extern int sptty;
extern int verbose;
extern unsigned char cm11map[];

extern int usage(), dimstate(), xwrite(), chksum(), exread(), check4poll();
extern int c_turn();
extern void parse_unit();
extern unsigned int getunits();


/* Table for preset dim, which doesn't seem to follow the same format
 * as the other stuff.
 */
unsigned char presetmap[]=
{  1, 9, 5, 13, 3, 11, 7, 15,
   2, 10, 6, 14, 4, 12, 8, 16
};




int c_preset(argc, argv)
char *argv[];
{
    register int n;
    unsigned int hcode, unit, unitx10, bits;
    char *unitnums;
    unsigned sum;
    int timeout;
    static int numtries = 0;
    unsigned char buf[16], function=0;
    unsigned int preset=0, presetx10=0;

    char RCSID[]= "@(#) $Id: preset.c,v 1.5 1999/12/13 21:12:10 dbs Exp dbs $\n";

    display(RCSID);


    timeout = 10;

    if (argc != 4)
	    usage(E_WNA);

	
    if( argc > 2)
	parse_unit(argv[2],&hcode,&unitnums);

    /* What is our preset value?  It should be in argv[3] */
    preset = atoi(argv[3]);
    /* if (preset < 1 || preset > 32 ) { */
    if (preset < 0 || preset > 32 ) {
	fprintf(stderr, "Invalid preset number: %s\n", argv[3]);
	fprintf(stderr, "The preset value must be an integer range 1-32.\n");
	return(-1);
    }

    bits = getunits(unitnums);
    unit = atoi(unitnums);

    /* We want to go ahead and send the address command just
       just any other command   */

    /* Header */
    buf[0] = 0x04;	/* sync bit in header for address */

    /* Address */
    /* hcodex10 = cm11map[hcode - 1]; */
    unitx10 = cm11map[unit - 1];
    buf[1] = (hcode << 4 ) | unitx10 ;	/* code and unit */


    /* Write the address header */

    (void) xwrite(tty, (char *) buf, 2);

    /* get a check sum in reply */
    sum=chksum(buf,2) ;
    n = exread(sptty, buf, 1, timeout);
    if( sum == buf[0]) 
    {
	    (void) xwrite(tty, "\00" , 1);	/* WRMI (we really mean it) */
    }
    else
    {
	    if( ++numtries < 3 )
	        return(c_preset(argc, argv) );
	    fprintf(stderr, "Failure sending address header\n");
	    return(-1);
    }

    /*
     * Now we wait for the CM11A to send us the ready code before
     * we send the rest of the command.
     */

    buf[0] = 0;
    n = exread(sptty, buf, 1, timeout);
    if( n == 1 )
        if(buf[0] != 0x55 )
	{
	    if(buf[0] == 0x5a )
		if( ++numtries < 3 )
		{
		    sleep(1);
		    return(c_turn(argc, argv) );
		}
	    fprintf(stderr, "Ack after execution = %0x, It should be 0x55)\n",
	            buf[0]);
	    n = 0;
	}
    if(n != 1)
    {
	if( ++numtries < 3 )
	    return(c_turn(argc, argv) );
	fprintf(stderr,
	        "Interface not ready after excuting function (buf= %0x)\n",
		buf[0]);
	fprintf(stderr, "N = %0x)\n", n);
        return(-1);
    }


    /* Now we built the preset dim function */

    /* Use Pre-set Dim (1) for preset values 1-16 and Pre-set Dim (2) */
    /* for values 17-32                                               */
    if (preset < 17)
	function = 10;
    else {
	function = 11;
	preset -= 16;
    }


    buf[0] = 0x06;	/* sync bit & function flag in header for function */

    /* The preset level uses a different table
     * This table is used on the adjusted preset level (1-16) only
     */
    presetx10 = presetmap[preset - 1] - 1;
    /* presetx10 = preset - 1; FOR TESTING ONLY */
    buf[1] = (presetx10 << 4 ) | function ;	/* preset and function */
    if( verbose )
	fprintf(stderr, "Sending function %0x : %0x\n", buf[0], buf[1]); 
    (void) xwrite(tty, (char *) buf, 2);

    /* get a check sum in reply */
    sum=chksum(buf,2);
    n = exread(sptty, buf, 1, timeout);
    if( sum == buf[0]) 
    {
	(void) xwrite(tty, "\00" , 1);	/* WRMI */
    }
    else
    {
	if( ++numtries < 3 )
	{
	    sleep(1);
	    return(c_preset(argc, argv) );
	}
	fprintf(stderr, "failure sending function header sum = %0x,buf= %0x\n",
	        sum , buf[0]);
	fprintf(stderr, "N = %0x)\n", n);
        return(-1);
    }

    /*
     * Wait for that darned ready (0x55) command
     */
    buf[0] = 0;
    n = exread(sptty, buf, 1, timeout);
    if( n == 1 )
        if(buf[0] != 0x55 )
	{
	    if(buf[0] == 0x5a )
		if( ++numtries < 3 )
		{
		    sleep(1);
		    return(c_turn(argc, argv) );
		}
	    fprintf(stderr, "Ack after execution = %0x, It should be 0x55)\n",
	            buf[0]);
	    n = 0;
	}
    if(n != 1)
    {
	if( ++numtries < 3 )
	    return(c_turn(argc, argv) );
	fprintf(stderr,
	        "Interface not ready after excuting function (buf= %0x)\n",
		buf[0]);
	fprintf(stderr, "N = %0x)\n", n);
        return(-1);
    }
return(0);
}
